/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine.phases;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.IServiceUI;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.osgi.service.security.TrustEngine;
import org.eclipse.osgi.signedcontent.SignedContent;
import org.eclipse.osgi.signedcontent.SignedContentFactory;
import org.eclipse.osgi.signedcontent.SignerInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CertificateChecker {
    private ArrayList<File> artifacts;
    private final IProvisioningAgent agent;

    public CertificateChecker() {
        this(null);
    }

    public CertificateChecker(IProvisioningAgent agent) {
        this.agent = agent;
        this.artifacts = new ArrayList();
    }

    public IStatus start() {
        Class<?> clazz;
        Class<?> clazz2;
        BundleContext context = EngineActivator.getContext();
        try {
            clazz2 = Class.forName("org.eclipse.osgi.signedcontent.SignedContentFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ServiceReference contentFactoryRef = context.getServiceReference(clazz2.getName());
        SignedContentFactory verifierFactory = (SignedContentFactory)context.getService(contentFactoryRef);
        try {
            clazz = Class.forName("org.eclipse.osgi.service.security.TrustEngine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ServiceReference trustEngineRef = context.getServiceReference(clazz.getName());
        TrustEngine trustEngine = (TrustEngine)context.getService(trustEngineRef);
        try {
            IStatus iStatus = this.checkCertificates(trustEngine, verifierFactory);
            return iStatus;
        }
        finally {
            context.ungetService(contentFactoryRef);
            context.ungetService(trustEngineRef);
        }
    }

    private IStatus checkCertificates(TrustEngine trustEngine, SignedContentFactory verifierFactory) {
        int i;
        Certificate[][] unTrustedCertificateChains;
        String[] details;
        int i2;
        IServiceUI serviceUI = (IServiceUI)this.agent.getService(IServiceUI.SERVICE_NAME);
        SignedContent content = null;
        SignerInfo[] signerInfo = null;
        ArrayList<Certificate> untrusted = new ArrayList<Certificate>();
        ArrayList<File> unsigned = new ArrayList<File>();
        ArrayList<Certificate[]> untrustedChain = new ArrayList<Certificate[]>();
        IStatus status = Status.OK_STATUS;
        if (this.artifacts.size() == 0 || serviceUI == null) {
            return status;
        }
        Iterator<File> iterator = this.artifacts.iterator();
        while (iterator.hasNext()) {
            File artifact = iterator.next();
            try {
                content = verifierFactory.getSignedContent(artifact);
                if (!content.isSigned()) {
                    unsigned.add(artifact);
                    continue;
                }
                signerInfo = content.getSignerInfos();
            }
            catch (GeneralSecurityException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentError, (Throwable)e);
            }
            catch (IOException e) {
                return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_SignedContentIOError, (Throwable)e);
            }
            i2 = 0;
            while (i2 < signerInfo.length) {
                Certificate[] certificateChain = signerInfo[i2].getCertificateChain();
                try {
                    Certificate trustAnchor = trustEngine.findTrustAnchor(certificateChain);
                    if (trustAnchor == null && !untrusted.contains(certificateChain[0])) {
                        untrusted.add(certificateChain[0]);
                        untrustedChain.add(certificateChain);
                    }
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                }
                ++i2;
            }
        }
        String policy = this.getUnsignedContentPolicy();
        if (!unsigned.isEmpty() && "fail".equals(policy)) {
            return new Status(4, "org.eclipse.equinox.p2.engine", NLS.bind((String)Messages.CertificateChecker_UnsignedNotAllowed, unsigned));
        }
        if ("allow".equals(policy) || unsigned.isEmpty()) {
            details = null;
        } else {
            details = new String[unsigned.size()];
            i2 = 0;
            while (i2 < details.length) {
                details[i2] = ((File)unsigned.get(i2)).toString();
                ++i2;
            }
        }
        if (untrusted.isEmpty()) {
            unTrustedCertificateChains = null;
        } else {
            unTrustedCertificateChains = new Certificate[untrustedChain.size()][];
            int i3 = 0;
            while (i3 < untrustedChain.size()) {
                unTrustedCertificateChains[i3] = (Certificate[])untrustedChain.get(i3);
                ++i3;
            }
        }
        if (details == null && unTrustedCertificateChains == null) {
            return status;
        }
        IServiceUI.TrustInfo trustInfo = serviceUI.getTrustInfo(unTrustedCertificateChains, details);
        if (!trustInfo.trustUnsignedContent()) {
            return Status.CANCEL_STATUS;
        }
        Certificate[] trustedCertificates = trustInfo.getTrustedCertificates();
        if (unTrustedCertificateChains != null && trustedCertificates == null) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustedCertificates != null) {
            i = 0;
            while (i < trustedCertificates.length) {
                untrusted.remove(trustedCertificates[i]);
                ++i;
            }
        }
        if (untrusted.size() > 0) {
            return new Status(8, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateRejected);
        }
        if (trustInfo.persistTrust()) {
            i = 0;
            while (i < trustedCertificates.length) {
                try {
                    trustEngine.addTrustAnchor(trustedCertificates[i], trustedCertificates[i].toString());
                }
                catch (IOException e) {
                    return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_KeystoreConnectionError, (Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    return new Status(1, "org.eclipse.equinox.p2.engine", Messages.CertificateChecker_CertificateError, (Throwable)e);
                }
                ++i;
            }
        }
        return status;
    }

    private String getUnsignedContentPolicy() {
        String policy = EngineActivator.getContext().getProperty("eclipse.p2.unsignedPolicy");
        if (policy == null) {
            policy = "prompt";
        }
        return policy;
    }

    public void add(File toAdd) {
        this.artifacts.add(toAdd);
    }

    public void add(Object[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            if (toAdd[i] instanceof File) {
                this.add((File)toAdd[i]);
            }
            ++i;
        }
    }
}

