/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.AttachmentHelper;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.OperationGenerator;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.internal.p2.rollback.FormerState;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.RequestStatus;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.p2.engine.Operand;
import org.eclipse.equinox.p2.engine.PropertyOperand;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.ProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.IUProfilePropertyQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.query.ExpressionQuery;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.LimitQuery;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePlanner
implements IPlanner {
    private static boolean DEBUG = Tracing.DEBUG_PLANNER_OPERANDS;
    private static final int ExpandWork = 12;
    private static final String INCLUDE_PROFILE_IUS = "org.eclipse.equinox.p2.internal.profileius";
    public static final String INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    private static final String ID_IU_FOR_ACTIONS = "org.eclipse.equinox.p2.engine.actions.root";
    private static final String EXPLANATION = "org.eclipse.equinox.p2.director.explain";
    private static final String CONSIDER_METAREQUIREMENTS = "org.eclipse.equinox.p2.planner.resolveMetaRequirements";
    private final IMetadataRepositoryManager repoManager;
    private final IProfileRegistry profileRegistry;

    private ProvisioningPlan generateProvisioningPlan(Collection<IInstallableUnit> fromState, Collection<IInstallableUnit> toState, ProfileChangeRequest changeRequest, IProvisioningPlan installerPlan, ProvisioningContext context) {
        List<InstallableUnitOperand> iuOperands = this.generateOperations(fromState, toState);
        PropertyOperand[] propertyOperands = this.generatePropertyOperations(changeRequest);
        int iuOpsSize = iuOperands.size();
        Operand[] operands = new Operand[iuOpsSize + propertyOperands.length];
        int i = 0;
        while (i < iuOpsSize) {
            operands[i] = (Operand)iuOperands.get(i);
            ++i;
        }
        System.arraycopy(propertyOperands, 0, operands, iuOpsSize, propertyOperands.length);
        if (DEBUG) {
            i = 0;
            while (i < operands.length) {
                Tracing.debug((String)operands[i].toString());
                ++i;
            }
        }
        return new ProvisioningPlan(Status.OK_STATUS, operands, (Map[])this.computeActualChangeRequest(toState, changeRequest), null, installerPlan, changeRequest.getProfile(), (IQueryable)new QueryableArray(toState.toArray(new IInstallableUnit[toState.size()])), context);
    }

    private Map<IInstallableUnit, IStatus>[] buildDetailedErrors(ProfileChangeRequest changeRequest) {
        IInstallableUnit[] added = changeRequest.getAddedInstallableUnits();
        IInstallableUnit[] removed = changeRequest.getRemovedInstallableUnits();
        HashMap<IInstallableUnit, RequestStatus> requestStatus = new HashMap<IInstallableUnit, RequestStatus>(added.length + removed.length);
        int i = 0;
        while (i < added.length) {
            requestStatus.put(added[i], new RequestStatus(added[i], 0, 4, null));
            ++i;
        }
        i = 0;
        while (i < removed.length) {
            requestStatus.put(removed[i], new RequestStatus(removed[i], 1, 4, null));
            ++i;
        }
        Map[] mapArray = new Map[2];
        mapArray[0] = requestStatus;
        Map[] maps = mapArray;
        return maps;
    }

    private Map<IInstallableUnit, IStatus>[] computeActualChangeRequest(Collection<IInstallableUnit> toState, ProfileChangeRequest changeRequest) {
        IInstallableUnit[] added = changeRequest.getAddedInstallableUnits();
        IInstallableUnit[] removed = changeRequest.getRemovedInstallableUnits();
        HashMap<IInstallableUnit, RequestStatus> requestStatus = new HashMap<IInstallableUnit, RequestStatus>(added.length + removed.length);
        int i = 0;
        while (i < added.length) {
            if (toState.contains(added[i])) {
                requestStatus.put(added[i], new RequestStatus(added[i], 0, 0, null));
            } else {
                requestStatus.put(added[i], new RequestStatus(added[i], 0, 4, null));
            }
            ++i;
        }
        i = 0;
        while (i < removed.length) {
            if (!toState.contains(removed[i])) {
                requestStatus.put(removed[i], new RequestStatus(removed[i], 1, 0, null));
            } else {
                requestStatus.put(removed[i], new RequestStatus(removed[i], 1, 4, null));
            }
            ++i;
        }
        Iterator includedIUs = changeRequest.getProfile().query((IQuery)new IUProfilePropertyQuery(INCLUSION_RULES, null), null).iterator();
        HashMap<IInstallableUnit, RequestStatus> sideEffectStatus = new HashMap<IInstallableUnit, RequestStatus>();
        while (includedIUs.hasNext()) {
            IInstallableUnit removal = (IInstallableUnit)includedIUs.next();
            if (toState.contains(removal) || requestStatus.containsKey(removal)) continue;
            sideEffectStatus.put(removal, new RequestStatus(removal, 1, 1, null));
        }
        Map[] maps = new Map[]{requestStatus, sideEffectStatus};
        return maps;
    }

    private IStatus convertExplanationToStatus(Set<Explanation> explanations) {
        if (explanations == null) {
            return new Status(4, "org.eclipse.equinox.p2.director", Messages.Director_Unsatisfied_Dependencies);
        }
        MultiStatus root = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Director_Unsatisfied_Dependencies, null);
        String specificMessage = null;
        for (Explanation next : explanations) {
            root.add(next.toStatus());
            if (specificMessage == null && next instanceof Explanation.MissingIU) {
                specificMessage = Messages.Explanation_rootMissing;
                continue;
            }
            if (specificMessage != null || !(next instanceof Explanation.Singleton)) continue;
            specificMessage = Messages.Explanation_rootSingleton;
        }
        if (specificMessage != null) {
            MultiStatus newRoot = new MultiStatus("org.eclipse.equinox.p2.director", 1, specificMessage, null);
            newRoot.merge((IStatus)root);
            root = newRoot;
        }
        return root;
    }

    private PropertyOperand[] generatePropertyOperations(ProfileChangeRequest profileChangeRequest) {
        IProfile profile = profileChangeRequest.getProfile();
        ArrayList<Object> operands = new ArrayList<Object>();
        String[] toRemove = profileChangeRequest.getPropertiesToRemove();
        Map existingProperties = profile.getProperties();
        int i = 0;
        while (i < toRemove.length) {
            if (existingProperties.containsKey(toRemove[i])) {
                operands.add(new PropertyOperand(toRemove[i], existingProperties.get(toRemove[i]), null));
            }
            ++i;
        }
        Map<String, String> propertyChanges = profileChangeRequest.getPropertiesToAdd();
        for (Map.Entry<String, String> entry : propertyChanges.entrySet()) {
            operands.add(new PropertyOperand(entry.getKey(), existingProperties.get(entry.getKey()), (Object)entry.getValue()));
        }
        Map<IInstallableUnit, Map<String, String>> allIUPropertyChanges = profileChangeRequest.getInstallableUnitProfilePropertiesToAdd();
        for (Map.Entry<IInstallableUnit, Map<String, String>> entry : allIUPropertyChanges.entrySet()) {
            IInstallableUnit iu = entry.getKey();
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                String oldValue = profile.getInstallableUnitProperty(iu, entry2.getKey());
                operands.add(new InstallableUnitPropertyOperand(iu, entry2.getKey(), (Object)oldValue, (Object)entry2.getValue()));
            }
        }
        Map<IInstallableUnit, List<String>> allIUPropertyDeletions = profileChangeRequest.getInstallableUnitProfilePropertiesToRemove();
        for (Map.Entry<IInstallableUnit, List<String>> entry : allIUPropertyDeletions.entrySet()) {
            IInstallableUnit iu = entry.getKey();
            Map existingIUProperties = profile.getInstallableUnitProperties(iu);
            List<String> iuPropertyRemovals = entry.getValue();
            for (String key : iuPropertyRemovals) {
                if (!existingIUProperties.containsKey(key)) continue;
                operands.add(new InstallableUnitPropertyOperand(iu, key, existingIUProperties.get(key), null));
            }
        }
        return operands.toArray(new PropertyOperand[operands.size()]);
    }

    private List<InstallableUnitOperand> generateOperations(Collection<IInstallableUnit> fromState, Collection<IInstallableUnit> toState) {
        return new OperationGenerator().generateOperation(fromState, toState);
    }

    @Override
    public IProvisioningPlan getDiffPlan(IProfile currentProfile, IProfile targetProfile, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            Class<?> clazz;
            ProfileChangeRequest profileChangeRequest = FormerState.generateProfileDeltaChangeRequest(currentProfile, targetProfile);
            ProvisioningContext context = new ProvisioningContext(new URI[0]);
            if (context.getProperty(INCLUDE_PROFILE_IUS) == null) {
                context.setProperty(INCLUDE_PROFILE_IUS, Boolean.FALSE.toString());
            }
            try {
                clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            context.setExtraIUs(Arrays.asList((IInstallableUnit[])targetProfile.available((IQuery)InstallableUnitQuery.ANY, null).toArray(clazz)));
            IProvisioningPlan iProvisioningPlan = this.getProvisioningPlan(profileChangeRequest, context, (IProgressMonitor)sub.newChild(6));
            return iProvisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    public static IInstallableUnit[] findPlannerMarkedIUs(IProfile profile) {
        Class<?> clazz;
        IUProfilePropertyQuery markerQuery = new IUProfilePropertyQuery(INCLUSION_RULES, null);
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (IInstallableUnit[])profile.query((IQuery)markerQuery, null).toArray(clazz);
    }

    public static Dictionary<String, String> createSelectionContext(Map<String, String> properties) {
        Hashtable<String, String> result = new Hashtable<String, String>(properties);
        String environments = properties.get("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            int i = entry.indexOf(61);
            String key = entry.substring(0, i).trim();
            String value = entry.substring(i + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    private IInstallableUnit[] gatherAvailableInstallableUnits(IInstallableUnit[] additionalSource, URI[] repositories, ProvisioningContext context, IProgressMonitor monitor) {
        HashMap<Object, IInstallableUnit> resultsMap = new HashMap<Object, IInstallableUnit>();
        if (additionalSource != null) {
            int i = 0;
            while (i < additionalSource.length) {
                String key = new StringBuffer(String.valueOf(additionalSource[i].getId())).append("_").append(additionalSource[i].getVersion().toString()).toString();
                resultsMap.put(key, additionalSource[i]);
                ++i;
            }
        }
        if (context != null) {
            for (IInstallableUnit iu : context.getExtraIUs()) {
                String key = new StringBuffer(String.valueOf(iu.getId())).append('_').append(iu.getVersion().toString()).toString();
                resultsMap.put(key, iu);
            }
        }
        if (repositories == null) {
            repositories = this.repoManager.getKnownRepositories(0);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 200));
        int i = 0;
        while (i < repositories.length) {
            try {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IMetadataRepository repository = this.repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                IQueryResult matches = repository.query((IQuery)new InstallableUnitQuery(null, VersionRange.emptyRange), (IProgressMonitor)sub.newChild(100));
                for (IInstallableUnit iu : matches) {
                    String key = new StringBuffer(String.valueOf(iu.getId())).append("_").append(iu.getVersion().toString()).toString();
                    IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
                    if (currentIU != null && !SimplePlanner.hasHigherFidelity(iu, currentIU)) continue;
                    resultsMap.put(key, iu);
                }
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        Collection results = resultsMap.values();
        return results.toArray(new IInstallableUnit[results.size()]);
    }

    private static boolean hasHigherFidelity(IInstallableUnit iu, IInstallableUnit currentIU) {
        return Boolean.valueOf(currentIU.getProperty("org.eclipse.equinox.p2.partial.iu")) != false && Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")) == false;
    }

    public SimplePlanner(IProfileRegistry profileRegistry, IMetadataRepositoryManager repoManager) {
        Assert.isNotNull((Object)profileRegistry);
        Assert.isNotNull((Object)repoManager);
        this.profileRegistry = profileRegistry;
        this.repoManager = repoManager;
    }

    private boolean satisfyMetaRequirements(Map<String, String> props) {
        if (props == null) {
            return true;
        }
        return props.get(CONSIDER_METAREQUIREMENTS) == null || "true".equalsIgnoreCase(props.get(CONSIDER_METAREQUIREMENTS));
    }

    private boolean satisfyMetaRequirements(IProfile p) {
        return this.satisfyMetaRequirements(p.getProperties());
    }

    private Object getSolutionFor(ProfileChangeRequest profileChangeRequest, ProvisioningContext context, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            IInstallableUnit[] availableIUs;
            Slicer slicer;
            IQueryable<IInstallableUnit> slice;
            IProfile profile = profileChangeRequest.getProfile();
            Object[] updatedPlan = this.updatePlannerInfo(profileChangeRequest, context);
            URI[] metadataRepositories = context != null ? context.getMetadataRepositories() : null;
            Dictionary<String, String> newSelectionContext = SimplePlanner.createSelectionContext(profileChangeRequest.getProfileProperties());
            ArrayList<IInstallableUnit> extraIUs = new ArrayList<IInstallableUnit>(Arrays.asList(profileChangeRequest.getAddedInstallableUnits()));
            extraIUs.addAll(Arrays.asList(profileChangeRequest.getRemovedInstallableUnits()));
            if (context == null || context.getProperty(INCLUDE_PROFILE_IUS) == null || context.getProperty(INCLUDE_PROFILE_IUS).equalsIgnoreCase(Boolean.TRUE.toString())) {
                Iterator itor = profile.available((IQuery)InstallableUnitQuery.ANY, null).iterator();
                while (itor.hasNext()) {
                    extraIUs.add((IInstallableUnit)itor.next());
                }
            }
            if ((slice = (slicer = new Slicer(new QueryableArray(availableIUs = this.gatherAvailableInstallableUnits(extraIUs.toArray(new IInstallableUnit[extraIUs.size()]), metadataRepositories, context, (IProgressMonitor)sub.newChild(3))), newSelectionContext, this.satisfyMetaRequirements(profileChangeRequest.getProfileProperties()))).slice(new IInstallableUnit[]{(IInstallableUnit)updatedPlan[0]}, (IProgressMonitor)sub.newChild(3))) == null) {
                ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)slicer.getStatus(), profile, null, context);
                return provisioningPlan;
            }
            Projector projector = new Projector(slice, newSelectionContext, this.satisfyMetaRequirements(profileChangeRequest.getProfileProperties()));
            projector.encode((IInstallableUnit)updatedPlan[0], (IInstallableUnit[])updatedPlan[1], (IQueryable<IInstallableUnit>)profile, profileChangeRequest.getAddedInstallableUnits(), (IProgressMonitor)sub.newChild(3));
            IStatus s = projector.invokeSolver((IProgressMonitor)sub.newChild(3));
            if (s.getSeverity() == 8) {
                ProvisioningPlan provisioningPlan = new ProvisioningPlan(s, profile, null, context);
                return provisioningPlan;
            }
            if (s.getSeverity() == 4) {
                sub.setTaskName(Messages.Planner_NoSolution);
                if (context != null && context.getProperty(EXPLANATION) != null && !Boolean.TRUE.toString().equalsIgnoreCase(context.getProperty(EXPLANATION))) {
                    ProvisioningPlan provisioningPlan = new ProvisioningPlan(s, profile, null, context);
                    return provisioningPlan;
                }
                Set<Explanation> explanation = projector.getExplanation((IProgressMonitor)sub.newChild(3));
                IStatus explanationStatus = this.convertExplanationToStatus(explanation);
                ProvisioningPlan provisioningPlan = new ProvisioningPlan(explanationStatus, new Operand[0], (Map[])this.buildDetailedErrors(profileChangeRequest), (IStatus)new RequestStatus(null, 1, 4, explanation), null, profile, null, context);
                return provisioningPlan;
            }
            if (Tracing.DEBUG && s.getSeverity() != 0) {
                LogHelper.log((IStatus)s);
            }
            s = Status.OK_STATUS;
            Projector projector2 = projector;
            return projector2;
        }
        finally {
            sub.done();
        }
    }

    @Override
    public IProvisioningPlan getProvisioningPlan(ProfileChangeRequest profileChangeRequest, ProvisioningContext context, IProgressMonitor monitor) {
        if (profileChangeRequest.getAbsolute()) {
            return this.generateAbsoluteProvisioningPlan(profileChangeRequest, context, monitor);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            Object resolutionResult = this.getSolutionFor(profileChangeRequest, context, (IProgressMonitor)sub.newChild(6));
            if (resolutionResult instanceof IProvisioningPlan) {
                ProvisioningPlan provisioningPlan = (ProvisioningPlan)resolutionResult;
                return provisioningPlan;
            }
            Collection<IInstallableUnit> newState = ((Projector)resolutionResult).extractSolution();
            ArrayList<IInstallableUnit> fullState = new ArrayList<IInstallableUnit>();
            fullState.addAll(newState);
            newState = AttachmentHelper.attachFragments(newState.iterator(), ((Projector)resolutionResult).getFragmentAssociation());
            ProvisioningPlan temporaryPlan = this.generatePlan((Projector)resolutionResult, newState, profileChangeRequest, context);
            ProvisioningPlan provisioningPlan = this.createInstallerPlan(profileChangeRequest.getProfile(), profileChangeRequest, fullState, newState, temporaryPlan, context, (IProgressMonitor)sub.newChild(6));
            return provisioningPlan;
        }
        catch (OperationCanceledException operationCanceledException) {
            ProvisioningPlan provisioningPlan = new ProvisioningPlan(Status.CANCEL_STATUS, profileChangeRequest.getProfile(), null, context);
            return provisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    private IProvisioningPlan generateAbsoluteProvisioningPlan(ProfileChangeRequest profileChangeRequest, ProvisioningContext context, IProgressMonitor monitor) {
        Set toState = profileChangeRequest.getProfile().query((IQuery)InstallableUnitQuery.ANY, null).toSet();
        HashSet<IInstallableUnit> fromState = new HashSet<IInstallableUnit>(toState);
        toState.removeAll(Arrays.asList(profileChangeRequest.getRemovedInstallableUnits()));
        toState.addAll(Arrays.asList(profileChangeRequest.getAddedInstallableUnits()));
        List<InstallableUnitOperand> iuOperands = this.generateOperations(fromState, toState);
        PropertyOperand[] propertyOperands = this.generatePropertyOperations(profileChangeRequest);
        int iuOpsSize = iuOperands.size();
        Operand[] operands = new Operand[iuOpsSize + propertyOperands.length];
        int i = 0;
        while (i < iuOpsSize) {
            operands[i] = (Operand)iuOperands.get(i);
            ++i;
        }
        System.arraycopy(propertyOperands, 0, operands, iuOpsSize, propertyOperands.length);
        if (DEBUG) {
            i = 0;
            while (i < operands.length) {
                Tracing.debug((String)operands[i].toString());
                ++i;
            }
        }
        return new ProvisioningPlan(Status.OK_STATUS, operands, (Map[])this.computeActualChangeRequest(toState, profileChangeRequest), null, null, profileChangeRequest.getProfile(), (IQueryable)new QueryableArray(toState.toArray(new IInstallableUnit[toState.size()])), context);
    }

    private Collection<IRequirement> areMetaRequirementsSatisfied(IProfile oldProfile, Collection<IInstallableUnit> newProfile, IProvisioningPlan initialPlan) {
        Collection<IRequirement> allMetaRequirements = this.extractMetaRequirements(newProfile, initialPlan);
        for (IRequirement requirement : allMetaRequirements) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!oldProfile.query((IQuery)new LimitQuery((IQuery)new ExpressionQuery(clazz, requirement.getMatches()), 1), null).isEmpty()) continue;
            return allMetaRequirements;
        }
        return null;
    }

    private Collection<IRequirement> extractMetaRequirements(Collection<IInstallableUnit> ius, IProvisioningPlan plan) {
        HashSet<IRequirement> allMetaRequirements = new HashSet<IRequirement>();
        for (IInstallableUnit iu : ius) {
            allMetaRequirements.addAll(iu.getMetaRequiredCapabilities());
        }
        IQueryResult queryResult = plan.getRemovals().query((IQuery)InstallableUnitQuery.ANY, null);
        for (IInstallableUnit iu : queryResult) {
            allMetaRequirements.addAll(iu.getMetaRequiredCapabilities());
        }
        return allMetaRequirements;
    }

    private ProvisioningPlan createInstallerPlan(IProfile profile, ProfileChangeRequest initialRequest, Collection<IInstallableUnit> unattachedState, Collection<IInstallableUnit> expectedState, ProvisioningPlan initialPlan, ProvisioningContext initialContext, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        try {
            sub.setTaskName(Messages.Director_Task_installer_plan);
            if (this.profileRegistry == null) {
                ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)new Status(4, "org.eclipse.equinox.p2.director", Messages.Planner_no_profile_registry), profile, null, initialContext);
                return provisioningPlan;
            }
            IProfile agentProfile = this.profileRegistry.getProfile("_SELF_");
            if (agentProfile == null) {
                ProvisioningPlan provisioningPlan = initialPlan;
                return provisioningPlan;
            }
            if (profile.getProfileId().equals(agentProfile.getProfileId())) {
                if (profile.getTimestamp() != agentProfile.getTimestamp()) {
                    ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_profile_out_of_sync, (Object)profile.getProfileId())), profile, null, initialContext);
                    return provisioningPlan;
                }
                ProvisioningPlan provisioningPlan = this.createInstallerPlanForCohostedCase(profile, initialRequest, initialPlan, unattachedState, expectedState, initialContext, sub);
                return provisioningPlan;
            }
            if (this.satisfyMetaRequirements(profile) && !profile.getProfileId().equals(agentProfile.getProfileId())) {
                ProvisioningPlan provisioningPlan = this.createInstallerPlanForCohostedCaseFromExternalInstaller(profile, initialRequest, (IProvisioningPlan)initialPlan, expectedState, initialContext, agentProfile, sub);
                return provisioningPlan;
            }
            ProvisioningPlan provisioningPlan = this.createInstallerPlanForExternalInstaller(profile, initialRequest, initialPlan, expectedState, initialContext, agentProfile, sub);
            return provisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    private ProvisioningPlan createInstallerPlanForCohostedCaseFromExternalInstaller(IProfile profile, ProfileChangeRequest initialRequest, IProvisioningPlan initialPlan, Collection<IInstallableUnit> newState, ProvisioningContext initialContext, IProfile agentProfile, SubMonitor sub) {
        ProvisioningPlan planForProfile = this.generatePlan(null, newState, initialRequest, initialContext);
        return this.createInstallerPlanForExternalInstaller(profile, initialRequest, planForProfile, newState, initialContext, agentProfile, sub);
    }

    private ProvisioningPlan createInstallerPlanForExternalInstaller(IProfile targetedProfile, ProfileChangeRequest initialRequest, ProvisioningPlan initialPlan, Collection<IInstallableUnit> expectedState, ProvisioningContext initialContext, IProfile agentProfile, SubMonitor sub) {
        Object externalInstallerPlan;
        Collection<IRequirement> metaRequirements = this.areMetaRequirementsSatisfied(agentProfile, expectedState, (IProvisioningPlan)initialPlan);
        if (metaRequirements == null) {
            return initialPlan;
        }
        IInstallableUnit actionsIU = this.createIUForMetaRequirements(targetedProfile, metaRequirements);
        IInstallableUnit previousActionsIU = this.getPreviousIUForMetaRequirements(agentProfile, this.getActionGatheringIUId(targetedProfile), (IProgressMonitor)sub);
        ProfileChangeRequest agentRequest = new ProfileChangeRequest(agentProfile);
        agentRequest.addInstallableUnits(new IInstallableUnit[]{actionsIU});
        if (previousActionsIU != null) {
            agentRequest.removeInstallableUnit(previousActionsIU);
        }
        if ((externalInstallerPlan = this.getSolutionFor(agentRequest, initialContext, (IProgressMonitor)sub.newChild(10))) instanceof IProvisioningPlan && ((IProvisioningPlan)externalInstallerPlan).getStatus().getSeverity() == 4) {
            MultiStatus externalInstallerStatus = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_can_not_install_preq, null);
            externalInstallerStatus.add(((IProvisioningPlan)externalInstallerPlan).getStatus());
            return new ProvisioningPlan((IStatus)externalInstallerStatus, initialRequest.getProfile(), (IProvisioningPlan)new ProvisioningPlan((IStatus)externalInstallerStatus, agentProfile, null, initialContext), initialContext);
        }
        initialPlan.setInstallerPlan((IProvisioningPlan)this.generatePlan((Projector)externalInstallerPlan, null, agentRequest, initialContext));
        return initialPlan;
    }

    private ProvisioningPlan createInstallerPlanForCohostedCase(IProfile profile, ProfileChangeRequest initialRequest, ProvisioningPlan initialPlan, Collection<IInstallableUnit> unattachedState, Collection<IInstallableUnit> expectedState, ProvisioningContext initialContext, SubMonitor monitor) {
        Collection<IRequirement> metaRequirements;
        Collection<IRequirement> collection = metaRequirements = initialRequest.getRemovedInstallableUnits().length == 0 ? this.areMetaRequirementsSatisfied(profile, expectedState, (IProvisioningPlan)initialPlan) : this.extractMetaRequirements(expectedState, (IProvisioningPlan)initialPlan);
        if (metaRequirements == null || metaRequirements.isEmpty()) {
            return initialPlan;
        }
        IInstallableUnit metaRequirementIU = this.createIUForMetaRequirements(profile, metaRequirements);
        IInstallableUnit previousMetaRequirementIU = this.getPreviousIUForMetaRequirements(profile, this.getActionGatheringIUId(profile), (IProgressMonitor)monitor);
        ProfileChangeRequest agentRequest = new ProfileChangeRequest(profile);
        for (Map.Entry<String, String> entry : initialRequest.getPropertiesToAdd().entrySet()) {
            agentRequest.setProfileProperty(entry.getKey(), entry.getValue());
        }
        String[] removedProperties = initialRequest.getPropertiesToRemove();
        int i = 0;
        while (i < removedProperties.length) {
            agentRequest.removeProfileProperty(removedProperties[i]);
            ++i;
        }
        Map<IInstallableUnit, List<String>> removedIUProperties = initialRequest.getInstallableUnitProfilePropertiesToRemove();
        for (Map.Entry<IInstallableUnit, List<String>> entry : removedIUProperties.entrySet()) {
            for (String propKey : entry.getValue()) {
                agentRequest.removeInstallableUnitProfileProperty(entry.getKey(), propKey);
            }
        }
        if (previousMetaRequirementIU != null) {
            agentRequest.removeInstallableUnit(previousMetaRequirementIU);
        }
        agentRequest.addInstallableUnits(new IInstallableUnit[]{metaRequirementIU});
        ProvisioningContext agentCtx = new ProvisioningContext(new URI[0]);
        ArrayList<IInstallableUnit> extraIUs = new ArrayList<IInstallableUnit>(unattachedState);
        agentCtx.setExtraIUs(extraIUs);
        Object agentSolution = this.getSolutionFor(agentRequest, agentCtx, (IProgressMonitor)monitor.newChild(3));
        if (agentSolution instanceof IProvisioningPlan && ((IProvisioningPlan)agentSolution).getStatus().getSeverity() == 4) {
            MultiStatus agentStatus = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_actions_and_software_incompatible, null);
            agentStatus.add(((IProvisioningPlan)agentSolution).getStatus());
            return new ProvisioningPlan((IStatus)agentStatus, initialRequest.getProfile(), (IProvisioningPlan)new ProvisioningPlan((IStatus)agentStatus, agentRequest.getProfile(), null, initialContext), initialContext);
        }
        Collection<IInstallableUnit> agentState = ((Projector)agentSolution).extractSolution();
        agentState.remove(metaRequirementIU);
        agentState = AttachmentHelper.attachFragments(agentState.iterator(), ((Projector)agentSolution).getFragmentAssociation());
        ProvisioningContext noRepoContext = this.createNoRepoContext(initialRequest);
        Object initialSolution = this.getSolutionFor(new ProfileChangeRequest(new EverythingOptionalProfile(initialRequest.getProfile())), noRepoContext, (IProgressMonitor)new NullProgressMonitor());
        if (initialSolution instanceof IProvisioningPlan) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director", new StringBuffer("The resolution of the previous state contained in profile ").append(initialRequest.getProfile().getProfileId()).append(" version ").append(initialRequest.getProfile().getTimestamp()).append(" failed.").toString()));
            return (ProvisioningPlan)initialSolution;
        }
        Iterator profileState = initialRequest.getProfile().query((IQuery)InstallableUnitQuery.ANY, null).iterator();
        Collection<IInstallableUnit> initialState = AttachmentHelper.attachFragments(profileState, ((Projector)initialSolution).getFragmentAssociation());
        ProvisioningPlan agentPlan = this.generateProvisioningPlan(initialState, agentState, initialRequest, null, initialContext);
        return this.generateProvisioningPlan(agentState, expectedState, initialRequest, (IProvisioningPlan)agentPlan, initialContext);
    }

    private ProvisioningPlan generatePlan(Projector newSolution, Collection<IInstallableUnit> newState, ProfileChangeRequest request, ProvisioningContext context) {
        if (newState == null) {
            newState = newSolution.extractSolution();
            newState = AttachmentHelper.attachFragments(newState.iterator(), newSolution.getFragmentAssociation());
        }
        ProvisioningContext noRepoContext = this.createNoRepoContext(request);
        Object initialSolution = this.getSolutionFor(new ProfileChangeRequest(new EverythingOptionalProfile(request.getProfile())), noRepoContext, (IProgressMonitor)new NullProgressMonitor());
        if (initialSolution instanceof IProvisioningPlan) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director", new StringBuffer("The resolution of the previous state contained in profile ").append(request.getProfile().getProfileId()).append(" version ").append(request.getProfile().getTimestamp()).append(" failed.").toString()));
            return (ProvisioningPlan)initialSolution;
        }
        Iterator profileState = request.getProfile().query((IQuery)InstallableUnitQuery.ANY, null).iterator();
        Collection<IInstallableUnit> initialState = AttachmentHelper.attachFragments(profileState, ((Projector)initialSolution).getFragmentAssociation());
        return this.generateProvisioningPlan(initialState, newState, request, null, context);
    }

    private ProvisioningContext createNoRepoContext(ProfileChangeRequest request) {
        ProvisioningContext noRepoContext = new ProvisioningContext(new URI[0]);
        noRepoContext.setArtifactRepositories(new URI[0]);
        noRepoContext.setProperty(INCLUDE_PROFILE_IUS, Boolean.FALSE.toString());
        noRepoContext.setExtraIUs(new ArrayList(request.getProfile().query((IQuery)InstallableUnitQuery.ANY, (IProgressMonitor)new NullProgressMonitor()).unmodifiableSet()));
        return noRepoContext;
    }

    private IInstallableUnit getPreviousIUForMetaRequirements(IProfile profile, String iuId, IProgressMonitor monitor) {
        IQueryResult c = profile.query((IQuery)new InstallableUnitQuery(iuId), monitor);
        if (c.isEmpty()) {
            return null;
        }
        return (IInstallableUnit)c.iterator().next();
    }

    private String getActionGatheringIUId(IProfile profile) {
        return new StringBuffer("org.eclipse.equinox.p2.engine.actions.root.").append(profile.getProfileId()).toString();
    }

    private IInstallableUnit createIUForMetaRequirements(IProfile profile, Collection<IRequirement> metaRequirements) {
        MetadataFactory.InstallableUnitDescription description = new MetadataFactory.InstallableUnitDescription();
        String id = this.getActionGatheringIUId(profile);
        description.setId(id);
        Version version = Version.createOSGi((int)1, (int)0, (int)0, (String)Long.toString(profile.getTimestamp()));
        description.setVersion(version);
        description.addRequiredCapabilities(metaRequirements);
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        IProvidedCapability providedCapability = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (Version)version);
        providedCapabilities.add(providedCapability);
        description.addProvidedCapabilities(providedCapabilities);
        IInstallableUnit actionsIU = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)description);
        return actionsIU;
    }

    private IInstallableUnit createIURepresentingTheProfile(ArrayList<IRequirement> allRequirements) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        iud.setId(time);
        iud.setVersion(Version.createOSGi((int)0, (int)0, (int)0, (String)time));
        iud.setRequiredCapabilities(allRequirements.toArray(new IRequirement[allRequirements.size()]));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
    }

    private Object[] updatePlannerInfo(ProfileChangeRequest profileChangeRequest, ProvisioningContext context) {
        Class<?> clazz;
        int i;
        IQueryResult alreadyInstalled = profileChangeRequest.getProfile().query((IQuery)new IUProfilePropertyQuery(INCLUSION_RULES, null), null);
        IInstallableUnit[] added = profileChangeRequest.getAddedInstallableUnits();
        IInstallableUnit[] removed = profileChangeRequest.getRemovedInstallableUnits();
        for (Map.Entry<IInstallableUnit, List<String>> object : profileChangeRequest.getInstallableUnitProfilePropertiesToRemove().entrySet()) {
            if (!object.getValue().contains(INCLUSION_RULES)) continue;
            profileChangeRequest.setInstallableUnitProfileProperty(object.getKey(), INCLUSION_RULES, PlannerHelper.createStrictInclusionRule(object.getKey()));
        }
        if (removed.length != 0) {
            Iterator iterator = alreadyInstalled.iterator();
            block3: while (iterator.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)iterator.next();
                i = 0;
                while (i < removed.length) {
                    if (iu.equals((Object)removed[i])) {
                        profileChangeRequest.removeInstallableUnitProfileProperty(removed[i], INCLUSION_RULES);
                        iterator.remove();
                        continue block3;
                    }
                    ++i;
                }
            }
        }
        ArrayList<IRequirement> gatheredRequirements = new ArrayList<IRequirement>();
        Map<IInstallableUnit, Map<String, String>> iuPropertiesToAdd = profileChangeRequest.getInstallableUnitProfilePropertiesToAdd();
        i = 0;
        while (i < added.length) {
            Map<String, String> propertiesForIU = iuPropertiesToAdd.get(added[i]);
            IRequirement profileRequirement = null;
            if (propertiesForIU != null) {
                profileRequirement = this.createRequirement(added[i], propertiesForIU.get(INCLUSION_RULES));
            }
            if (profileRequirement == null) {
                profileChangeRequest.setInstallableUnitProfileProperty(added[i], INCLUSION_RULES, PlannerHelper.createStrictInclusionRule(added[i]));
                profileRequirement = this.createStrictRequirement(added[i]);
            }
            gatheredRequirements.add(profileRequirement);
            ++i;
        }
        for (IInstallableUnit iu : alreadyInstalled) {
            Map<String, String> propertiesForIU = iuPropertiesToAdd.get(iu);
            IRequirement profileRequirement = null;
            if (propertiesForIU != null) {
                profileRequirement = this.createRequirement(iu, propertiesForIU.get(INCLUSION_RULES));
            }
            if (profileRequirement == null) {
                profileRequirement = this.createRequirement(iu, profileChangeRequest.getProfile().getInstallableUnitProperty(iu, INCLUSION_RULES));
            }
            gatheredRequirements.add(profileRequirement);
        }
        if (context != null && context.getAdditionalRequirements() != null) {
            gatheredRequirements.addAll(context.getAdditionalRequirements());
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = this.createIURepresentingTheProfile(gatheredRequirements);
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        objectArray[1] = alreadyInstalled.toArray(clazz);
        return objectArray;
    }

    private IRequirement createRequirement(IInstallableUnit iu, String rule) {
        if (rule == null) {
            return null;
        }
        if (rule.equals(PlannerHelper.createStrictInclusionRule(iu))) {
            return this.createStrictRequirement(iu);
        }
        if (rule.equals(PlannerHelper.createOptionalInclusionRule(iu))) {
            return this.createOptionalRequirement(iu);
        }
        return null;
    }

    private IRequirement createOptionalRequirement(IInstallableUnit iu) {
        return MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, (boolean)true, (boolean)false, (boolean)true);
    }

    private IRequirement createStrictRequirement(IInstallableUnit iu) {
        return MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, (boolean)false, (boolean)false, (boolean)true);
    }

    @Override
    public IInstallableUnit[] updatesFor(IInstallableUnit toUpdate, ProvisioningContext context, IProgressMonitor monitor) {
        HashMap<String, IInstallableUnit> resultsMap = new HashMap<String, IInstallableUnit>();
        URI[] repositories = context.getMetadataRepositories();
        if (repositories == null) {
            repositories = this.repoManager.getKnownRepositories(0);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 200));
        int i = 0;
        while (i < repositories.length) {
            try {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IMetadataRepository repository = this.repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                IQueryResult matches = repository.query((IQuery)new UpdateQuery(toUpdate), (IProgressMonitor)sub.newChild(100));
                for (IInstallableUnit iu : matches) {
                    String key = new StringBuffer(String.valueOf(iu.getId())).append("_").append(iu.getVersion().toString()).toString();
                    IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
                    if (currentIU != null && !SimplePlanner.hasHigherFidelity(iu, currentIU)) continue;
                    resultsMap.put(key, iu);
                }
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        Collection results = resultsMap.values();
        return results.toArray(new IInstallableUnit[results.size()]);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EverythingOptionalProfile
    implements IProfile {
        private IProfile profile;

        public EverythingOptionalProfile(IProfile p) {
            this.profile = p;
        }

        public IQueryResult<IInstallableUnit> available(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
            return this.profile.available(query, monitor);
        }

        public Map<String, String> getInstallableUnitProperties(IInstallableUnit iu) {
            return this.profile.getInstallableUnitProperties(iu);
        }

        public String getInstallableUnitProperty(IInstallableUnit iu, String key) {
            if (SimplePlanner.INCLUSION_RULES.equals(key)) {
                return PlannerHelper.createOptionalInclusionRule(iu);
            }
            return this.profile.getInstallableUnitProperty(iu, key);
        }

        public String getProfileId() {
            return this.profile.getProfileId();
        }

        public Map<String, String> getProperties() {
            return this.profile.getProperties();
        }

        public String getProperty(String key) {
            return this.profile.getProperty(key);
        }

        public long getTimestamp() {
            return this.profile.getTimestamp();
        }

        public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
            return this.profile.query(query, monitor);
        }
    }
}

