/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.metadata.query;

import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.MatchQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionQuery<T>
extends MatchQuery<T> {
    private final IMatchExpression<T> expression;
    private final IEvaluationContext context;
    private final Class<T> matchingClass;

    public ExpressionQuery(Class<T> matchingClass, IExpression expression, Object[] parameters) {
        this(matchingClass, ExpressionUtil.getFactory().matchExpression(expression, parameters));
    }

    public ExpressionQuery(Class<T> matchingClass, IMatchExpression<T> expression) {
        this.matchingClass = matchingClass;
        this.expression = expression;
        this.context = expression.createContext();
    }

    @Override
    public boolean isMatch(T candidate) {
        if (!this.matchingClass.isInstance(candidate)) {
            return false;
        }
        ExpressionFactory.THIS.setValue(this.context, candidate);
        return Boolean.TRUE == this.expression.evaluate(this.context);
    }

    public IMatchExpression<T> getExpression() {
        return this.expression;
    }
}

