/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.metadata.query;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.MatchQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnitQuery
extends MatchQuery<IInstallableUnit> {
    public static final InstallableUnitQuery ANY = new InstallableUnitQuery(null);
    private String id;
    private final VersionRange range;

    public InstallableUnitQuery(String id) {
        this.id = id;
        this.range = null;
    }

    public InstallableUnitQuery(String id, VersionRange range) {
        this.id = id;
        this.range = range;
    }

    public InstallableUnitQuery(String id, Version version) {
        this.id = id;
        this.range = version == null || Version.emptyVersion.equals(version) ? null : new VersionRange(version, true, version, true);
    }

    public InstallableUnitQuery(IVersionedId versionedId) {
        this(versionedId.getId(), versionedId.getVersion());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public VersionRange getRange() {
        return this.range;
    }

    @Override
    public boolean isMatch(IInstallableUnit candidate) {
        if (this.id != null && !this.id.equals(candidate.getId())) {
            return false;
        }
        return this.range == null || this.range.isIncluded(candidate.getVersion());
    }
}

