/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.ContextQuery;
import org.eclipse.equinox.p2.query.ICompositeQuery;
import org.eclipse.equinox.p2.query.IMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitQuery<T>
extends ContextQuery<T>
implements ICompositeQuery<T> {
    private final IQuery<T> query;
    private final int limit;

    public LimitQuery(IQuery<T> query, int limit) {
        this.query = query;
        this.limit = limit;
    }

    @Override
    public IQueryResult<T> perform(Iterator<T> iterator) {
        if (this.limit == 0) {
            return Collector.emptyCollector();
        }
        int count = 0;
        Collector<T> result = new Collector<T>();
        if (this.query instanceof IMatchQuery) {
            IMatchQuery matchQuery = (IMatchQuery)this.query;
            while (iterator.hasNext()) {
                T candidate = iterator.next();
                if (!matchQuery.isMatch(candidate)) continue;
                result.accept(candidate);
                if (++count < this.limit) {
                    continue;
                }
                break;
            }
        } else {
            iterator = this.query.perform(iterator).iterator();
            while (++count <= this.limit && iterator.hasNext()) {
                result.accept(iterator.next());
            }
        }
        return result;
    }

    @Override
    public List<IQuery<T>> getQueries() {
        return Collections.singletonList(this.query);
    }
}

