/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class Publisher {
    public static final String PUBLISH_PACK_FILES_AS_SIBLINGS = "publishPackFilesAsSiblings";
    private IPublisherInfo info;
    private IPublisherResult results;

    public static IMetadataRepository createMetadataRepository(IProvisioningAgent agent, URI location, String name, boolean append, boolean compress) throws ProvisionException {
        try {
            IMetadataRepository result = Publisher.loadMetadataRepository(agent, location, true, true);
            if (result != null && result.isModifiable()) {
                result.setProperty("p2.compressed", compress ? "true" : "false");
                if (!append) {
                    result.removeAll();
                }
                return result;
            }
        }
        catch (ProvisionException provisionException) {}
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        String repositoryName = name == null ? location + " - metadata" : name;
        IMetadataRepository result = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
        if (result != null) {
            manager.removeRepository(result.getLocation());
            result.setProperty("p2.compressed", compress ? "true" : "false");
            return result;
        }
        String msg = Messages.repoMan_internalError;
        throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, msg, null));
    }

    public static IMetadataRepository loadMetadataRepository(IProvisioningAgent agent, URI location, boolean modifiable, boolean removeFromManager) throws ProvisionException {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        boolean existing = manager.contains(location);
        IMetadataRepository result = manager.loadRepository(location, modifiable ? 1 : 0, null);
        if (!existing && removeFromManager) {
            manager.removeRepository(location);
        }
        return result;
    }

    public static IArtifactRepository createArtifactRepository(IProvisioningAgent agent, URI location, String name, boolean append, boolean compress, boolean reusePackedFiles) throws ProvisionException {
        try {
            IArtifactRepository result = Publisher.loadArtifactRepository(agent, location, true, true);
            if (result != null && result.isModifiable()) {
                result.setProperty("p2.compressed", compress ? "true" : "false");
                if (reusePackedFiles) {
                    result.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
                }
                if (!append) {
                    result.removeAll();
                }
                return result;
            }
        }
        catch (ProvisionException provisionException) {}
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        String repositoryName = name != null ? name : location + " - artifacts";
        IArtifactRepository result = manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
        if (result != null) {
            manager.removeRepository(result.getLocation());
            if (reusePackedFiles) {
                result.setProperty(PUBLISH_PACK_FILES_AS_SIBLINGS, "true");
            }
            result.setProperty("p2.compressed", compress ? "true" : "false");
            return result;
        }
        String msg = org.eclipse.equinox.internal.p2.artifact.repository.Messages.repoMan_internalError;
        throw new ProvisionException((IStatus)new Status(4, Activator.ID, 1, msg, null));
    }

    public static IArtifactRepository loadArtifactRepository(IProvisioningAgent agent, URI location, boolean modifiable, boolean removeFromManager) throws ProvisionException {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        boolean existing = manager.contains(location);
        IArtifactRepository result = manager.loadRepository(location, modifiable ? 1 : 0, null);
        if (!existing && removeFromManager) {
            manager.removeRepository(location);
        }
        return result;
    }

    public Publisher(IPublisherInfo info) {
        this.info = info;
        this.results = new PublisherResult();
    }

    public Publisher(IPublisherInfo info, IPublisherResult results) {
        this.info = info;
        this.results = results;
    }

    public IStatus publish(IPublisherAction[] actions, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)actions.length);
        if (Tracing.DEBUG_PUBLISHING) {
            Tracing.debug((String)"Invoking publisher");
        }
        try {
            MultiStatus finalStatus = new MultiStatus("this", 0, "publishing result", null);
            int i = 0;
            while (i < actions.length) {
                if (sub.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus status = actions[i].perform(this.info, this.results, monitor);
                finalStatus.merge(status);
                sub.worked(1);
                ++i;
            }
            if (Tracing.DEBUG_PUBLISHING) {
                Tracing.debug((String)("Publishing complete. Result=" + finalStatus));
            }
            if (!finalStatus.isOK()) {
                MultiStatus multiStatus = finalStatus;
                return multiStatus;
            }
        }
        finally {
            sub.done();
        }
        IMetadataRepository metadataRepository = this.info.getMetadataRepository();
        if (metadataRepository != null) {
            Collection<IInstallableUnit> ius = this.results.getIUs(null, null);
            metadataRepository.addInstallableUnits(ius.toArray(new IInstallableUnit[ius.size()]));
        }
        return Status.OK_STATUS;
    }
}

