/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.garbagecollector;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.garbagecollector.CoreGarbageCollector;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.internal.p2.garbagecollector.Messages;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.p2.engine.InstallableUnitEvent;
import org.eclipse.equinox.p2.engine.RollbackOperationEvent;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.Preferences;

public class GCActivator
implements BundleActivator {
    public static final String ID = "org.eclipse.equinox.p2.garbagecollector";
    public static final String GC_ENABLED = "gc_enabled";
    private static final String DEBUG_STRING = "org.eclipse.equinox.p2.garbagecollector/debug";
    private static final boolean DEFAULT_DEBUG = false;
    static BundleContext context;
    private SynchronousProvisioningListener busListener;

    static Object getService(BundleContext ctx, String name) {
        ServiceReference reference = ctx.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = ctx.getService(reference);
        ctx.ungetService(reference);
        return result;
    }

    public void start(BundleContext inContext) throws Exception {
        Class<?> clazz;
        context = inContext;
        try {
            clazz = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        DebugOptions debug = (DebugOptions)GCActivator.getService(inContext, clazz.getName());
        if (debug != null) {
            CoreGarbageCollector.setDebugMode(debug.getBooleanOption(DEBUG_STRING, false));
        }
        this.registerGCTrigger();
    }

    private void registerGCTrigger() {
        IProvisioningEventBus eventBus = (IProvisioningEventBus)GCActivator.getService(context, IProvisioningEventBus.SERVICE_NAME);
        if (eventBus == null) {
            LogHelper.log((IStatus)new Status(4, ID, Messages.Missing_bus));
            return;
        }
        this.busListener = new SynchronousProvisioningListener(){
            private boolean uninstallEventOccurred = false;

            public void notify(EventObject o) {
                if (o instanceof InstallableUnitEvent) {
                    InstallableUnitEvent event = (InstallableUnitEvent)o;
                    if (event.isUninstall() && event.isPost()) {
                        this.uninstallEventOccurred = true;
                    }
                } else if (o instanceof CommitOperationEvent) {
                    if (this.uninstallEventOccurred) {
                        CommitOperationEvent event = (CommitOperationEvent)o;
                        if (GCActivator.this.getBooleanPreference(GCActivator.GC_ENABLED, true)) {
                            new GarbageCollector().runGC(event.getProfile());
                        }
                        this.uninstallEventOccurred = false;
                    }
                } else if (o instanceof RollbackOperationEvent) {
                    this.uninstallEventOccurred = false;
                }
            }
        };
        eventBus.addListener((ProvisioningListener)this.busListener);
    }

    protected boolean getBooleanPreference(String key, boolean defaultValue) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.core.runtime.preferences.IPreferencesService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IPreferencesService prefService = (IPreferencesService)GCActivator.getService(context, clazz.getName());
        if (prefService == null) {
            return defaultValue;
        }
        ArrayList<IEclipsePreferences> nodes = new ArrayList<IEclipsePreferences>();
        nodes.add(new ConfigurationScope().getNode(ID));
        nodes.add(new DefaultScope().getNode(ID));
        return Boolean.valueOf(prefService.get(key, Boolean.toString(defaultValue), nodes.toArray(new Preferences[nodes.size()])));
    }

    private void unregisterGCTrigger() {
        IProvisioningEventBus eventBus = (IProvisioningEventBus)GCActivator.getService(context, IProvisioningEventBus.SERVICE_NAME);
        if (eventBus != null && this.busListener != null) {
            eventBus.removeListener((ProvisioningListener)this.busListener);
        }
    }

    public void stop(BundleContext inContext) throws Exception {
        this.unregisterGCTrigger();
        context = null;
    }

    public static BundleContext getContext() {
        return context;
    }
}

