/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.query;

import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.query.MatchQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateQuery
extends MatchQuery<IInstallableUnit> {
    private IInstallableUnit updateFrom;

    public UpdateQuery(IInstallableUnit updateFrom) {
        this.updateFrom = updateFrom;
    }

    @Override
    public boolean isMatch(IInstallableUnit candidate) {
        if (candidate instanceof IInstallableUnitPatch && !(this.updateFrom instanceof IInstallableUnitPatch)) {
            IInstallableUnitPatch potentialPatch = (IInstallableUnitPatch)candidate;
            IRequirement lifeCycle = potentialPatch.getLifeCycle();
            if (lifeCycle == null) {
                return false;
            }
            return this.updateFrom.satisfies(lifeCycle);
        }
        IUpdateDescriptor descriptor = candidate.getUpdateDescriptor();
        if (descriptor != null && descriptor.isUpdateOf(this.updateFrom)) {
            if (!this.updateFrom.getId().equals(candidate.getId())) {
                return true;
            }
            return this.updateFrom.getVersion().compareTo(candidate.getVersion()) < 0;
        }
        return false;
    }
}

