/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.repository.artifact;

import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.MatchQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactKeyQuery
extends MatchQuery<IArtifactKey> {
    public static final ArtifactKeyQuery ALL_KEYS = new ArtifactKeyQuery();
    private String id;
    private String classifier;
    private VersionRange range;
    private IArtifactKey artifactKey;

    public ArtifactKeyQuery(String classifier, String id, VersionRange range) {
        this.id = id;
        this.classifier = classifier;
        this.range = range;
    }

    public ArtifactKeyQuery() {
    }

    public ArtifactKeyQuery(IArtifactKey key) {
        this.artifactKey = key;
    }

    public boolean isMatch(IArtifactKey key) {
        if (this.artifactKey != null) {
            return this.matchKey(key);
        }
        if (this.classifier != null && !key.getClassifier().equals(this.classifier)) {
            return false;
        }
        if (this.id != null && !key.getId().equals(this.id)) {
            return false;
        }
        return this.range == null || this.range.isIncluded(key.getVersion());
    }

    protected boolean matchKey(IArtifactKey candidate) {
        return this.artifactKey.equals(candidate);
    }

    public Boolean getExcludeArtifactKeys() {
        return Boolean.FALSE;
    }

    public Boolean getExcludeArtifactDescriptors() {
        return Boolean.TRUE;
    }
}

