/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.console;

import org.eclipse.equinox.internal.p2.console.ProvCommandProvider;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer {
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.console";
    private static final String PROVIDER_NAME = "org.eclipse.osgi.framework.console.CommandProvider";
    private static BundleContext context;
    private ServiceTracker profileTracker;
    private ProvCommandProvider provider;
    private ServiceRegistration providerRegistration = null;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext ctxt) throws Exception {
        context = ctxt;
        boolean registerCommands = true;
        try {
            Class.forName(PROVIDER_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            registerCommands = false;
        }
        if (registerCommands) {
            this.profileTracker = new ServiceTracker(context, IProfileRegistry.SERVICE_NAME, (ServiceTrackerCustomizer)this);
            this.profileTracker.open();
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        this.profileTracker.close();
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
        }
        this.providerRegistration = null;
        context = null;
    }

    public Object addingService(ServiceReference reference) {
        BundleContext ctxt = Activator.getContext();
        IProfileRegistry registry = (IProfileRegistry)ctxt.getService(reference);
        this.provider = new ProvCommandProvider(ctxt.getProperty("eclipse.p2.profile"), registry);
        this.providerRegistration = ctxt.registerService(PROVIDER_NAME, (Object)this.provider, null);
        return registry;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        if (this.providerRegistration != null) {
            this.providerRegistration.unregister();
        }
        this.providerRegistration = null;
    }
}

