/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.AgentLocation;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ProvisioningAgent
implements IProvisioningAgent {
    private final Map<String, Object> agentServices = Collections.synchronizedMap(new HashMap());
    private BundleContext context;
    private boolean stopped = false;
    private ServiceRegistration reg;

    public Object getService(String serviceName) {
        ServiceReference[] refs;
        this.checkRunning();
        Object service = this.agentServices.get(serviceName);
        if (service != null) {
            return service;
        }
        try {
            refs = this.context.getServiceReferences(IAgentServiceFactory.SERVICE_NAME, "(p2.agent.servicename=" + serviceName + ')');
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
        if (refs == null || refs.length == 0) {
            return null;
        }
        IAgentServiceFactory factory = (IAgentServiceFactory)this.context.getService(refs[0]);
        if (factory == null) {
            return null;
        }
        try {
            service = factory.createService(this);
        }
        finally {
            this.context.ungetService(refs[0]);
        }
        if (service != null) {
            this.agentServices.put(serviceName, service);
        }
        return service;
    }

    private synchronized void checkRunning() {
        if (this.stopped) {
            throw new RuntimeException("Attempt to access stopped agent: " + this);
        }
    }

    public void registerService(String serviceName, Object service) {
        this.checkRunning();
        this.agentServices.put(serviceName, service);
    }

    public void setBundleContext(BundleContext context) {
        this.context = context;
    }

    public void setLocation(URI location) {
        IAgentLocation agentLocation = null;
        if (location == null) {
            ServiceReference ref = this.context.getServiceReference(IAgentLocation.SERVICE_NAME);
            if (ref != null) {
                agentLocation = (IAgentLocation)this.context.getService(ref);
                this.context.ungetService(ref);
            }
        } else {
            agentLocation = new AgentLocation(location);
        }
        this.agentServices.put(IAgentLocation.SERVICE_NAME, agentLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(String serviceName, Object service) {
        Object object = this;
        synchronized (object) {
            if (this.stopped) {
                return;
            }
        }
        object = this.agentServices;
        synchronized (object) {
            if (this.agentServices.get(serviceName) == service) {
                this.agentServices.remove(serviceName);
            }
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    public void setServiceRegistration(ServiceRegistration reg) {
        this.reg = reg;
    }
}

