/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.p2.engine.Operand;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvisioningPlan
implements IProvisioningPlan {
    IStatus status;
    Operand[] operands;
    Map<IInstallableUnit, IStatus> actualChangeRequest;
    Map<IInstallableUnit, IStatus> sideEffectChanges;
    IProvisioningPlan installerPlan;
    IStatus globalRequestStatus;
    IProfile profile;
    IQueryable<IInstallableUnit> completeState;
    private final ProvisioningContext context;

    public ProvisioningPlan(IProfile profile, Operand[] operands, ProvisioningContext context) {
        this(Status.OK_STATUS, operands, null, Status.OK_STATUS, null, profile, null, context);
    }

    public ProvisioningPlan(IStatus status, IProfile profile, IProvisioningPlan installerPlan, ProvisioningContext context) {
        this(status, new Operand[0], null, null, installerPlan, profile, null, null);
    }

    public ProvisioningPlan(IStatus status, Operand[] operands, Map<IInstallableUnit, IStatus>[] actualChangeRequest, IStatus globalStatus, IProvisioningPlan installerPlan, IProfile profile, IQueryable<IInstallableUnit> futureState, ProvisioningContext context) {
        this.status = status;
        this.operands = operands;
        if (actualChangeRequest != null) {
            this.actualChangeRequest = actualChangeRequest[0];
            this.sideEffectChanges = actualChangeRequest[1];
        }
        this.globalRequestStatus = globalStatus;
        this.installerPlan = installerPlan;
        this.profile = profile;
        if (futureState == null) {
            futureState = new IQueryable<IInstallableUnit>(){

                public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
                    return Collector.emptyCollector();
                }
            };
        }
        this.completeState = futureState;
        if (context == null) {
            context = new ProvisioningContext();
        }
        this.context = context;
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }

    @Override
    public IProfile getProfile() {
        return this.profile;
    }

    @Override
    public Operand[] getOperands() {
        return this.operands;
    }

    @Override
    public IQueryable<IInstallableUnit> getRemovals() {
        return new QueryablePlan(false);
    }

    @Override
    public IQueryable<IInstallableUnit> getAdditions() {
        return new QueryablePlan(true);
    }

    @Override
    public IStatus getRequestStatus(IInstallableUnit iu) {
        if (this.actualChangeRequest == null) {
            return null;
        }
        return this.actualChangeRequest.get(iu);
    }

    public IStatus getRequestStatus() {
        return this.globalRequestStatus;
    }

    @Override
    public Map<IInstallableUnit, IStatus> getSideEffectChanges() {
        if (this.sideEffectChanges == null) {
            return CollectionUtils.emptyMap();
        }
        return this.sideEffectChanges;
    }

    @Override
    public IProvisioningPlan getInstallerPlan() {
        return this.installerPlan;
    }

    @Override
    public ProvisioningContext getContext() {
        return this.context;
    }

    public void setInstallerPlan(IProvisioningPlan p) {
        this.installerPlan = p;
    }

    public IQueryable<IInstallableUnit> getCompleteState() {
        return this.completeState;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryablePlan
    implements IQueryable<IInstallableUnit> {
        private boolean addition;

        public QueryablePlan(boolean add) {
            this.addition = add;
        }

        public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
            if (ProvisioningPlan.this.operands == null || ProvisioningPlan.this.status.getSeverity() == 4) {
                return Collector.emptyCollector();
            }
            ArrayList<IInstallableUnit> list = new ArrayList<IInstallableUnit>();
            int i = 0;
            while (i < ProvisioningPlan.this.operands.length) {
                if (ProvisioningPlan.this.operands[i] instanceof InstallableUnitOperand) {
                    IInstallableUnit iu;
                    InstallableUnitOperand op = (InstallableUnitOperand)ProvisioningPlan.this.operands[i];
                    IInstallableUnit iInstallableUnit = iu = this.addition ? op.second() : op.first();
                    if (iu != null) {
                        list.add(iu);
                    }
                }
                ++i;
            }
            return query.perform(list.iterator());
        }
    }
}

