/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;

public abstract class Reader {
    private boolean verbose = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        IProblem iProblem;
        InputStream inputStream = null;
        try {
            try {
                IProblem iProblem2;
                inputStream = string.startsWith("http://") ? new URL(string).openStream() : new FileInputStream(string);
                if (string.endsWith(".gz")) {
                    inputStream = new GZIPInputStream(inputStream);
                }
                iProblem = iProblem2 = this.parseInstance(inputStream);
                Object var4_9 = null;
                if (inputStream == null) return iProblem;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (ParseFormatException parseFormatException) {
                throw parseFormatException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (ContradictionException contradictionException) {
                throw contradictionException;
            }
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return iProblem;
    }

    public IProblem parseInstance(InputStream inputStream) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new InputStreamReader(inputStream));
    }

    public abstract IProblem parseInstance(java.io.Reader var1) throws ParseFormatException, ContradictionException, IOException;

    public abstract String decode(int[] var1);

    public abstract void decode(int[] var1, PrintWriter var2);

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbosity(boolean bl) {
        this.verbose = bl;
    }
}

