/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.LimitQuery;
import org.eclipse.equinox.p2.query.PipedQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherResult
implements IPublisherResult {
    final Map<String, Set<IInstallableUnit>> rootIUs = new HashMap<String, Set<IInstallableUnit>>();
    final Map<String, Set<IInstallableUnit>> nonRootIUs = new HashMap<String, Set<IInstallableUnit>>();

    @Override
    public void addIU(IInstallableUnit iu, String type) {
        if (type == "root") {
            this.addIU(this.rootIUs, iu.getId(), iu);
        }
        if (type == "non_root") {
            this.addIU(this.nonRootIUs, iu.getId(), iu);
        }
    }

    @Override
    public void addIUs(Collection<IInstallableUnit> ius, String type) {
        for (IInstallableUnit iu : ius) {
            this.addIU(iu, type);
        }
    }

    private void addIU(Map<String, Set<IInstallableUnit>> map, String id, IInstallableUnit iu) {
        Set<IInstallableUnit> ius = map.get(id);
        if (ius == null) {
            ius = new HashSet<IInstallableUnit>(11);
            map.put(id, ius);
        }
        ius.add(iu);
    }

    @Override
    public IInstallableUnit getIU(String id, Version version, String type) {
        Collection ius;
        if ((type == null || type == "root") && this.rootIUs.containsKey(id)) {
            ius = this.rootIUs.get(id);
            for (IInstallableUnit iu : ius) {
                if (!iu.getVersion().equals(version)) continue;
                return iu;
            }
        }
        if ((type == null || type == "non_root") && this.nonRootIUs.containsKey(id)) {
            ius = this.nonRootIUs.get(id);
            for (IInstallableUnit iu : ius) {
                if (!iu.getVersion().equals(version)) continue;
                return iu;
            }
        }
        return null;
    }

    @Override
    public IInstallableUnit getIU(String id, String type) {
        Collection ius;
        if ((type == null || type == "root") && (ius = (Collection)this.rootIUs.get(id)) != null && ius.size() > 0) {
            return (IInstallableUnit)ius.iterator().next();
        }
        if ((type == null || type == "non_root") && (ius = (Collection)this.nonRootIUs.get(id)) != null && ius.size() > 0) {
            return (IInstallableUnit)ius.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<IInstallableUnit> getIUs(String id, String type) {
        if (type == null) {
            ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
            result.addAll(id == null ? this.flatten(this.rootIUs.values()) : this.getIUs(this.rootIUs, id));
            result.addAll(id == null ? this.flatten(this.nonRootIUs.values()) : this.getIUs(this.nonRootIUs, id));
            return result;
        }
        if (type == "root") {
            return id == null ? this.flatten(this.rootIUs.values()) : (Collection)this.rootIUs.get(id);
        }
        if (type == "non_root") {
            return id == null ? this.flatten(this.nonRootIUs.values()) : (Collection)this.nonRootIUs.get(id);
        }
        return null;
    }

    private Collection<IInstallableUnit> getIUs(Map<String, Set<IInstallableUnit>> ius, String id) {
        Collection result = ius.get(id);
        return result == null ? CollectionUtils.emptyList() : result;
    }

    protected List<IInstallableUnit> flatten(Collection<Set<IInstallableUnit>> values) {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        for (Set<IInstallableUnit> iuSet : values) {
            result.addAll(iuSet);
        }
        return result;
    }

    @Override
    public void merge(IPublisherResult result, int mode) {
        if (mode == 0) {
            this.addIUs(result.getIUs(null, "root"), "root");
            this.addIUs(result.getIUs(null, "non_root"), "non_root");
        } else if (mode == 1) {
            this.addIUs(result.getIUs(null, "root"), "root");
            this.addIUs(result.getIUs(null, "non_root"), "root");
        } else if (mode == 2) {
            this.addIUs(result.getIUs(null, "root"), "non_root");
            this.addIUs(result.getIUs(null, "non_root"), "non_root");
        }
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        if (query instanceof InstallableUnitQuery) {
            return this.queryIU((InstallableUnitQuery)query, monitor);
        }
        if (query instanceof LimitQuery) {
            return this.doLimitQuery((LimitQuery<IInstallableUnit>)((LimitQuery)query), monitor);
        }
        if (query instanceof PipedQuery) {
            return this.doPipedQuery((PipedQuery<IInstallableUnit>)((PipedQuery)query), monitor);
        }
        QueryableMap nonRootQueryable = new QueryableMap(this.nonRootIUs);
        QueryableMap rootQueryable = new QueryableMap(this.rootIUs);
        return new CompoundQueryable((IQueryable)nonRootQueryable, (IQueryable)rootQueryable).query(query, monitor);
    }

    private IQueryResult<IInstallableUnit> doLimitQuery(LimitQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        IQuery child = (IQuery)query.getQueries().get(0);
        return this.query((IQuery<IInstallableUnit>)child, monitor).query(query, monitor);
    }

    private IQueryResult<IInstallableUnit> doPipedQuery(PipedQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        IQueryResult last = Collector.emptyCollector();
        List queries = query.getQueries();
        if (!queries.isEmpty()) {
            last = this.query((IQuery<IInstallableUnit>)((IQuery)queries.get(0)), monitor);
            int i = 1;
            while (i < queries.size()) {
                if (last.isEmpty()) break;
                last = ((IQuery)queries.get(i)).perform(last.iterator());
                ++i;
            }
        }
        return last;
    }

    private IQueryResult<IInstallableUnit> queryIU(InstallableUnitQuery query, IProgressMonitor monitor) {
        Collector result = new Collector();
        Collection<IInstallableUnit> matches = this.getIUs(query.getId(), null);
        VersionRange queryRange = query.getRange();
        for (IInstallableUnit match : matches) {
            if ((queryRange == null || queryRange.isIncluded(match.getVersion())) && !result.accept((Object)match)) break;
        }
        return result;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryableMap
    implements IQueryable<IInstallableUnit> {
        private Map<String, Set<IInstallableUnit>> map;

        public QueryableMap(Map<String, Set<IInstallableUnit>> map) {
            this.map = map;
        }

        public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
            return query.perform(PublisherResult.this.flatten(this.map.values()).iterator());
        }
    }
}

