/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.repository.artifact;

import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDescriptorQuery
extends MatchQuery<IArtifactDescriptor> {
    public static final ArtifactDescriptorQuery ALL_DESCRIPTORS = new ArtifactDescriptorQuery();
    private VersionRange range = null;
    private String id = null;
    private String format = null;
    private ArtifactDescriptor descriptor = null;
    private IArtifactRepository repository = null;

    public ArtifactDescriptorQuery(String id, VersionRange versionRange, String format) {
        this(id, versionRange, format, null);
    }

    public ArtifactDescriptorQuery(String id, VersionRange versionRange, String format, IArtifactRepository repository) {
        this.id = id;
        this.range = versionRange;
        this.format = format;
        this.repository = repository;
    }

    public ArtifactDescriptorQuery() {
    }

    public ArtifactDescriptorQuery(IArtifactDescriptor descriptor) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.descriptor = descriptor.getClass() == clazz ? (ArtifactDescriptor)descriptor : new ArtifactDescriptor(descriptor);
    }

    public boolean isMatch(IArtifactDescriptor candidate) {
        if (this.descriptor != null) {
            return this.matchDescriptor(candidate);
        }
        if (this.id != null && !this.id.equals(candidate.getArtifactKey().getId())) {
            return false;
        }
        if (this.range != null && !this.range.isIncluded(candidate.getArtifactKey().getVersion())) {
            return false;
        }
        if (this.format != null && !this.format.equals(candidate.getProperty("format"))) {
            return false;
        }
        return this.repository == null || this.repository == candidate.getRepository();
    }

    protected boolean matchDescriptor(IArtifactDescriptor candidate) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ArtifactDescriptor candidateDescriptor = candidate.getClass() == clazz ? (ArtifactDescriptor)candidate : new ArtifactDescriptor(candidate);
        return this.descriptor.equals(candidateDescriptor);
    }

    public Boolean getExcludeArtifactDescriptors() {
        return Boolean.FALSE;
    }

    public Boolean getExcludeArtifactKeys() {
        return Boolean.TRUE;
    }
}

