/**
 * Copyright (c) 2006-2009, Cloudsmith Inc.
 * The code, documentation and other materials contained herein have been
 * licensed under the Eclipse Public License - v 1.0 by the copyright holder
 * listed above, as the Initial Contributor under such license. The text of
 * such license is available at www.eclipse.org.
 */

package org.eclipse.b3.aggregator.engine.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.metadata.repository.Activator;
import org.eclipse.equinox.internal.p2.metadata.repository.CacheManager;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.URLMetadataRepository;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.util.NLS;

/**
 * @author filip.hrbek@cloudsmith.com
 * 
 */
@Deprecated
public class InternalMetadataRepositoryFactory extends SimpleMetadataRepositoryFactory {
	private static final String JAR_EXTENSION = ".jar"; //$NON-NLS-1$

	private static final String XML_EXTENSION = ".xml"; //$NON-NLS-1$

	private static final String PROTOCOL_FILE = "file"; //$NON-NLS-1$

	private static URI getActualLocation(URI base, String extension) {
		if(extension == null)
			extension = XML_EXTENSION;
		return URIUtil.append(base, InternalMetadataRepository.CONTENT_FILENAME + extension);
	}

	@Override
	public IMetadataRepository create(URI location, String name, String type, Map<String, String> properties) {
		if(location.getScheme().equals("file")) //$NON-NLS-1$
			return new InternalMetadataRepository(location, name, properties);

		throw new UnsupportedOperationException();
	}

	protected IMetadataRepository validateAndLoad(URI location, boolean doLoad, int flags, IProgressMonitor monitor)
			throws ProvisionException {
		long time = 0;
		final String debugMsg = "Validating and loading metadata repository "; //$NON-NLS-1$
		if(Tracing.DEBUG_METADATA_PARSING) {
			Tracing.debug(debugMsg + location);
			time = -System.currentTimeMillis();
		}
		SubMonitor sub = SubMonitor.convert(monitor, 400);
		try {
			File localFile = getLocalFile(location, sub.newChild(300));
			InputStream inStream = new BufferedInputStream(new FileInputStream(localFile));
			JarInputStream jarStream = null;
			try {
				// if reading from a jar, obtain a stream on the entry with the actual contents
				if(localFile.getAbsolutePath().endsWith(JAR_EXTENSION)) {
					jarStream = new JarInputStream(inStream);
					JarEntry jarEntry = jarStream.getNextJarEntry();
					String entryName = InternalMetadataRepository.CONTENT_FILENAME
							+ InternalMetadataRepository.XML_EXTENSION;
					while(jarEntry != null && (!entryName.equals(jarEntry.getName()))) {
						jarEntry = jarStream.getNextJarEntry();
					}
					// if there is a jar but the entry is missing or invalid, treat this as an invalid repository
					if(jarEntry == null)
						throw new IOException(NLS.bind(Messages.repoMan_invalidLocation, location));
				}
				// parse the repository descriptor file
				sub.setWorkRemaining(100);
				if(doLoad) {
					InputStream descriptorStream = jarStream != null
							? jarStream
							: inStream;
					IMetadataRepository result = new InternalMetadataRepositoryIO().read(localFile.toURI().toURL(),
							descriptorStream, sub.newChild(100));
					if(result != null && (flags & IRepositoryManager.REPOSITORY_HINT_MODIFIABLE) > 0
							&& !result.isModifiable())
						return null;
					if(result instanceof LocalMetadataRepository)
						((LocalMetadataRepository) result).initializeAfterLoad(location);
					if(result instanceof URLMetadataRepository)
						((URLMetadataRepository) result).initializeAfterLoad(location);
					if(Tracing.DEBUG_METADATA_PARSING) {
						time += System.currentTimeMillis();
						Tracing.debug(debugMsg + "time (ms): " + time); //$NON-NLS-1$ 
					}
					return result;
				}
			}
			finally {
				safeClose(jarStream);
				safeClose(inStream);
			}
		}
		catch(FileNotFoundException e) {
			String msg = NLS.bind(Messages.io_failedRead, location);
			throw new ProvisionException(new Status(IStatus.ERROR, Activator.ID,
					ProvisionException.REPOSITORY_NOT_FOUND, msg, e));
		}
		catch(IOException e) {
			String msg = NLS.bind(Messages.io_failedRead, location);
			throw new ProvisionException(new Status(IStatus.ERROR, Activator.ID,
					ProvisionException.REPOSITORY_FAILED_READ, msg, e));
		}
		finally {
			if(monitor != null)
				monitor.done();
		}
		return null;
	}

	private File getLocalFile(URI location, IProgressMonitor monitor) throws IOException, ProvisionException {
		File localFile = null;
		URI jarLocation = getActualLocation(location, JAR_EXTENSION);
		URI xmlLocation = getActualLocation(location, XML_EXTENSION);
		// If the repository is local, we can return the repository file directly
		if(PROTOCOL_FILE.equals(xmlLocation.getScheme())) {
			// look for a compressed local file
			localFile = URIUtil.toFile(jarLocation);
			if(localFile.exists())
				return localFile;
			// look for an uncompressed local file
			localFile = URIUtil.toFile(xmlLocation);
			if(localFile.exists())
				return localFile;
			String msg = NLS.bind(Messages.io_failedRead, location);
			throw new ProvisionException(new Status(IStatus.ERROR, Activator.ID,
					ProvisionException.REPOSITORY_NOT_FOUND, msg, null));
		}
		// file is not local, create a cache of the repository metadata
		CacheManager cache = (CacheManager) getAgent().getService(CacheManager.SERVICE_NAME);
		if(cache == null)
			throw new IllegalArgumentException("Cache manager service not available"); //$NON-NLS-1$
		localFile = cache.createCache(location, InternalMetadataRepository.CONTENT_FILENAME, monitor);
		if(localFile == null) {
			// there is no remote file in either form - this should not really happen as
			// createCache should bail out with exception if something is wrong. This is an internal
			// error.
			throw new ProvisionException(new Status(IStatus.ERROR, Activator.ID,
					ProvisionException.REPOSITORY_NOT_FOUND, Messages.repoMan_internalError, null));
		}
		return localFile;
	}

	/**
	 * Closes a stream, ignoring any secondary exceptions
	 */
	private void safeClose(InputStream stream) {
		if(stream == null)
			return;
		try {
			stream.close();
		}
		catch(IOException e) {
			// ignore
		}
	}

}
