/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.metadata.repository.IUMap;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLMetadataRepository
extends AbstractMetadataRepository {
    public static final String CONTENT_FILENAME = "content";
    public static final String XML_EXTENSION = ".xml";
    private static final String REPOSITORY_TYPE;
    private static final Integer REPOSITORY_VERSION;
    protected transient URI content;
    protected IUMap units = new IUMap();

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.internal.p2.metadata.repository.URLMetadataRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    public static URI getActualLocation(URI base) {
        return URLMetadataRepository.getActualLocation(base, XML_EXTENSION);
    }

    public static URI getActualLocation(URI base, String extension) {
        if (extension == null) {
            extension = XML_EXTENSION;
        }
        return URIUtil.append((URI)base, (String)new StringBuffer(CONTENT_FILENAME).append(extension).toString());
    }

    public URLMetadataRepository() {
    }

    public URLMetadataRepository(URI location, String name, Map<String, String> properties) {
        super(name == null ? (location != null ? location.toString() : "") : name, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        this.content = URLMetadataRepository.getActualLocation(location);
    }

    protected synchronized URI getContentURL() {
        return this.content;
    }

    public synchronized void initialize(AbstractMetadataRepository.RepositoryState state) {
        this.name = state.Name;
        this.type = state.Type;
        this.version = state.Version.toString();
        this.provider = state.Provider;
        this.description = state.Description;
        this.location = state.Location;
        this.properties = state.Properties;
        this.units.addAll(state.Units);
    }

    public synchronized void initializeAfterLoad(URI repoLocation) {
        this.location = repoLocation;
        this.content = URLMetadataRepository.getActualLocation(this.location);
    }

    public boolean isModifiable() {
        return false;
    }

    public synchronized IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        if (query instanceof InstallableUnitQuery) {
            return this.units.query((InstallableUnitQuery)query);
        }
        return query.perform(this.units.iterator());
    }
}

