/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.query.LatestIUVersionQuery;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.VersionSuffixGenerator;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.LimitQuery;
import org.eclipse.equinox.p2.query.PipedQuery;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteXMLAction
extends AbstractPublisherAction {
    private static final String QUALIFIER = "qualifier";
    private static final VersionSuffixGenerator versionSuffixGenerator = new VersionSuffixGenerator();
    protected UpdateSite updateSite;
    private SiteCategory defaultCategory;
    private HashSet<SiteCategory> defaultCategorySet;
    protected URI location;
    private String categoryQualifier = null;
    private Version categoryVersion = null;

    public SiteXMLAction(URI location, String categoryQualifier) {
        this.location = location;
        this.categoryQualifier = categoryQualifier;
    }

    public SiteXMLAction(UpdateSite updateSite, String categoryQualifier) {
        this.updateSite = updateSite;
        this.categoryQualifier = categoryQualifier;
    }

    public void setCategoryVersion(String version) {
        this.categoryVersion = Version.parseVersion((String)version);
    }

    private void initialize() {
        if (this.defaultCategory != null) {
            return;
        }
        this.defaultCategory = new SiteCategory();
        this.defaultCategory.setDescription("Default category for otherwise uncategorized features");
        this.defaultCategory.setLabel("Uncategorized");
        this.defaultCategory.setName("Default");
        this.defaultCategorySet = new HashSet(1);
        this.defaultCategorySet.add(this.defaultCategory);
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (this.updateSite == null) {
            try {
                this.updateSite = UpdateSite.load(this.location, monitor);
            }
            catch (ProvisionException e) {
                return new Status(4, Activator.ID, Messages.Error_generating_siteXML, (Throwable)e);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        this.initialize();
        return this.generateCategories(publisherInfo, results, monitor);
    }

    private IStatus generateCategories(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        HashMap<SiteCategory, Set<IInstallableUnit>> categoriesToFeatureIUs = new HashMap<SiteCategory, Set<IInstallableUnit>>();
        Map<SiteFeature, Set<SiteCategory>> featuresToCategories = this.getFeatureToCategoryMappings(publisherInfo);
        for (SiteFeature feature : featuresToCategories.keySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            IInstallableUnit iu = this.getFeatureIU(feature, publisherInfo, results);
            if (iu == null) continue;
            Set<SiteCategory> categories = featuresToCategories.get(feature);
            if (categories == null || categories.isEmpty()) {
                categories = this.defaultCategorySet;
            }
            for (SiteCategory category : categories) {
                HashSet<IInstallableUnit> featureIUs = (HashSet<IInstallableUnit>)categoriesToFeatureIUs.get(category);
                if (featureIUs == null) {
                    featureIUs = new HashSet<IInstallableUnit>();
                    categoriesToFeatureIUs.put(category, featureIUs);
                }
                featureIUs.add(iu);
            }
        }
        this.generateCategoryIUs(categoriesToFeatureIUs, results);
        return Status.OK_STATUS;
    }

    private IInstallableUnit getFeatureIU(SiteFeature feature, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = new StringBuffer(String.valueOf(feature.getFeatureIdentifier())).append(".feature.group").toString();
        String versionString = feature.getFeatureVersion();
        Version version = versionString != null && versionString.length() > 0 ? Version.create((String)versionString) : Version.emptyVersion;
        PipedQuery query = null;
        if (version.equals(Version.emptyVersion)) {
            query = new PipedQuery((IQuery)new InstallableUnitQuery(id), (IQuery)new LatestIUVersionQuery());
        } else {
            String qualifier;
            try {
                qualifier = Version.toOSGiVersion((Version)version).getQualifier();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                qualifier = null;
            }
            if (qualifier != null && qualifier.endsWith(QUALIFIER)) {
                String v = versionString.substring(0, versionString.indexOf(QUALIFIER));
                InstallableUnitQuery qualifierQuery = new InstallableUnitQuery(id, v){
                    private String qualifierVersion;
                    {
                        this.qualifierVersion = string.endsWith(".") ? string.substring(0, string.length() - 1) : string;
                    }

                    public boolean isMatch(IInstallableUnit candidate) {
                        if (super.isMatch(candidate)) {
                            return candidate.getVersion().toString().startsWith(this.qualifierVersion);
                        }
                        return false;
                    }
                };
                query = new PipedQuery((IQuery)qualifierQuery, (IQuery)new LatestIUVersionQuery());
            } else {
                query = new LimitQuery((IQuery)new InstallableUnitQuery(id, version), 1);
            }
        }
        IQueryResult queryResult = results.query((IQuery)query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query((IQuery)query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query((IQuery)query, null);
        }
        if (!queryResult.isEmpty()) {
            return (IInstallableUnit)queryResult.iterator().next();
        }
        return null;
    }

    protected Map<SiteFeature, Set<SiteCategory>> getFeatureToCategoryMappings(IPublisherInfo publisherInfo) {
        File siteFile;
        URLEntry[] associatedSites;
        HashMap<SiteFeature, Set<SiteCategory>> mappings = new HashMap<SiteFeature, Set<SiteCategory>>();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        String mirrors = site.getMirrorsURI();
        if (mirrors != null) {
            int index = mirrors.indexOf("site.xml");
            if (index != -1) {
                mirrors = new StringBuffer(String.valueOf(mirrors.substring(0, index))).append(mirrors.substring(index + "site.xml".length())).toString();
            }
            publisherInfo.getMetadataRepository().setProperty("p2.mirrorsURL", mirrors);
            if (publisherInfo.getArtifactRepository() != null) {
                publisherInfo.getArtifactRepository().setProperty("p2.mirrorsURL", mirrors);
            }
        }
        if ((associatedSites = site.getAssociatedSites()) != null) {
            int i = 0;
            while (i < associatedSites.length) {
                this.generateSiteReference(associatedSites[i].getURL(), associatedSites[i].getAnnotation(), null, publisherInfo.getMetadataRepository());
                ++i;
            }
        }
        if ((siteFile = URIUtil.toFile((URI)this.updateSite.getLocation())) != null && siteFile.exists()) {
            String[] keyStrings;
            File siteParent = siteFile.getParentFile();
            List<String> messageKeys = site.getMessageKeys();
            if (siteParent.isDirectory()) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            } else if (siteFile.getName().endsWith(".jar")) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getJarPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            }
        }
        SiteFeature[] features = site.getFeatures();
        int i = 0;
        while (i < features.length) {
            String[] categoryNames = features[i].getCategoryNames();
            HashSet<SiteCategory> categories = new HashSet<SiteCategory>();
            mappings.put(features[i], categories);
            int j = 0;
            while (j < categoryNames.length) {
                SiteCategory category = site.getCategory(categoryNames[j]);
                if (category != null) {
                    categories.add(category);
                }
                ++j;
            }
            ++i;
        }
        return mappings;
    }

    private void generateSiteReference(String siteLocation, String label, String featureId, IMetadataRepository metadataRepo) {
        if (metadataRepo == null) {
            return;
        }
        try {
            URI associateLocation = new URI(siteLocation);
            metadataRepo.addReference(associateLocation, label, 0, 1);
            metadataRepo.addReference(associateLocation, label, 1, 1);
        }
        catch (URISyntaxException uRISyntaxException) {
            String message = new StringBuffer("Invalid site reference: ").append(siteLocation).toString();
            if (featureId != null) {
                message = new StringBuffer(String.valueOf(message)).append(" in feature: ").append(featureId).toString();
            }
            LogHelper.log((IStatus)new Status(4, Activator.ID, message));
        }
    }

    protected void generateCategoryIUs(Map<SiteCategory, Set<IInstallableUnit>> categoriesToFeatures, IPublisherResult result) {
        for (SiteCategory category : categoriesToFeatures.keySet()) {
            result.addIU(this.createCategoryIU(category, categoriesToFeatures.get(category), null), "non_root");
        }
    }

    public IInstallableUnit createCategoryIU(SiteCategory category, Set<IInstallableUnit> featureIUs, IInstallableUnit parentCategory) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = this.buildCategoryId(category.getName());
        cat.setId(categoryId);
        if (this.categoryVersion == null) {
            cat.setVersion(Version.createOSGi((int)1, (int)0, (int)0, (String)versionSuffixGenerator.generateSuffix(featureIUs, CollectionUtils.emptyList())));
        } else {
            org.osgi.framework.Version osgiVersion;
            String qualifier;
            if (this.categoryVersion.isOSGiCompatible() && (qualifier = (osgiVersion = Version.toOSGiVersion((Version)this.categoryVersion)).getQualifier()).endsWith(QUALIFIER)) {
                String suffix = versionSuffixGenerator.generateSuffix(featureIUs, CollectionUtils.emptyList());
                qualifier = new StringBuffer(String.valueOf(qualifier.substring(0, qualifier.length() - 9))).append(suffix).toString();
                this.categoryVersion = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)qualifier);
            }
            cat.setVersion(this.categoryVersion);
        }
        String label = category.getLabel();
        cat.setProperty("org.eclipse.equinox.p2.name", label != null ? label : category.getName());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<IRequiredCapability> reqsConfigurationUnits = new ArrayList<IRequiredCapability>(featureIUs.size());
        for (IInstallableUnit iu : featureIUs) {
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (Filter)iu.getFilter(), (boolean)false, (boolean)false));
        }
        if (parentCategory != null) {
            reqsConfigurationUnits.add(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)parentCategory.getId(), (VersionRange)VersionRange.emptyRange, (Filter)parentCategory.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequiredCapabilities(reqsConfigurationUnits.toArray(new IRequirement[reqsConfigurationUnits.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)categoryId, (Version)cat.getVersion()));
        Map<Locale, Map<String, String>> localizations = category.getLocalizations();
        if (localizations != null) {
            for (Map.Entry<Locale, Map<String, String>> locEntry : localizations.entrySet()) {
                Locale locale = locEntry.getKey();
                Map<String, String> translatedStrings = locEntry.getValue();
                for (Map.Entry<String, String> e : translatedStrings.entrySet()) {
                    cat.setProperty(new StringBuffer(String.valueOf(locale.toString())).append('.').append(e.getKey()).toString(), e.getValue());
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)categoryId, (Locale)locale));
            }
        }
        cat.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    private String buildCategoryId(String categoryName) {
        if (this.categoryQualifier != null) {
            if (this.categoryQualifier.length() > 0) {
                return new StringBuffer(String.valueOf(this.categoryQualifier)).append(".").append(categoryName).toString();
            }
            return categoryName;
        }
        if (this.updateSite != null) {
            return new StringBuffer(String.valueOf(URIUtil.toUnencodedString((URI)this.updateSite.getLocation()))).append(".").append(categoryName).toString();
        }
        return categoryName;
    }
}

