/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.query.ExpressionQuery;
import org.eclipse.equinox.p2.metadata.query.FragmentQuery;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.CompoundQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.MatchQuery;
import org.eclipse.equinox.p2.query.PipedQuery;
import org.eclipse.osgi.service.localization.LocaleProvider;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationSupport {
    static final Locale DEFAULT_LOCALE = new Locale("df", "LT");
    private static TranslationSupport instance;
    static final String NAMESPACE_IU_LOCALIZATION = "org.eclipse.equinox.p2.localization";
    private IQueryable<IInstallableUnit> fragmentSource;
    private static IExpression capabilityMatch;
    private Map<String, SoftReference<IQueryResult<IInstallableUnit>>> localeCollectorCache = new HashMap<String, SoftReference<IQueryResult<IInstallableUnit>>>(2);
    private LocaleProvider localeProvider;

    static {
        capabilityMatch = ExpressionUtil.parse("providedCapabilities.exists(x | x.name == $0 && x.namespace == $1)");
    }

    public static synchronized TranslationSupport getInstance() {
        if (instance == null) {
            instance = new TranslationSupport();
        }
        return instance;
    }

    private List<String> buildLocaleVariants(String locale) {
        ArrayList<String> result = new ArrayList<String>(4);
        while (true) {
            result.add(locale);
            int lastSeparator = locale.lastIndexOf(95);
            if (lastSeparator == -1) break;
            locale = locale.substring(0, lastSeparator);
        }
        result.add(DEFAULT_LOCALE.toString());
        return result;
    }

    private String cacheResult(IInstallableUnit iu, String localizedKey, String localizedValue) {
        if (iu instanceof InstallableUnit) {
            ((InstallableUnit)iu).setLocalizedProperty(localizedKey, localizedValue);
        }
        return localizedValue;
    }

    public ICopyright getCopyright(IInstallableUnit iu, String locale) {
        ICopyright copyright;
        String body;
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        String string = body = (copyright = iu.getCopyright()) != null ? copyright.getBody() : null;
        if (body == null || body.length() <= 1 || body.charAt(0) != '%') {
            return copyright;
        }
        String actualKey = body.substring(1);
        body = this.getLocalizedIUProperty(iu, actualKey, locale);
        return MetadataFactory.createCopyright(copyright.getLocation(), body);
    }

    private String getCurrentLocale() {
        if (this.localeProvider != null) {
            return this.localeProvider.getLocale().toString();
        }
        return Locale.getDefault().toString();
    }

    public String getIUProperty(IInstallableUnit iu, String propertyKey, String locale) {
        String value;
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        if ((value = iu.getProperty(propertyKey)) == null || value.length() <= 1 || value.charAt(0) != '%') {
            return value;
        }
        String actualKey = value.substring(1);
        return this.getLocalizedIUProperty(iu, actualKey, locale);
    }

    public String getIUProperty(IInstallableUnit iu, String propertyKey) {
        return this.getIUProperty(iu, propertyKey, null);
    }

    private ILicense getLicense(IInstallableUnit iu, ILicense license, String locale) {
        String body;
        String string = body = license != null ? license.getBody() : null;
        if (body == null || body.length() <= 1 || body.charAt(0) != '%') {
            return license;
        }
        String actualKey = body.substring(1);
        body = this.getLocalizedIUProperty(iu, actualKey, locale);
        return MetadataFactory.createLicense(license.getLocation(), body);
    }

    public ILicense[] getLicenses(IInstallableUnit iu, String locale) {
        if (locale == null) {
            locale = this.getCurrentLocale();
        }
        Collection<ILicense> licenses = iu.getLicenses();
        ILicense[] translatedLicenses = new ILicense[licenses.size()];
        int i = 0;
        for (ILicense iLicense : licenses) {
            translatedLicenses[i++] = this.getLicense(iu, iLicense, locale);
        }
        return translatedLicenses;
    }

    private synchronized IQueryResult<IInstallableUnit> getLocalizationFragments(List<String> localeVariants, String locale) {
        Collector cached;
        if (this.fragmentSource == null) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata", "Profile registry unavailable. Default language will be used.", (Throwable)new RuntimeException()));
            return Collector.emptyCollector();
        }
        SoftReference<IQueryResult<IInstallableUnit>> queryResultReference = this.localeCollectorCache.get(locale);
        if (queryResultReference != null && (cached = (Collector)queryResultReference.get()) != null) {
            return cached;
        }
        List<String> locales = localeVariants;
        IQuery[] localeQuery = new IQuery[locales.size()];
        int j = 0;
        while (j < locales.size()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            localeQuery[j] = new ExpressionQuery(clazz, capabilityMatch, new Object[]{locales.get(j), NAMESPACE_IU_LOCALIZATION});
            ++j;
        }
        PipedQuery<IInstallableUnit> iuQuery = new PipedQuery<IInstallableUnit>(new FragmentQuery(), CompoundQuery.createCompoundQuery(localeQuery, false));
        IQueryResult<IInstallableUnit> collected = this.fragmentSource.query(iuQuery, null);
        this.localeCollectorCache.put(locale, new SoftReference<IQueryResult<IInstallableUnit>>(collected));
        return collected;
    }

    private String getLocalizedIUProperty(IInstallableUnit iu, String actualKey, String locale) {
        String localizedKey = this.makeLocalizedKey(actualKey, locale);
        String localizedValue = null;
        if (iu instanceof InstallableUnit) {
            localizedValue = ((InstallableUnit)iu).getLocalizedProperty(localizedKey);
        }
        if (localizedValue == null) {
            localizedValue = iu.getProperty(localizedKey);
        }
        if (localizedValue != null) {
            return localizedValue;
        }
        final IInstallableUnit theUnit = iu;
        MatchQuery<IInstallableUnit> hostLocalizationQuery = new MatchQuery<IInstallableUnit>(){

            @Override
            public boolean isMatch(IInstallableUnit object) {
                boolean haveHost = false;
                if (object instanceof IInstallableUnitFragment) {
                    IInstallableUnitFragment fragment = (IInstallableUnitFragment)object;
                    IRequirement[] hosts = fragment.getHost();
                    int i = 0;
                    while (i < hosts.length) {
                        if (theUnit.satisfies(hosts[i])) {
                            haveHost = true;
                            break;
                        }
                        ++i;
                    }
                }
                return haveHost;
            }
        };
        PipedQuery<IInstallableUnit> iuQuery = new PipedQuery<IInstallableUnit>(new FragmentQuery(), hostLocalizationQuery);
        List<String> locales = this.buildLocaleVariants(locale);
        IQueryResult<IInstallableUnit> localizationFragments = this.getLocalizationFragments(locales, locale);
        IQueryResult<IInstallableUnit> collected = iuQuery.perform(localizationFragments.iterator());
        if (!collected.isEmpty()) {
            String translation = null;
            Iterator<IInstallableUnit> iter = collected.iterator();
            while (iter.hasNext() && translation == null) {
                IInstallableUnit localizationIU = iter.next();
                Iterator<String> jter = locales.iterator();
                while (jter.hasNext()) {
                    String localeKey = this.makeLocalizedKey(actualKey, jter.next());
                    translation = localizationIU.getProperty(localeKey);
                    if (translation == null) continue;
                    return this.cacheResult(iu, localizedKey, translation);
                }
            }
        }
        for (String nextLocale : locales) {
            String localeKey = this.makeLocalizedKey(actualKey, nextLocale);
            String nextValue = iu.getProperty(localeKey);
            if (nextValue == null) continue;
            return this.cacheResult(iu, localizedKey, nextValue);
        }
        return this.cacheResult(iu, localizedKey, actualKey);
    }

    private String makeLocalizedKey(String actualKey, String localeImage) {
        return new StringBuffer(String.valueOf(localeImage)).append('.').append(actualKey).toString();
    }

    public void setLocaleProvider(LocaleProvider provider) {
        this.localeProvider = provider;
    }

    public IQueryable<IInstallableUnit> setTranslationSource(IQueryable<IInstallableUnit> queryable) {
        IQueryable<IInstallableUnit> previous = this.fragmentSource;
        this.fragmentSource = queryable;
        return previous;
    }
}

