/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.exemplarysetup;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.garbagecollector.GarbageCollector;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    public static BundleContext context;
    public static final String ID = "org.eclipse.equinox.p2.exemplarysetup";
    private IProvisioningAgent agent;
    private IProvisioningEventBus bus;
    private ServiceRegistration registrationBus;
    private ServiceRegistration registrationDefaultManager;
    private ServiceRegistration registrationDirector;
    private ServiceRegistration registrationPlanner;
    private ServiceRegistration registrationProfileRegistry;

    private void registerAgent() {
        ServiceReference locationRef = context.getServiceReference(IAgentLocation.SERVICE_NAME);
        if (locationRef == null) {
            throw new RuntimeException("Unable to instantiate p2 agent because agent location is not available");
        }
        IAgentLocation location = (IAgentLocation)context.getService(locationRef);
        if (location == null) {
            throw new RuntimeException("Unable to instantiate p2 agent because agent location is not available");
        }
        ServiceReference agentProviderRef = context.getServiceReference(IProvisioningAgentProvider.SERVICE_NAME);
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)context.getService(agentProviderRef);
        try {
            this.agent = provider.createAgent(null);
        }
        catch (Exception e) {
            String msg = "Unable to instantiate p2 agent at location " + location.getRootLocation();
            LogHelper.log((IStatus)new Status(4, ID, msg, (Throwable)e));
            throw new RuntimeException(msg);
        }
    }

    private void registerDirector() {
        IDirector director = (IDirector)this.agent.getService(IDirector.SERVICE_NAME);
        this.registrationDirector = context.registerService(IDirector.SERVICE_NAME, (Object)director, null);
    }

    private void registerEventBus() {
        this.bus = (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.SERVICE_NAME);
        this.registrationBus = context.registerService(IProvisioningEventBus.SERVICE_NAME, (Object)this.bus, null);
    }

    private void registerMetadataRepositoryManager() {
        if (context.getServiceReference(IMetadataRepositoryManager.SERVICE_NAME) == null) {
            IMetadataRepositoryManager manager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            this.registrationDefaultManager = context.registerService(IMetadataRepositoryManager.SERVICE_NAME, (Object)manager, null);
        }
    }

    private void registerPlanner() {
        IPlanner planner = (IPlanner)this.agent.getService(IPlanner.SERVICE_NAME);
        this.registrationPlanner = context.registerService(IPlanner.SERVICE_NAME, (Object)planner, null);
    }

    private void registerProfileRegistry() {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
        this.registrationProfileRegistry = context.registerService(IProfileRegistry.SERVICE_NAME, (Object)profileRegistry, null);
    }

    public void start(BundleContext aContext) throws Exception {
        context = aContext;
        this.registerAgent();
        this.registerEventBus();
        this.registerProfileRegistry();
        this.registerMetadataRepositoryManager();
        this.registerPlanner();
        this.registerDirector();
        this.startGarbageCollector();
    }

    private void startGarbageCollector() {
        new GarbageCollector();
    }

    public void stop(BundleContext aContext) throws Exception {
        this.unregisterDirector();
        this.unregisterPlanner();
        this.unregisterDefaultMetadataRepoManager();
        this.unregisterProfileRegistry();
        this.unregisterEventBus();
        this.unregisterAgent();
        context = null;
    }

    private void unregisterAgent() {
        if (this.agent != null) {
            this.agent.stop();
            this.agent = null;
        }
    }

    private void unregisterDefaultMetadataRepoManager() {
        if (this.registrationDefaultManager != null) {
            this.registrationDefaultManager.unregister();
            this.registrationDefaultManager = null;
        }
    }

    private void unregisterDirector() {
        this.registrationDirector.unregister();
        this.registrationDirector = null;
    }

    private void unregisterEventBus() {
        if (this.registrationBus != null) {
            this.registrationBus.unregister();
            this.registrationBus = null;
        }
        if (this.bus != null) {
            this.bus.close();
            this.bus = null;
        }
    }

    private void unregisterPlanner() {
        this.registrationPlanner.unregister();
        this.registrationPlanner = null;
    }

    private void unregisterProfileRegistry() {
        this.registrationProfileRegistry.unregister();
        this.registrationProfileRegistry = null;
    }
}

