/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileChangeRequest
implements Cloneable {
    private final IProfile profile;
    private ArrayList<IInstallableUnit> iusToRemove = null;
    private ArrayList<IInstallableUnit> iusToAdd = null;
    private ArrayList<String> propertiesToRemove = null;
    private HashMap<String, String> propertiesToAdd = null;
    private HashMap<IInstallableUnit, Map<String, String>> iuPropertiesToAdd = null;
    private HashMap<IInstallableUnit, List<String>> iuPropertiesToRemove = null;
    private boolean isAbsolute = false;

    public static ProfileChangeRequest createByProfileId(String profileId) {
        IProfileRegistry profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            throw new IllegalStateException(Messages.Planner_no_profile_registry);
        }
        IProfile profile = profileRegistry.getProfile(profileId);
        if (profile == null) {
            throw new IllegalArgumentException(new StringBuffer("Profile id ").append(profileId).append(" is not registered.").toString());
        }
        return new ProfileChangeRequest(profile);
    }

    public ProfileChangeRequest(IProfile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("Profile cannot be null.");
        }
        this.profile = profile;
    }

    public IProfile getProfile() {
        return this.profile;
    }

    public Map<String, String> getProfileProperties() {
        HashMap<String, String> result = new HashMap<String, String>(this.profile.getProperties());
        if (this.propertiesToRemove != null) {
            for (String key : this.propertiesToRemove) {
                result.remove(key);
            }
        }
        if (this.propertiesToAdd != null) {
            result.putAll(this.propertiesToAdd);
        }
        return result;
    }

    private void addInstallableUnit(IInstallableUnit toInstall) {
        if (this.iusToAdd == null) {
            this.iusToAdd = new ArrayList();
        }
        this.iusToAdd.add(toInstall);
    }

    public void addInstallableUnits(Collection<IInstallableUnit> toInstall) {
        for (IInstallableUnit iu : toInstall) {
            this.addInstallableUnit(iu);
        }
    }

    public void addInstallableUnits(IQueryResult<IInstallableUnit> toInstall) {
        Iterator itor = toInstall.iterator();
        while (itor.hasNext()) {
            this.addInstallableUnit((IInstallableUnit)itor.next());
        }
    }

    public void addInstallableUnits(IInstallableUnit[] toInstall) {
        int i = 0;
        while (i < toInstall.length) {
            this.addInstallableUnit(toInstall[i]);
            ++i;
        }
    }

    public void removeInstallableUnit(IInstallableUnit toUninstall) {
        if (this.iusToRemove == null) {
            this.iusToRemove = new ArrayList();
        }
        this.iusToRemove.add(toUninstall);
    }

    public void removeInstallableUnits(IInstallableUnit[] toUninstall) {
        int i = 0;
        while (i < toUninstall.length) {
            this.removeInstallableUnit(toUninstall[i]);
            ++i;
        }
    }

    public void removeInstallableUnits(Collection<IInstallableUnit> toUninstall) {
        for (IInstallableUnit iu : toUninstall) {
            this.removeInstallableUnit(iu);
        }
    }

    public void removeInstallableUnits(IQueryResult<IInstallableUnit> toUninstall) {
        Iterator itor = toUninstall.iterator();
        while (itor.hasNext()) {
            this.removeInstallableUnit((IInstallableUnit)itor.next());
        }
    }

    public void setProfileProperty(String key, String value) {
        if (this.propertiesToAdd == null) {
            this.propertiesToAdd = new HashMap();
        }
        this.propertiesToAdd.put(key, value);
    }

    public void removeProfileProperty(String key) {
        if (this.propertiesToRemove == null) {
            this.propertiesToRemove = new ArrayList(1);
        }
        this.propertiesToRemove.add(key);
    }

    public void setInstallableUnitProfileProperty(IInstallableUnit iu, String key, String value) {
        Map<String, String> properties;
        if (this.iuPropertiesToAdd == null) {
            this.iuPropertiesToAdd = new HashMap();
        }
        if ((properties = this.iuPropertiesToAdd.get(iu)) == null) {
            properties = new HashMap<String, String>();
            this.iuPropertiesToAdd.put(iu, properties);
        }
        properties.put(key, value);
    }

    public void removeInstallableUnitProfileProperty(IInstallableUnit iu, String key) {
        List<String> keys;
        if (this.iuPropertiesToRemove == null) {
            this.iuPropertiesToRemove = new HashMap();
        }
        if ((keys = this.iuPropertiesToRemove.get(iu)) == null) {
            keys = new ArrayList<String>();
            this.iuPropertiesToRemove.put(iu, keys);
        }
        keys.add(key);
    }

    public IInstallableUnit[] getRemovedInstallableUnits() {
        if (this.iusToRemove == null) {
            return new IInstallableUnit[0];
        }
        return this.iusToRemove.toArray(new IInstallableUnit[this.iusToRemove.size()]);
    }

    public IInstallableUnit[] getAddedInstallableUnits() {
        if (this.iusToAdd == null) {
            return new IInstallableUnit[0];
        }
        return this.iusToAdd.toArray(new IInstallableUnit[this.iusToAdd.size()]);
    }

    public String[] getPropertiesToRemove() {
        if (this.propertiesToRemove == null) {
            return new String[0];
        }
        return this.propertiesToRemove.toArray(new String[this.propertiesToRemove.size()]);
    }

    public Map<String, String> getPropertiesToAdd() {
        if (this.propertiesToAdd == null) {
            return CollectionUtils.emptyMap();
        }
        return this.propertiesToAdd;
    }

    public Map<IInstallableUnit, List<String>> getInstallableUnitProfilePropertiesToRemove() {
        if (this.iuPropertiesToRemove == null) {
            return CollectionUtils.emptyMap();
        }
        return this.iuPropertiesToRemove;
    }

    public Map<IInstallableUnit, Map<String, String>> getInstallableUnitProfilePropertiesToAdd() {
        if (this.iuPropertiesToAdd == null) {
            return CollectionUtils.emptyMap();
        }
        return this.iuPropertiesToAdd;
    }

    public void setInstallableUnitInclusionRules(IInstallableUnit iu, String value) {
        this.setInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.internal.inclusion.rules", value);
    }

    public void removeInstallableUnitInclusionRules(IInstallableUnit iu) {
        this.removeInstallableUnitProfileProperty(iu, "org.eclipse.equinox.p2.internal.inclusion.rules");
    }

    public void setAbsoluteMode(boolean absolute) {
        this.isAbsolute = absolute;
    }

    public boolean getAbsolute() {
        return this.isAbsolute;
    }

    public Object clone() {
        ProfileChangeRequest result = new ProfileChangeRequest(this.profile);
        result.iusToRemove = this.iusToRemove == null ? null : (ArrayList)this.iusToRemove.clone();
        result.iusToAdd = this.iusToAdd == null ? null : (ArrayList)this.iusToAdd.clone();
        result.propertiesToRemove = this.propertiesToRemove == null ? null : (ArrayList)this.propertiesToRemove.clone();
        result.propertiesToAdd = this.propertiesToAdd == null ? null : (HashMap)this.propertiesToAdd.clone();
        result.iuPropertiesToAdd = this.iuPropertiesToAdd == null ? null : (HashMap)this.iuPropertiesToAdd.clone();
        result.iuPropertiesToRemove = this.iuPropertiesToRemove == null ? null : (HashMap)this.iuPropertiesToRemove.clone();
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(1000);
        result.append("==Profile change request for ");
        result.append(this.profile.getProfileId());
        result.append('\n');
        result.append("==Additions==");
        result.append('\n');
        for (IInstallableUnit iu : this.iusToAdd) {
            result.append('\t');
            result.append(iu);
            result.append('\n');
        }
        result.append("==Removals==");
        result.append('\n');
        for (IInstallableUnit iu : this.iusToRemove) {
            result.append('\t');
            result.append(iu);
            result.append('\n');
        }
        return result.toString();
    }
}

