/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.equinox.internal.p2.metadata.expression.IRepeatableIterator;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepeatableIterator<T>
implements IRepeatableIterator<T> {
    private final List<T> values;
    private int position = -1;

    public static <T> IRepeatableIterator<T> create(Object unknown) {
        if (unknown.getClass().isArray()) {
            return RepeatableIterator.create((Object[])unknown);
        }
        if (unknown instanceof Iterator) {
            return RepeatableIterator.create((Iterator)unknown);
        }
        if (unknown instanceof List) {
            return RepeatableIterator.create((List)unknown);
        }
        if (unknown instanceof Collection) {
            return RepeatableIterator.create((Collection)unknown);
        }
        if (unknown instanceof Map) {
            return RepeatableIterator.create(((Map)unknown).entrySet());
        }
        if (unknown instanceof IQueryResult) {
            return RepeatableIterator.create((IQueryResult)unknown);
        }
        throw new IllegalArgumentException(new StringBuffer("Cannot convert a ").append(unknown.getClass().getName()).append(" into an iterator").toString());
    }

    public static <T> IRepeatableIterator<T> create(Iterator<T> iterator) {
        return iterator instanceof IRepeatableIterator ? ((IRepeatableIterator)iterator).getCopy() : new ElementRetainingIterator<T>(iterator);
    }

    public static <T> IRepeatableIterator<T> create(List<T> values) {
        return new RepeatableIterator<T>(values);
    }

    public static <T> IRepeatableIterator<T> create(Collection<T> values) {
        return new CollectionIterator<T>(values);
    }

    public static <T> IRepeatableIterator<T> create(IQueryResult<T> values) {
        return new QueryResultIterator<T>(values);
    }

    public static <T> IRepeatableIterator<T> create(T[] values) {
        return new ArrayIterator<T>(values);
    }

    RepeatableIterator(List<T> values) {
        this.values = values;
    }

    @Override
    public IRepeatableIterator<T> getCopy() {
        return new RepeatableIterator<T>(this.values);
    }

    @Override
    public boolean hasNext() {
        return this.position + 1 < this.values.size();
    }

    @Override
    public T next() {
        if (++this.position == this.values.size()) {
            --this.position;
            throw new NoSuchElementException();
        }
        return this.values.get(this.position);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getIteratorProvider() {
        return this.values;
    }

    void setPosition(int position) {
        this.position = position;
    }

    List<T> getValues() {
        return this.values;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayIterator<T>
    implements IRepeatableIterator<T> {
        private final T[] array;
        private int position = -1;

        public ArrayIterator(T[] array) {
            this.array = array;
        }

        @Override
        public Object getIteratorProvider() {
            return this.array;
        }

        @Override
        public boolean hasNext() {
            return this.position + 1 < this.array.length;
        }

        @Override
        public T next() {
            if (++this.position >= this.array.length) {
                throw new NoSuchElementException();
            }
            return this.array[this.position];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IRepeatableIterator<T> getCopy() {
            return new ArrayIterator<T>(this.array);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CollectionIterator<T>
    implements IRepeatableIterator<T> {
        private final Collection<T> collection;
        private final Iterator<T> iterator;

        CollectionIterator(Collection<T> collection) {
            this.collection = collection;
            this.iterator = collection.iterator();
        }

        @Override
        public IRepeatableIterator<T> getCopy() {
            return new CollectionIterator<T>(this.collection);
        }

        @Override
        public Object getIteratorProvider() {
            return this.collection;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ElementRetainingIterator<T>
    extends RepeatableIterator<T> {
        private Iterator<T> innerIterator;

        ElementRetainingIterator(Iterator<T> iterator) {
            super(new ArrayList());
            this.innerIterator = iterator;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.innerIterator != null) {
                if (this.innerIterator.hasNext()) {
                    return true;
                }
                this.innerIterator = null;
                this.setPosition(this.getValues().size());
            }
            return super.hasNext();
        }

        @Override
        public synchronized T next() {
            if (this.innerIterator != null) {
                T val = this.innerIterator.next();
                this.getValues().add(val);
                return val;
            }
            return super.next();
        }

        @Override
        public synchronized IRepeatableIterator<T> getCopy() {
            this.exhaustInnerIterator();
            return super.getCopy();
        }

        @Override
        public synchronized Object getIteratorProvider() {
            this.exhaustInnerIterator();
            return super.getIteratorProvider();
        }

        private void exhaustInnerIterator() {
            if (this.innerIterator != null) {
                List values = this.getValues();
                int savePos = values.size() - 1;
                while (this.innerIterator.hasNext()) {
                    values.add(this.innerIterator.next());
                }
                this.innerIterator = null;
                this.setPosition(savePos);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryResultIterator<T>
    implements IRepeatableIterator<T> {
        private final IQueryResult<T> queryResult;
        private final Iterator<T> iterator;

        QueryResultIterator(IQueryResult<T> queryResult) {
            this.queryResult = queryResult;
            this.iterator = queryResult.iterator();
        }

        @Override
        public IRepeatableIterator<T> getCopy() {
            return new QueryResultIterator<T>(this.queryResult);
        }

        @Override
        public Object getIteratorProvider() {
            return this.queryResult;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

