/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.metadata.expression;

import java.io.Serializable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePattern
implements Serializable,
Comparable<SimplePattern> {
    private static final long serialVersionUID = -2477990705739062410L;
    private final String pattern;
    private transient Node node;

    public synchronized boolean isMatch(CharSequence value) {
        if (this.node == null) {
            this.node = SimplePattern.parse(this.pattern, 0);
        }
        return this.node.match(value, 0);
    }

    public String toString() {
        return this.pattern;
    }

    @Override
    public int compareTo(SimplePattern o) {
        return this.pattern.compareTo(o.pattern);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof SimplePattern && ((SimplePattern)o).pattern.equals(this.pattern);
    }

    public int hashCode() {
        return 3 * this.pattern.hashCode();
    }

    private SimplePattern(String pattern, Node node) {
        this.pattern = pattern;
        this.node = node;
    }

    public static SimplePattern compile(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern can not be null");
        }
        return new SimplePattern(pattern, null);
    }

    private static Node parse(String pattern, int pos) {
        int top = pattern.length();
        StringBuffer bld = null;
        Node parsedNode = null;
        block5: while (pos < top) {
            char c = pattern.charAt(pos);
            switch (c) {
                case '*': {
                    parsedNode = new RubberBandNode(SimplePattern.parse(pattern, pos + 1));
                    break block5;
                }
                case '?': {
                    parsedNode = new AnyCharacterNode(SimplePattern.parse(pattern, pos + 1));
                    break block5;
                }
                case '\\': {
                    if (++pos == top) {
                        throw new IllegalArgumentException("Pattern ends with escape");
                    }
                    c = pattern.charAt(pos);
                }
                default: {
                    if (bld == null) {
                        bld = new StringBuffer();
                    }
                    bld.append(c);
                    ++pos;
                }
            }
        }
        if (bld != null) {
            parsedNode = new ConstantNode(parsedNode, bld.toString());
        }
        return parsedNode;
    }

    private static class AnyCharacterNode
    extends Node {
        AnyCharacterNode(Node next) {
            super(next);
        }

        boolean match(CharSequence value, int pos) {
            int top = value.length();
            return this.next == null ? pos + 1 == top : this.next.match(value, pos + 1);
        }
    }

    private static class ConstantNode
    extends Node {
        final String constant;

        ConstantNode(Node next, String constant) {
            super(next);
            this.constant = constant;
        }

        boolean match(CharSequence value, int pos) {
            int vtop = value.length();
            int ctop = this.constant.length();
            if (ctop + pos > vtop) {
                return false;
            }
            int idx = 0;
            while (idx < ctop) {
                if (this.constant.charAt(idx) != value.charAt(pos)) {
                    return false;
                }
                ++idx;
                ++pos;
            }
            return this.next == null ? true : this.next.match(value, pos);
        }
    }

    private static abstract class Node {
        final Node next;

        Node(Node next) {
            this.next = next;
        }

        abstract boolean match(CharSequence var1, int var2);
    }

    private static class RubberBandNode
    extends Node {
        RubberBandNode(Node next) {
            super(next);
        }

        boolean match(CharSequence value, int pos) {
            if (this.next == null) {
                return true;
            }
            int top = value.length();
            while (pos < top) {
                if (!this.next.match(value, pos++)) continue;
                return true;
            }
            return false;
        }
    }
}

