/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

public class MinWatchCard
implements Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean ATLEAST = true;
    public static final boolean ATMOST = false;
    protected int degree;
    private final int[] lits;
    private boolean moreThan;
    protected int watchCumul;
    private final ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.card.MinWatchCard");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MinWatchCard(ILits iLits, IVecInt iVecInt, boolean bl, int n) {
        this.voc = iLits;
        this.degree = n;
        this.moreThan = bl;
        int[] nArray = new int[iLits.nVars() * 2 + 2];
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            int n3 = iVecInt.get(n2);
            if (nArray[n3 ^ 1] == 0) {
                int n4 = n3;
                nArray[n4] = nArray[n4] + 1;
            } else {
                int n5 = n3 ^ 1;
                nArray[n5] = nArray[n5] - 1;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < iVecInt.size()) {
            if (nArray[iVecInt.get(n2)] > 0) {
                int n6 = iVecInt.get(n2);
                nArray[n6] = nArray[n6] - 1;
                ++n2;
                continue;
            }
            if ((iVecInt.get(n2) & 1) != 0) {
                --this.degree;
            }
            iVecInt.delete(n2);
        }
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
        this.normalize();
    }

    protected MinWatchCard(ILits iLits, IVecInt iVecInt, int n) {
        this.voc = iLits;
        this.degree = n;
        this.moreThan = true;
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int n2 = 0;
        while (n2 < this.lits.length) {
            if (this.voc.isFalsified(this.lits[n2])) {
                iVecInt.push(this.lits[n2] ^ 1);
            }
            ++n2;
        }
    }

    public double getActivity() {
        return 0.0;
    }

    public void incActivity(double d) {
    }

    public boolean learnt() {
        return false;
    }

    protected static int linearisation(ILits iLits, IVecInt iVecInt) {
        int n = 0;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            if (iLits.isUnassigned(iVecInt.get(n2))) {
                ++n2;
                continue;
            }
            if (iLits.isSatisfied(iVecInt.get(n2))) {
                --n;
            }
            iVecInt.set(n2, iVecInt.last());
            iVecInt.pop();
        }
        if (!$assertionsDisabled && n > 0) {
            throw new AssertionError();
        }
        return n;
    }

    public boolean locked() {
        return true;
    }

    public static MinWatchCard minWatchCardNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, boolean bl, int n) throws ContradictionException {
        int n2 = n + MinWatchCard.linearisation(iLits, iVecInt);
        if (iVecInt.size() == 0 && n2 > 0) {
            throw new ContradictionException();
        }
        if (iVecInt.size() == n2 || iVecInt.size() <= 0) {
            int n3 = 0;
            while (n3 < iVecInt.size()) {
                if (!unitPropagationListener.enqueue(iVecInt.get(n3))) {
                    throw new ContradictionException();
                }
                ++n3;
            }
            return null;
        }
        MinWatchCard minWatchCard = new MinWatchCard(iLits, iVecInt, bl, n2);
        if (minWatchCard.degree <= 0) {
            return null;
        }
        minWatchCard.computeWatches();
        minWatchCard.computePropagation(unitPropagationListener);
        return minWatchCard;
    }

    public final void normalize() {
        if (!this.moreThan) {
            this.degree = 0 - this.degree;
            int n = 0;
            while (n < this.lits.length) {
                this.lits[n] = this.lits[n] ^ 1;
                ++this.degree;
                ++n;
            }
            this.moreThan = true;
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        if (this.watchCumul == this.degree) {
            this.voc.watch(n, this);
            return false;
        }
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        if (!$assertionsDisabled && this.watchCumul <= this.degree) {
            throw new AssertionError();
        }
        int n3 = this.degree + 1;
        while (n3 < this.lits.length && this.voc.isFalsified(this.lits[n3])) {
            ++n3;
        }
        if (n3 == this.lits.length) {
            this.voc.watch(n, this);
            --this.watchCumul;
            if (!$assertionsDisabled && this.watchCumul != this.degree) {
                throw new AssertionError();
            }
            this.voc.undos(n).push(this);
            int n4 = 0;
            while (n4 <= this.degree) {
                if (n != (this.lits[n4] ^ 1) && !unitPropagationListener.enqueue(this.lits[n4], this)) {
                    return false;
                }
                ++n4;
            }
            return true;
        }
        int n5 = this.lits[n3];
        this.lits[n3] = this.lits[n2];
        this.lits[n2] = n5;
        this.voc.watch(n5 ^ 1, this);
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < Math.min(this.degree + 1, this.lits.length)) {
            this.voc.watches(this.lits[n] ^ 1).remove(this);
            ++n;
        }
    }

    public void rescaleBy(double d) {
    }

    public boolean simplify() {
        int n = 0;
        int n2 = 0;
        while (n < this.lits.length) {
            if (this.voc.isSatisfied(this.lits[n]) && ++n2 == this.degree) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Card (" + this.lits.length + ") : ");
        if (this.lits.length > 0) {
            stringBuffer.append(Lits.toString(this.lits[0]));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[0]));
            stringBuffer.append("@");
            stringBuffer.append(this.voc.getLevel(this.lits[0]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
            int n = 1;
            while (n < this.lits.length) {
                stringBuffer.append(" + ");
                stringBuffer.append(Lits.toString(this.lits[n]));
                stringBuffer.append("[");
                stringBuffer.append(this.voc.valueToString(this.lits[n]));
                stringBuffer.append("@");
                stringBuffer.append(this.voc.getLevel(this.lits[n]));
                stringBuffer.append("]");
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append(">= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    public void undo(int n) {
        ++this.watchCumul;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }

    /*
     * Unable to fully structure code
     */
    protected void computeWatches() {
        var1_1 = this.lits.length;
        var3_2 = 0;
        ** GOTO lbl13
        {
            var2_3 = this.lits[var3_2];
            this.lits[var3_2] = this.lits[var1_1];
            this.lits[var1_1] = var2_3;
            do {
                if (this.voc.isFalsified(this.lits[var3_2]) && --var1_1 > var3_2) continue block0;
                if (!this.voc.isFalsified(this.lits[var3_2])) {
                    ++this.watchCumul;
                    this.voc.watch(this.lits[var3_2] ^ 1, this);
                }
                ++var3_2;
lbl13:
                // 2 sources

            } while (var3_2 <= this.degree && var3_2 < var1_1);
        }
        if (this.learnt()) {
            var3_2 = 1;
            while (this.watchCumul <= this.degree && var3_2 > 0) {
                var3_2 = 0;
                var4_4 = -1;
                var5_5 = -1;
                var6_6 = this.watchCumul;
                while (var6_6 < this.lits.length) {
                    if (this.voc.isFalsified(this.lits[var6_6])) {
                        ++var3_2;
                        var7_7 = this.voc.getLevel(this.lits[var6_6]);
                        if (var7_7 > var4_4) {
                            var5_5 = var6_6;
                            var4_4 = var7_7;
                        }
                    }
                    ++var6_6;
                }
                if (var3_2 <= 0) continue;
                if (!MinWatchCard.$assertionsDisabled && var5_5 < 0) {
                    throw new AssertionError();
                }
                this.voc.watch(this.lits[var5_5] ^ 1, this);
                var2_3 = this.lits[var5_5];
                this.lits[var5_5] = this.lits[this.watchCumul];
                this.lits[this.watchCumul] = var2_3;
                ++this.watchCumul;
                if (!MinWatchCard.$assertionsDisabled && --var3_2 < 0) {
                    throw new AssertionError();
                }
            }
            if (!MinWatchCard.$assertionsDisabled && this.lits.length != 1 && this.watchCumul <= 1) {
                throw new AssertionError();
            }
        }
    }

    protected MinWatchCard computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        if (this.watchCumul == this.degree) {
            int n = 0;
            while (n < this.lits.length) {
                if (!unitPropagationListener.enqueue(this.lits[n])) {
                    throw new ContradictionException();
                }
                ++n;
            }
            return null;
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException();
        }
        return this;
    }

    public int[] getLits() {
        int[] nArray = new int[this.size()];
        System.arraycopy(this.lits, 0, nArray, 0, this.size());
        return nArray;
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            MinWatchCard minWatchCard = (MinWatchCard)object;
            if (minWatchCard.degree != this.degree) {
                return false;
            }
            if (this.lits.length != minWatchCard.lits.length) {
                return false;
            }
            int[] nArray = this.lits;
            int n = this.lits.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                int n3 = nArray[n2];
                boolean bl = false;
                int[] nArray2 = minWatchCard.lits;
                int n4 = minWatchCard.lits.length;
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = nArray2[n5];
                    if (n3 == n6) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    return false;
                }
                ++n2;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 0L;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            l += (long)n3;
            ++n2;
        }
        return (int)(l += (long)this.degree) / (this.lits.length + 1);
    }

    public void forwardActivity(double d) {
    }
}

