/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.query.QueryHelpers;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.ICompositeQuery;
import org.eclipse.equinox.p2.query.IMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundQuery<T>
implements ICompositeQuery<T> {
    IQuery<T>[] queries;
    boolean and;

    public static <T> CompoundQuery<T> createCompoundQuery(IQuery<T>[] queries, boolean and) {
        if (CompoundQuery.isMatchQueries(queries)) {
            return new MatchCompoundQuery<T>(queries, and);
        }
        return new ContextCompoundQuery<T>(queries, and);
    }

    public static <T> CompoundQuery<T> createCompoundQuery(IQuery<T> query1, IQuery<T> query2, boolean and) {
        return CompoundQuery.createCompoundQuery(new IQuery[]{query1, query2}, and);
    }

    @Override
    public List<IQuery<T>> getQueries() {
        return Arrays.asList(this.queries);
    }

    public boolean isAnd() {
        return this.and;
    }

    protected CompoundQuery(IQuery<T>[] queries, boolean and) {
        this.queries = queries;
        this.and = and;
    }

    private static boolean isMatchQueries(IQuery<?>[] queries) {
        int i = 0;
        while (i < queries.length) {
            if (!(queries[i] instanceof IMatchQuery)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public String getId() {
        return QueryHelpers.getId(this);
    }

    @Override
    public Object getProperty(String property) {
        return QueryHelpers.getProperty(this, property);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextCompoundQuery<T>
    extends CompoundQuery<T> {
        protected ContextCompoundQuery(IQuery<T>[] queries, boolean and) {
            super(queries, and);
        }

        @Override
        public IQueryResult<T> perform(Iterator<T> iterator) {
            Set result;
            if (this.queries.length < 1) {
                return Collector.emptyCollector();
            }
            if (this.queries.length == 1) {
                return this.queries[0].perform(iterator);
            }
            ArrayList<T> data = new ArrayList<T>();
            while (iterator.hasNext()) {
                data.add(iterator.next());
            }
            if (this.isAnd()) {
                result = this.queries[0].perform(data.iterator()).unmodifiableSet();
                int i = 1;
                while (i < this.queries.length && result.size() > 0) {
                    HashSet retained = new HashSet();
                    Iterator itor = this.queries[i].perform(data.iterator()).iterator();
                    while (itor.hasNext()) {
                        Object nxt = itor.next();
                        if (!result.contains(nxt)) continue;
                        retained.add(nxt);
                    }
                    result = retained;
                    ++i;
                }
            } else {
                result = this.queries[0].perform(data.iterator()).toSet();
                int i = 1;
                while (i < this.queries.length) {
                    Iterator itor = this.queries[i].perform(data.iterator()).iterator();
                    while (itor.hasNext()) {
                        result.add(itor.next());
                    }
                    ++i;
                }
            }
            return new SetCollector(result);
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class SetCollector<T>
        implements IQueryResult<T> {
            private final Set<T> s;

            public SetCollector(Set<T> s) {
                this.s = s;
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            @Override
            public Iterator<T> iterator() {
                return this.s.iterator();
            }

            @Override
            public T[] toArray(Class<? extends T> clazz) {
                return this.s.toArray((Object[])Array.newInstance(clazz, this.s.size()));
            }

            @Override
            public IQueryResult<T> query(IQuery<T> query, IProgressMonitor monitor) {
                return query.perform(this.iterator());
            }

            @Override
            public Set<T> toSet() {
                return new HashSet<T>(this.s);
            }

            @Override
            public Set<T> unmodifiableSet() {
                return Collections.unmodifiableSet(this.s);
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchCompoundQuery<T>
    extends CompoundQuery<T>
    implements IMatchQuery<T> {
        protected MatchCompoundQuery(IQuery<T>[] queries, boolean and) {
            super(queries, and);
        }

        @Override
        public boolean isMatch(T candidate) {
            int i = 0;
            while (i < this.queries.length) {
                boolean valid = ((IMatchQuery)this.queries[i]).isMatch(candidate);
                if (valid && !this.and) {
                    return true;
                }
                if (!valid && this.and) {
                    return false;
                }
                ++i;
            }
            return this.and;
        }

        @Override
        public final IQueryResult<T> perform(Iterator<T> iterator) {
            this.prePerform();
            Collector<T> result = new Collector<T>();
            try {
                while (iterator.hasNext()) {
                    T candidate = iterator.next();
                    if (!this.isMatch(candidate) || result.accept(candidate)) continue;
                    break;
                }
            }
            finally {
                this.postPerform();
            }
            return result;
        }

        @Override
        public void prePerform() {
            int i = 0;
            while (i < this.queries.length) {
                ((IMatchQuery)this.queries[i]).prePerform();
                ++i;
            }
        }

        @Override
        public void postPerform() {
            int i = 0;
            while (i < this.queries.length) {
                ((IMatchQuery)this.queries[i]).postPerform();
                ++i;
            }
        }
    }
}

