/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.net.URI;
import org.eclipse.b3.util.B3Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.repository.IRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2Utils {
    private static final long AGENT_STOP_DELAY = 2000L;

    public static IProvisioningAgent createDedicatedProvisioningAgent(URI location) throws CoreException {
        IProvisioningAgentProvider agentProvider = null;
        try {
            IProvisioningAgent agent;
            agentProvider = (IProvisioningAgentProvider)B3Util.getPlugin().getService(IProvisioningAgentProvider.class);
            IProvisioningAgent iProvisioningAgent = agent = agentProvider.createAgent(location);
            return iProvisioningAgent;
        }
        finally {
            B3Util.getPlugin().ungetService((Object)agentProvider);
        }
    }

    public static void destroyProvisioningAgent(final IProvisioningAgent agent) {
        if (agent != null) {
            Job stopJob = new Job("AgentStopper"){

                protected IStatus run(IProgressMonitor monitor) {
                    agent.stop();
                    return Status.OK_STATUS;
                }
            };
            stopJob.setSystem(true);
            stopJob.schedule(2000L);
        }
    }

    public static IPlanner getPlanner(IProvisioningAgent agent) {
        return P2Utils.getP2Service(agent, IPlanner.class);
    }

    public static IProfileRegistry getProfileRegistry(IProvisioningAgent agent) {
        return P2Utils.getP2Service(agent, IProfileRegistry.class);
    }

    public static <T extends IRepositoryManager<?>> T getRepositoryManager(Class<T> clazz) {
        return (T)((IRepositoryManager)P2Utils.getP2Service(null, clazz));
    }

    public static <T extends IRepositoryManager<?>> T getRepositoryManager(IProvisioningAgent agent, Class<T> clazz) {
        return (T)((IRepositoryManager)P2Utils.getP2Service(agent, clazz));
    }

    public static void ungetPlanner(IPlanner planner) {
        B3Util.getPlugin().ungetService((Object)planner);
    }

    public static void ungetProfileRegistry(IProfileRegistry registry) {
        B3Util.getPlugin().ungetService((Object)registry);
    }

    public static void ungetRepositoryManager(IRepositoryManager<?> manager) {
        B3Util.getPlugin().ungetService(manager);
    }

    private static <T> T getP2Service(IProvisioningAgent agent, Class<T> clazz) {
        try {
            Object service;
            if (agent == null) {
                try {
                    agent = (IProvisioningAgent)B3Util.getPlugin().getService(IProvisioningAgent.class);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (agent == null) {
                    IProvisioningAgentProvider agentProvider = (IProvisioningAgentProvider)B3Util.getPlugin().getService(IProvisioningAgentProvider.class);
                    agent = agentProvider.createAgent(null);
                    B3Util.getPlugin().ungetService((Object)agentProvider);
                }
            }
            if ((service = agent.getService(clazz.getName())) == null) {
                String filter = "(&(p2.agent.servicename=" + clazz.getName() + "))";
                IAgentServiceFactory serviceFactory = (IAgentServiceFactory)B3Util.getPlugin().getService(IAgentServiceFactory.class, filter);
                service = serviceFactory.createService(agent);
                B3Util.getPlugin().ungetService((Object)serviceFactory);
            }
            T result = clazz.cast(service);
            B3Util.getPlugin().ungetService((Object)agent);
            if (result != null) {
                return result;
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        throw new RuntimeException("p2 service " + clazz.getName() + "not available");
    }
}

