/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.PathVariable;
import org.eclipse.core.internal.resources.PathVariableManager;
import org.eclipse.core.internal.resources.PathVariableUtil;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectVariableProviderManager;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.VariableDescription;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IPathVariable;
import org.eclipse.core.resources.IPathVariableChangeListener;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ProjectPathVariableManager
implements IPathVariableManager,
IManager {
    private Project project;
    private ProjectVariableProviderManager.Descriptor[] variableProviders = null;

    public ProjectPathVariableManager(Project project) {
        this.project = project;
        this.variableProviders = ProjectVariableProviderManager.getDefault().getDescriptors();
    }

    PathVariableManager getWorkspaceManager() {
        return (PathVariableManager)this.project.getWorkspace().getPathVariableManager();
    }

    private void checkIsValidName(String name) throws CoreException {
        IStatus status = this.validateName(name);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    private void checkIsValidValue(URI newValue) throws CoreException {
        IStatus status = this.validateValue(newValue);
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public IPathVariable getPathVariable(String name, IResource resource) {
        if (this.isDefined(name, resource)) {
            return new PathVariable(name);
        }
        return null;
    }

    public String[] getPathVariableNames() {
        HashMap map;
        LinkedList<String> result = new LinkedList<String>();
        try {
            map = ((ProjectDescription)this.project.getDescription()).getVariables();
        }
        catch (CoreException coreException) {
            return new String[0];
        }
        int i = 0;
        while (i < this.variableProviders.length) {
            result.add(this.variableProviders[i].getName());
            ++i;
        }
        if (map != null) {
            result.addAll(map.keySet());
        }
        result.addAll(Arrays.asList(this.getWorkspaceManager().getPathVariableNames()));
        return result.toArray(new String[0]);
    }

    public IPath getValue(String varName) {
        URI uri = this.getValue(varName, this.project);
        if (uri != null) {
            return URIUtil.toPath((URI)uri);
        }
        return null;
    }

    public URI getValue(String varName, IResource resource) {
        String value = this.internalGetValue(varName, resource);
        if (value != null) {
            URI resolved;
            int index;
            if (value.indexOf("..") != -1 && (index = value.indexOf(47)) > 0 && (resolved = this.resolveVariable(value, resource)) != null) {
                return resolved;
            }
            return URI.create(value);
        }
        return this.getWorkspaceManager().getValue(varName, resource);
    }

    public String internalGetValue(String varName, IResource resource) {
        HashMap map;
        try {
            map = ((ProjectDescription)this.project.getDescription()).getVariables();
        }
        catch (CoreException coreException) {
            return null;
        }
        if (map != null && map.containsKey(varName)) {
            return ((VariableDescription)map.get(varName)).getValue();
        }
        int index = varName.indexOf(45);
        String name = index != -1 ? varName.substring(0, index) : varName;
        int i = 0;
        while (i < this.variableProviders.length) {
            if (this.variableProviders[i].getName().equals(name)) {
                return this.variableProviders[i].getValue(varName, resource);
            }
            ++i;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDefined(String varName) {
        int i = 0;
        while (i < this.variableProviders.length) {
            if (this.variableProviders[i].getName().equals(varName)) {
                return true;
            }
            ++i;
        }
        try {
            String name;
            HashMap map = ((ProjectDescription)this.project.getDescription()).getVariables();
            if (map == null) return this.getWorkspaceManager().isDefined(varName);
            Iterator it = map.keySet().iterator();
            do {
                if (it.hasNext()) continue;
                return this.getWorkspaceManager().isDefined(varName);
            } while (!(name = (String)it.next()).equals(varName));
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public IPath resolvePath(IPath path) {
        if (path == null || path.segmentCount() == 0 || path.isAbsolute() || path.getDevice() != null) {
            return path;
        }
        URI value = this.resolveURI(URIUtil.toURI((IPath)path));
        return value == null ? path : URIUtil.toPath((URI)value);
    }

    public IPath resolveVariable(String variable) {
        URI uri = this.resolveVariable(variable, this.project);
        if (uri != null) {
            return URIUtil.toPath((URI)uri);
        }
        return null;
    }

    public URI resolveVariable(String variable, IResource resource) {
        LinkedList variableStack = new LinkedList();
        String value = this.resolveVariable(variable, resource, variableStack);
        if (value != null) {
            try {
                return URI.create(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return URIUtil.toURI((IPath)Path.fromPortableString((String)value));
            }
        }
        return null;
    }

    public String resolveVariable(String value, IResource resource, LinkedList variableStack) {
        String tmp;
        if (variableStack == null) {
            variableStack = new LinkedList<String>();
        }
        if ((tmp = this.internalGetValue(value, resource)) == null) {
            URI result = this.getWorkspaceManager().getValue(value, resource);
            if (result != null) {
                return result.toASCIIString();
            }
        } else {
            value = tmp;
        }
        while (true) {
            String stringValue;
            try {
                IPath path;
                URI uri = URI.create(value);
                stringValue = uri != null ? ((path = URIUtil.toPath((URI)uri)) != null ? path.toPortableString() : value) : value;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                stringValue = value;
            }
            int index = stringValue.indexOf("${");
            if (index == -1) break;
            int endIndex = PathVariableUtil.getMatchingBrace(stringValue, index);
            String macro = stringValue.substring(index + 2, endIndex);
            String resolvedMacro = "";
            if (!variableStack.contains(macro)) {
                variableStack.add(macro);
                resolvedMacro = this.resolveVariable(macro, resource, variableStack);
                if (resolvedMacro == null) {
                    resolvedMacro = "";
                }
            }
            stringValue = stringValue.length() > endIndex ? String.valueOf(stringValue.substring(0, index)) + resolvedMacro + stringValue.substring(endIndex + 1) : resolvedMacro;
            value = stringValue;
        }
        return value;
    }

    public URI resolveURI(URI uri) {
        return this.resolveURI(uri, this.project);
    }

    public URI resolveURI(URI uri, IResource resource) {
        if (resource == null) {
            resource = this.project;
        }
        if (uri == null || uri.isAbsolute() || uri.getSchemeSpecificPart() == null) {
            return uri;
        }
        Path raw = new Path(uri.getSchemeSpecificPart());
        if (raw == null || raw.segmentCount() == 0 || raw.isAbsolute() || raw.getDevice() != null) {
            return URIUtil.toURI((IPath)raw);
        }
        URI value = this.resolveVariable(raw.segment(0), resource);
        if (value == null) {
            return uri;
        }
        String path = value.getPath();
        if (path != null) {
            IPath p = Path.fromPortableString((String)path);
            p = p.append(raw.removeFirstSegments(1));
            try {
                value = new URI(value.getScheme(), value.getHost(), p.toPortableString(), value.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                return uri;
            }
            return value;
        }
        return uri;
    }

    public void setValue(String varName, IPath newValue) throws CoreException {
        if (newValue == null) {
            this.setValue(varName, this.project, null);
        } else {
            this.setValue(varName, this.project, URIUtil.toURI((IPath)newValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String varName, IResource resource, URI newValue) throws CoreException {
        this.checkIsValidName(varName);
        this.checkIsValidValue(newValue);
        boolean changeWorkspaceValue = false;
        int eventType = 0;
        ProjectPathVariableManager projectPathVariableManager = this;
        synchronized (projectPathVariableManager) {
            boolean variableExists;
            String value = this.internalGetValue(varName, resource);
            URI currentValue = null;
            currentValue = value == null ? this.getWorkspaceManager().getValue(varName, resource) : URI.create(value);
            boolean bl = variableExists = currentValue != null;
            if (!variableExists && newValue == null) {
                return;
            }
            if (variableExists && currentValue.equals(newValue)) {
                return;
            }
            int i = 0;
            while (i < this.variableProviders.length) {
                if (this.variableProviders[i].getName().equals(varName)) {
                    return;
                }
                ++i;
            }
            if (value == null && variableExists) {
                changeWorkspaceValue = true;
            } else {
                NullProgressMonitor monitor = new NullProgressMonitor();
                Project rule = this.project;
                try {
                    this.project.workspace.prepareOperation(rule, (IProgressMonitor)monitor);
                    this.project.workspace.beginOperation(true);
                    ProjectDescription description = this.project.internalGetDescription();
                    if (newValue == null) {
                        description.setVariableDescription(varName, null);
                        eventType = 3;
                    } else {
                        description.setVariableDescription(varName, new VariableDescription(varName, newValue.toASCIIString()));
                        eventType = variableExists ? 1 : 2;
                    }
                    this.project.writeDescription(0);
                }
                finally {
                    this.project.workspace.endOperation(rule, true, Policy.subMonitorFor((IProgressMonitor)monitor, Policy.endOpWork));
                }
            }
        }
        if (changeWorkspaceValue) {
            this.getWorkspaceManager().setValue(varName, resource, newValue);
        } else {
            this.getWorkspaceManager().fireVariableChangeEvent(this.project, varName, newValue != null ? URIUtil.toPath((URI)newValue) : null, eventType);
        }
    }

    public void shutdown(IProgressMonitor monitor) {
    }

    public void startup(IProgressMonitor monitor) {
    }

    public IStatus validateName(String name) {
        String message = null;
        if (name.length() == 0) {
            message = Messages.pathvar_length;
            return new ResourceStatus(77, null, message);
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            message = NLS.bind((String)Messages.pathvar_beginLetter, (Object)String.valueOf(first));
            return new ResourceStatus(77, null, message);
        }
        int i = 1;
        while (i < name.length()) {
            char following = name.charAt(i);
            if (Character.isWhitespace(following)) {
                return new ResourceStatus(77, null, Messages.pathvar_whitespace);
            }
            if (!Character.isLetter(following) && !Character.isDigit(following) && following != '_') {
                message = NLS.bind((String)Messages.pathvar_invalidChar, (Object)String.valueOf(following));
                return new ResourceStatus(77, null, message);
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateValue(IPath value) {
        return Status.OK_STATUS;
    }

    public IStatus validateValue(URI value) {
        return Status.OK_STATUS;
    }

    public URI convertToRelative(URI path, IResource resource, boolean force, String variableHint) throws CoreException {
        return PathVariableUtil.convertToRelative((IPathVariableManager)this, path, resource, force, variableHint);
    }

    public String convertToUserEditableFormat(String value) {
        return PathVariableUtil.convertToUserEditableFormatInternal(value);
    }

    public String convertFromUserEditableFormat(String userFormat, IResource resource) {
        return PathVariableUtil.convertFromUserEditableFormatInternal(this, userFormat, resource);
    }

    public void addChangeListener(IPathVariableChangeListener listener) {
        this.getWorkspaceManager().addChangeListener(listener, this.project);
    }

    public void removeChangeListener(IPathVariableChangeListener listener) {
        this.getWorkspaceManager().removeChangeListener(listener, this.project);
    }

    public String[] getPathVariableNames(IResource resource) {
        return this.getPathVariableNames();
    }

    public boolean isDefined(String name, IResource resource) {
        return this.isDefined(name);
    }

    public URI getVariableRelativePathLocation(URI location, IResource resource) {
        try {
            URI result = this.convertToRelative(location, resource, false, null);
            if (!result.equals(location)) {
                return result;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }
}

