/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.query.QueryUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentHelper {
    private static final IInstallableUnitFragment[] NO_FRAGMENTS = new IInstallableUnitFragment[0];

    /*
     * WARNING - void declaration
     */
    public static Collection<IInstallableUnit> attachFragments(Iterator<IInstallableUnit> toAttach, Map<IInstallableUnitFragment, List<IInstallableUnit>> fragmentsToIUs) {
        IInstallableUnitFragment fragment;
        HashMap<IInstallableUnit, void> fragmentBindings = new HashMap<IInstallableUnit, void>();
        HashMap<IInstallableUnit, ArrayList<IInstallableUnitFragment>> iusToFragment = new HashMap<IInstallableUnit, ArrayList<IInstallableUnitFragment>>(fragmentsToIUs.size());
        for (Map.Entry<IInstallableUnitFragment, List<IInstallableUnit>> entry : fragmentsToIUs.entrySet()) {
            fragment = entry.getKey();
            List<IInstallableUnit> existingMatches = entry.getValue();
            for (IInstallableUnit host : existingMatches) {
                ArrayList<IInstallableUnitFragment> potentialFragments = (ArrayList<IInstallableUnitFragment>)iusToFragment.get(host);
                if (potentialFragments == null) {
                    potentialFragments = new ArrayList<IInstallableUnitFragment>();
                    iusToFragment.put(host, potentialFragments);
                }
                potentialFragments.add(fragment);
            }
        }
        for (Map.Entry<Object, List<Object>> entry : iusToFragment.entrySet()) {
            void var9_17;
            IInstallableUnit hostIU = (IInstallableUnit)entry.getKey();
            List<Object> potentialIUFragments = entry.getValue();
            ArrayList<IInstallableUnitFragment> applicableFragments = new ArrayList<IInstallableUnitFragment>();
            for (IInstallableUnitFragment iInstallableUnitFragment : potentialIUFragments) {
                if (hostIU.equals((Object)iInstallableUnitFragment)) continue;
                IRequirement[] reqsFromFragment = iInstallableUnitFragment.getHost();
                boolean match = true;
                boolean requirementMatched = false;
                int l = 0;
                while (l < reqsFromFragment.length && match) {
                    requirementMatched = false;
                    if (hostIU.satisfies(reqsFromFragment[l])) {
                        requirementMatched = true;
                    }
                    if (!requirementMatched) {
                        match = false;
                        break;
                    }
                    ++l;
                }
                if (!match) continue;
                applicableFragments.add(iInstallableUnitFragment);
            }
            Object var9_16 = null;
            int specificityLevel = 0;
            for (IInstallableUnitFragment fragment2 : applicableFragments) {
                if (fragment2.getHost().length <= specificityLevel) continue;
                IInstallableUnitFragment iInstallableUnitFragment = fragment2;
                specificityLevel = fragment2.getHost().length;
            }
            if (var9_17 == null) continue;
            fragmentBindings.put(hostIU, var9_17);
        }
        HashSet<IInstallableUnit> hashSet = new HashSet<IInstallableUnit>();
        while (toAttach.hasNext()) {
            IInstallableUnit iu = toAttach.next();
            if (iu == null) continue;
            if (QueryUtil.isFragment((IInstallableUnit)iu)) {
                hashSet.add(iu);
                continue;
            }
            fragment = (IInstallableUnitFragment)fragmentBindings.get(iu);
            IInstallableUnitFragment[] fragments = fragment == null ? NO_FRAGMENTS : new IInstallableUnitFragment[]{fragment};
            hashSet.add(MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)iu, (IInstallableUnitFragment[])fragments));
        }
        return hashSet;
    }
}

