/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.IUMap;
import org.eclipse.equinox.internal.p2.metadata.TranslationSupport;
import org.eclipse.equinox.internal.p2.metadata.index.CapabilityIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IdIndex;
import org.eclipse.equinox.internal.p2.metadata.index.IndexProvider;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryIO;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.KeyWithLocale;
import org.eclipse.equinox.p2.metadata.index.IIndex;
import org.eclipse.equinox.p2.metadata.index.IIndexProvider;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalMetadataRepository
extends AbstractMetadataRepository
implements IIndexProvider<IInstallableUnit> {
    private static final String CONTENT_FILENAME = "content";
    private static final String REPOSITORY_TYPE;
    private static final Integer REPOSITORY_VERSION;
    private static final String JAR_EXTENSION = ".jar";
    private static final String XML_EXTENSION = ".xml";
    protected IUMap units = new IUMap();
    protected HashSet<RepositoryReference> repositories = new HashSet();
    private IIndex<IInstallableUnit> idIndex;
    private IIndex<IInstallableUnit> capabilityIndex;
    private TranslationSupport translationSupport;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    private static File getActualLocation(URI location, String extension) {
        File spec = URIUtil.toFile((URI)location);
        String path = spec.getAbsolutePath();
        if (path.endsWith(new StringBuffer(CONTENT_FILENAME).append(extension).toString())) {
            return spec;
        }
        path = path.endsWith("/") ? new StringBuffer(String.valueOf(path)).append(CONTENT_FILENAME).toString() : new StringBuffer(String.valueOf(path)).append("/content").toString();
        return new File(new StringBuffer(String.valueOf(path)).append(extension).toString());
    }

    public static File getActualLocation(URI location) {
        return LocalMetadataRepository.getActualLocation(location, XML_EXTENSION);
    }

    public LocalMetadataRepository(IProvisioningAgent agent) {
        super(agent);
    }

    public LocalMetadataRepository(IProvisioningAgent agent, URI location, String name, Map<String, String> properties) {
        super(agent, name == null ? (location != null ? location.toString() : "") : name, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        if (!location.getScheme().equals("file")) {
            throw new IllegalArgumentException(new StringBuffer("Invalid local repository location: ").append(location).toString());
        }
        this.save();
    }

    public synchronized void addInstallableUnits(IInstallableUnit[] installableUnits) {
        this.addInstallableUnits(Arrays.asList(installableUnits));
    }

    public synchronized void addInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        if (installableUnits == null || installableUnits.isEmpty()) {
            return;
        }
        this.units.addAll(installableUnits);
        this.capabilityIndex = null;
        this.save();
    }

    public synchronized void addReference(URI repositoryLocation, String nickname, int repositoryType, int options) {
        this.assertModifiable();
        this.repositories.add(new RepositoryReference(repositoryLocation, nickname, repositoryType, options));
    }

    public synchronized IIndex<IInstallableUnit> getIndex(String memberName) {
        if ("id".equals(memberName)) {
            if (this.idIndex == null) {
                this.idIndex = new IdIndex(this.units);
            }
            return this.idIndex;
        }
        if ("providedCapabilities".equals(memberName)) {
            if (this.capabilityIndex == null) {
                this.capabilityIndex = new CapabilityIndex(this.units.iterator());
            }
            return this.capabilityIndex;
        }
        return null;
    }

    public synchronized Object getManagedProperty(Object client, String memberName, Object key) {
        if (!(client instanceof IInstallableUnit)) {
            return null;
        }
        IInstallableUnit iu = (IInstallableUnit)client;
        if ("translatedProperties".equals(memberName)) {
            if (this.translationSupport == null) {
                this.translationSupport = new TranslationSupport((IQueryable)this);
            }
            return key instanceof KeyWithLocale ? this.translationSupport.getIUProperty(iu, (KeyWithLocale)key) : this.translationSupport.getIUProperty(iu, key.toString());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(AbstractMetadataRepository.RepositoryState state) {
        LocalMetadataRepository localMetadataRepository = this;
        synchronized (localMetadataRepository) {
            this.name = state.Name;
            this.type = state.Type;
            this.version = state.Version.toString();
            this.provider = state.Provider;
            this.description = state.Description;
            this.location = state.Location;
            this.properties = state.Properties;
            this.units.addAll(state.Units);
            this.repositories.addAll(Arrays.asList(state.Repositories));
        }
        this.publishRepositoryReferences();
    }

    public void publishRepositoryReferences() {
        IProvisioningEventBus bus = (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.SERVICE_NAME);
        if (bus == null) {
            return;
        }
        List<RepositoryReference> repositoriesSnapshot = this.createRepositoriesSnapshot();
        for (RepositoryReference reference : repositoriesSnapshot) {
            boolean isEnabled = (reference.Options & 1) != 0;
            bus.publishEvent((EventObject)new RepositoryEvent(reference.Location, reference.Type, 4, isEnabled));
        }
    }

    private synchronized List<RepositoryReference> createRepositoriesSnapshot() {
        if (this.repositories.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        return new ArrayList<RepositoryReference>(this.repositories);
    }

    public synchronized void initializeAfterLoad(URI aLocation) {
        this.location = aLocation;
    }

    public boolean isModifiable() {
        return true;
    }

    public synchronized IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        return IndexProvider.query((IIndexProvider)this, query, (IProgressMonitor)monitor);
    }

    public Iterator<IInstallableUnit> everything() {
        return this.units.iterator();
    }

    public synchronized void removeAll() {
        this.units.clear();
        this.capabilityIndex = null;
        this.save();
    }

    public synchronized boolean removeInstallableUnits(IInstallableUnit[] installableUnits, IProgressMonitor monitor) {
        return this.removeInstallableUnits(Arrays.asList(installableUnits));
    }

    public synchronized boolean removeInstallableUnits(Collection<IInstallableUnit> installableUnits) {
        boolean changed = false;
        if (installableUnits != null && !installableUnits.isEmpty()) {
            changed = true;
            this.units.removeAll(installableUnits);
            this.capabilityIndex = null;
        }
        if (changed) {
            this.save();
        }
        return changed;
    }

    private void save() {
        File file = LocalMetadataRepository.getActualLocation(this.location);
        File jarFile = LocalMetadataRepository.getActualLocation(this.location, JAR_EXTENSION);
        boolean compress = "true".equalsIgnoreCase((String)this.properties.get("p2.compressed"));
        try {
            OutputStream output = null;
            if (!compress) {
                if (jarFile.exists()) {
                    jarFile.delete();
                }
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                output = new FileOutputStream(file);
            } else {
                if (file.exists()) {
                    file.delete();
                }
                if (!jarFile.exists()) {
                    if (!jarFile.getParentFile().exists()) {
                        jarFile.getParentFile().mkdirs();
                    }
                    jarFile.createNewFile();
                }
                JarEntry jarEntry = new JarEntry(file.getName());
                JarOutputStream jOutput = new JarOutputStream(new FileOutputStream(jarFile));
                jOutput.putNextEntry(jarEntry);
                output = jOutput;
            }
            super.setProperty("p2.timestamp", Long.toString(System.currentTimeMillis()));
            new MetadataRepositoryIO(this.agent).write((IMetadataRepository)this, output);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1003, new StringBuffer("Error saving metadata repository: ").append(this.location).toString(), (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setProperty(String key, String newValue) {
        String oldValue = null;
        LocalMetadataRepository localMetadataRepository = this;
        synchronized (localMetadataRepository) {
            oldValue = super.setProperty(key, newValue);
            if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
                return oldValue;
            }
            this.save();
        }
        MetadataRepositoryManager manager = (MetadataRepositoryManager)((Object)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME));
        if (manager.removeRepository(this.getLocation())) {
            manager.addRepository((IMetadataRepository)this);
        }
        return oldValue;
    }
}

