/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.garbagecollector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;

public class CoreGarbageCollector {
    static boolean debugMode = false;

    public synchronized void clean(IArtifactKey[] markSet, final IArtifactRepository aRepository) {
        Class<?> clazz;
        HashSet<IArtifactKey> set = new HashSet<IArtifactKey>(Arrays.asList(markSet));
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IArtifactKey");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IQuery query = QueryUtil.createQuery(clazz, (String)"unique($0)", (Object[])new Object[]{set});
        final IQueryResult inactive = aRepository.query(query, null);
        aRepository.executeBatch(new Runnable(){

            public void run() {
                Iterator iterator = inactive.iterator();
                while (iterator.hasNext()) {
                    IArtifactKey key = (IArtifactKey)iterator.next();
                    aRepository.removeDescriptor(key);
                    if (!debugMode) continue;
                    Tracing.debug((String)("Key removed:" + key));
                }
            }
        });
    }

    public static void setDebugMode(boolean inDebugMode) {
        debugMode = inDebugMode;
    }
}

