/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.repository.spi;

import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.IRepository;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepository<T>
extends PlatformObject
implements IRepository<T> {
    protected final IProvisioningAgent agent;
    protected String description;
    protected transient URI location;
    protected String name;
    protected Map<String, String> properties = new OrderedProperties();
    protected String provider;
    protected String type;
    protected String version;

    protected AbstractRepository(IProvisioningAgent agent, String name, String type, String version, URI location, String description, String provider, Map<String, String> properties) {
        this.agent = agent;
        this.name = name;
        this.type = type;
        this.version = version;
        this.location = location;
        this.description = description == null ? "" : description;
        String string = this.provider = provider == null ? "" : provider;
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    protected void assertModifiable() {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException(new StringBuffer("Repository not modifiable: ").append(this.location).toString());
        }
    }

    @Override
    public synchronized String getDescription() {
        return this.description;
    }

    @Override
    public synchronized URI getLocation() {
        return this.location;
    }

    @Override
    public synchronized String getName() {
        return this.name;
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        return OrderedProperties.unmodifiableProperties(this.properties);
    }

    @Override
    public synchronized String getProvider() {
        return this.provider;
    }

    @Override
    public IProvisioningAgent getProvisioningAgent() {
        return this.agent;
    }

    @Override
    public synchronized String getType() {
        return this.type;
    }

    @Override
    public synchronized String getVersion() {
        return this.version;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public synchronized void setDescription(String description) {
        this.description = description;
    }

    @Override
    public synchronized void setName(String value) {
        this.name = value;
    }

    @Override
    public synchronized String setProperty(String key, String value) {
        this.assertModifiable();
        return value == null ? this.properties.remove(key) : this.properties.put(key, value);
    }

    @Override
    public synchronized void setProvider(String provider) {
        this.provider = provider;
    }
}

