/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.console;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.console.Activator;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvisioningHelper {
    public static IMetadataRepository addMetadataRepository(IProvisioningAgent agent, URI location) {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = new StringBuffer().append(location).append(" - metadata").toString();
            try {
                return manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
            }
            catch (ProvisionException provisionException2) {
                return null;
            }
        }
    }

    public static IMetadataRepository getMetadataRepository(IProvisioningAgent agent, URI location) {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            return null;
        }
    }

    public static void removeMetadataRepository(IProvisioningAgent agent, URI location) {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new IllegalStateException("No metadata repository manager found");
        }
        manager.removeRepository(location);
    }

    public static IArtifactRepository addArtifactRepository(IProvisioningAgent agent, URI location) {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            return null;
        }
        try {
            return manager.loadRepository(location, null);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = new StringBuffer().append(location).append(" - artifacts").toString();
            try {
                return manager.createRepository(location, repositoryName, "org.eclipse.equinox.p2.artifact.repository.simpleRepository", null);
            }
            catch (ProvisionException provisionException2) {
                return null;
            }
        }
    }

    public static void removeArtifactRepository(IProvisioningAgent agent, URI location) {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            return;
        }
        manager.removeRepository(location);
    }

    public static IProfile addProfile(IProvisioningAgent agent, String profileId, Map<String, String> properties) throws ProvisionException {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            return null;
        }
        IProfile profile = profileRegistry.getProfile(profileId);
        if (profile != null) {
            return profile;
        }
        HashMap<String, String> profileProperties = new HashMap<String, String>(properties);
        if (profileProperties.get("org.eclipse.equinox.p2.environments") == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.osgi.service.environment.EnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName());
            if (info != null) {
                profileProperties.put("org.eclipse.equinox.p2.environments", new StringBuffer("osgi.os=").append(info.getOS()).append(",osgi.ws=").append(info.getWS()).append(",osgi.arch=").append(info.getOSArch()).toString());
            } else {
                profileProperties.put("org.eclipse.equinox.p2.environments", "");
            }
        }
        return profileRegistry.addProfile(profileId, profileProperties);
    }

    public static void removeProfile(IProvisioningAgent agent, String profileId) {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            return;
        }
        profileRegistry.removeProfile(profileId);
    }

    public static IProfile[] getProfiles(IProvisioningAgent agent) {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            return new IProfile[0];
        }
        return profileRegistry.getProfiles();
    }

    public static IProfile getProfile(IProvisioningAgent agent, String id) {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            return null;
        }
        return profileRegistry.getProfile(id);
    }

    public static IQueryResult<IInstallableUnit> getInstallableUnits(IProvisioningAgent agent, URI location, IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        Object queryable = null;
        queryable = location == null ? (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME) : ProvisioningHelper.getMetadataRepository(agent, location);
        if (queryable != null) {
            return queryable.query(query, monitor);
        }
        return Collector.emptyCollector();
    }

    public static URI[] getMetadataRepositories(IProvisioningAgent agent) {
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            return null;
        }
        URI[] repos = manager.getKnownRepositories(0);
        if (repos.length > 0) {
            return repos;
        }
        return null;
    }

    public static IStatus install(IProvisioningAgent agent, String unitId, String version, IProfile profile, IProgressMonitor progress) throws ProvisionException {
        if (profile == null) {
            return null;
        }
        IQueryResult<IInstallableUnit> units = ProvisioningHelper.getInstallableUnits(agent, null, (IQuery<IInstallableUnit>)QueryUtil.createIUQuery((String)unitId, (Version)Version.create((String)version)), progress);
        if (units.isEmpty()) {
            StringBuffer error = new StringBuffer();
            error.append(new StringBuffer("Installable unit not found: ").append(unitId).append(' ').append(version).append('\n').toString());
            error.append("Repositories searched:\n");
            URI[] repos = ProvisioningHelper.getMetadataRepositories(agent);
            if (repos != null) {
                int i = 0;
                while (i < repos.length) {
                    error.append(new StringBuffer().append(repos[i]).append("\n").toString());
                    ++i;
                }
            }
            throw new ProvisionException(error.toString());
        }
        IPlanner planner = (IPlanner)agent.getService(IPlanner.SERVICE_NAME);
        if (planner == null) {
            throw new ProvisionException("No planner service found.");
        }
        IEngine engine = (IEngine)agent.getService(IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new ProvisionException("No director service found.");
        }
        ProvisioningContext context = new ProvisioningContext();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addAll((Collection)units.toUnmodifiableSet());
        IProvisioningPlan result = planner.getProvisioningPlan((IProfileChangeRequest)request, context, progress);
        return PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)engine, (ProvisioningContext)context, (IProgressMonitor)progress);
    }

    public static URI[] getArtifactRepositories(IProvisioningAgent agent) {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            return null;
        }
        URI[] repos = manager.getKnownRepositories(0);
        if (repos.length > 0) {
            return repos;
        }
        return null;
    }

    public static IArtifactRepository getArtifactRepository(IProvisioningAgent agent, URI repoURL) {
        IArtifactRepositoryManager manager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        try {
            if (manager != null) {
                return manager.loadRepository(repoURL, null);
            }
        }
        catch (ProvisionException provisionException) {}
        return null;
    }

    public static long[] getProfileTimestamps(IProvisioningAgent agent, String profileId) {
        IProfileRegistry profileRegistry;
        if (profileId == null) {
            profileId = "_SELF_";
        }
        if ((profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME)) == null) {
            return null;
        }
        return profileRegistry.listProfileTimestamps(profileId);
    }

    public static IStatus revertToPreviousState(IProvisioningAgent agent, IProfile profile, long revertToPreviousState) throws ProvisionException {
        IEngine engine = (IEngine)agent.getService(IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new ProvisionException("No p2 engine found.");
        }
        IPlanner planner = (IPlanner)agent.getService(IPlanner.SERVICE_NAME);
        if (planner == null) {
            throw new ProvisionException("No planner found.");
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            throw new ProvisionException("profile registry cannot be null");
        }
        if (profile == null) {
            profile = ProvisioningHelper.getProfile(agent, "_SELF_");
        }
        IProfile targetProfile = null;
        if (revertToPreviousState == 0L) {
            long[] profiles = profileRegistry.listProfileTimestamps(profile.getProfileId());
            if (profiles.length == 0) {
                return Status.OK_STATUS;
            }
            targetProfile = profileRegistry.getProfile(profile.getProfileId(), profiles[profiles.length - 1]);
        } else {
            targetProfile = profileRegistry.getProfile(profile.getProfileId(), revertToPreviousState);
        }
        if (targetProfile == null) {
            throw new ProvisionException(new StringBuffer("target profile with timestamp=").append(revertToPreviousState).append(" not found").toString());
        }
        URI[] artifactRepos = ProvisioningHelper.getArtifactRepositories(agent);
        URI[] metadataRepos = ProvisioningHelper.getMetadataRepositories(agent);
        IProvisioningPlan plan = planner.getDiffPlan(profile, targetProfile, (IProgressMonitor)new NullProgressMonitor());
        ProvisioningContext context = new ProvisioningContext(metadataRepos);
        context.setArtifactRepositories(artifactRepos);
        return PlanExecutionHelper.executePlan((IProvisioningPlan)plan, (IEngine)engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus uninstall(IProvisioningAgent agent, String unitId, String version, IProfile profile, IProgressMonitor progress) throws ProvisionException {
        if (profile == null) {
            return null;
        }
        IQueryResult units = profile.query(QueryUtil.createIUQuery((String)unitId, (Version)Version.create((String)version)), progress);
        if (units.isEmpty()) {
            StringBuffer error = new StringBuffer();
            error.append(new StringBuffer("Installable unit not found: ").append(unitId).append(' ').append(version).append('\n').toString());
            error.append("Repositories searched:\n");
            URI[] repos = ProvisioningHelper.getMetadataRepositories(agent);
            if (repos != null) {
                int i = 0;
                while (i < repos.length) {
                    error.append(new StringBuffer().append(repos[i]).append("\n").toString());
                    ++i;
                }
            }
            throw new ProvisionException(error.toString());
        }
        IPlanner planner = (IPlanner)agent.getService(IPlanner.SERVICE_NAME);
        if (planner == null) {
            throw new ProvisionException("No planner service found.");
        }
        IEngine engine = (IEngine)agent.getService(IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new ProvisionException("No engine service found.");
        }
        ProvisioningContext context = new ProvisioningContext();
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.removeAll((Collection)units.toUnmodifiableSet());
        IProvisioningPlan result = planner.getProvisioningPlan((IProfileChangeRequest)request, context, progress);
        return PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)engine, (ProvisioningContext)context, (IProgressMonitor)progress);
    }
}

