/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.query;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.internal.p2.metadata.query.IMatchQuery;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.metadata.index.IIndex;
import org.eclipse.equinox.p2.metadata.index.IIndexProvider;
import org.eclipse.equinox.p2.metadata.index.IQueryWithIndex;
import org.eclipse.equinox.p2.query.CollectionResult;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionMatchQuery<T>
implements IMatchQuery<T>,
IQueryWithIndex<T> {
    private final IMatchExpression<T> expression;
    private final Class<? extends T> matchingClass;
    private IEvaluationContext context;

    public ExpressionMatchQuery(Class<? extends T> matchingClass, IExpression expression, Object[] parameters) {
        this.matchingClass = matchingClass;
        this.expression = ExpressionUtil.getFactory().matchExpression(expression, parameters);
        this.context = this.expression.createContext();
    }

    public ExpressionMatchQuery(Class<? extends T> matchingClass, String expression, Object[] parameters) {
        this(matchingClass, ExpressionUtil.parse(expression), parameters);
    }

    public IEvaluationContext getContext() {
        return this.context;
    }

    public Class<? extends T> getMatchingClass() {
        return this.matchingClass;
    }

    @Override
    public IQueryResult<T> perform(IIndexProvider<T> indexProvider) {
        Class<?> clazz;
        Iterator<T> iterator = null;
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IArtifactKey");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        for (String member : Expression.getIndexCandidateMembers(clazz, ExpressionFactory.THIS, (Expression)((Object)this.expression))) {
            IIndex<T> index = indexProvider.getIndex(member);
            if (index != null && (iterator = index.getCandidates(this.context, ExpressionFactory.THIS, this.expression)) != null) break;
        }
        if (iterator == null) {
            iterator = indexProvider.everything();
        }
        this.context.setIndexProvider(indexProvider);
        return this.perform(iterator);
    }

    @Override
    public IQueryResult<T> perform(Iterator<T> iterator) {
        HashSet<T> result = null;
        while (iterator.hasNext()) {
            T value = iterator.next();
            if (!this.isMatch(value)) continue;
            if (result == null) {
                result = new HashSet<T>();
            }
            result.add(value);
        }
        return result == null ? Collector.emptyCollector() : new CollectionResult(result);
    }

    @Override
    public boolean isMatch(T candidate) {
        if (!this.matchingClass.isInstance(candidate)) {
            return false;
        }
        ExpressionFactory.THIS.setValue(this.context, candidate);
        return Boolean.TRUE == this.expression.evaluate(this.context);
    }

    @Override
    public IMatchExpression<T> getExpression() {
        return this.expression;
    }

    public void setIndexProvider(IIndexProvider<T> indexProvider) {
        this.context.setIndexProvider(indexProvider);
    }

    public void prePerform() {
    }

    public void postPerform() {
    }
}

