/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.CleanupzipAction;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnzipAction
extends ProvisioningAction {
    public static final String ACTION_UNZIP = "unzip";

    public IStatus execute(Map<String, Object> parameters) {
        return UnzipAction.unzip(parameters, true);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return CleanupzipAction.cleanupzip(parameters, false);
    }

    public static IStatus unzip(Map<String, Object> parameters, boolean restoreable) {
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_UNZIP));
        }
        String originalSource = source;
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_UNZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        if (source.equals("@artifact")) {
            String artifactLocation = (String)parameters.get("artifact.location");
            if (artifactLocation == null) {
                IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
                return Util.createError(NLS.bind((String)Messages.artifact_not_available, (Object)artifactKey));
            }
            source = artifactLocation;
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        File[] unzippedFiles = UnzipAction.unzip(source, target, store);
        StringBuffer unzippedFileNameBuffer = new StringBuffer();
        int i = 0;
        while (i < unzippedFiles.length) {
            unzippedFileNameBuffer.append(unzippedFiles[i].getAbsolutePath()).append("|");
            ++i;
        }
        profile.setInstallableUnitProperty(iu, new StringBuffer("unzipped|").append(originalSource).append("|").append(target).toString(), unzippedFileNameBuffer.toString());
        return Status.OK_STATUS;
    }

    private static File[] unzip(String source, String destination, IBackupStore store) {
        File zipFile = new File(source);
        if (!zipFile.exists()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Util.log(new StringBuffer(String.valueOf(clazz.getName())).append(" the files to be unzipped is not here").toString());
        }
        try {
            String taskName = NLS.bind((String)Messages.unzipping, (Object)source);
            return Util.unzipFile(zipFile, new File(destination), store, taskName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Util.log(new StringBuffer(String.valueOf(clazz.getName())).append(" error unzipping zipfile: ").append(zipFile.getAbsolutePath()).append("destination: ").append(destination).toString());
            return new File[0];
        }
    }
}

