/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.IAggregatorConstants;
import org.eclipse.b3.aggregator.InstallableUnitType;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.p2.InstallableUnit;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.VersionedId;

public class InstallableUnitUtils {
    private static final Pattern proxyFragmentPattern = Pattern.compile("^//@metadataRepository/@installableUnits\\[id='([^']*)',version='([^']*)'\\]$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getStatus(InstallableUnit iu) {
        InstallableUnit installableUnit = iu;
        synchronized (installableUnit) {
            return StringUtils.trimmedOrNull((String)iu.getId()) != null ? AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK) : AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN);
        }
    }

    public static InstallableUnitType getType(IInstallableUnit iu) {
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category"))) {
            return InstallableUnitType.CATEGORY;
        }
        if (iu.getId().endsWith(".feature.group")) {
            return InstallableUnitType.FEATURE;
        }
        if ("true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.group"))) {
            return InstallableUnitType.PRODUCT;
        }
        if (InstallableUnitUtils.isOSGiFragment(iu)) {
            return InstallableUnitType.FRAGMENT;
        }
        if (InstallableUnitUtils.isOSGiBundle(iu)) {
            return InstallableUnitType.BUNDLE;
        }
        return InstallableUnitType.OTHER;
    }

    public static VersionedId getVersionedName(InstallableUnit iu) {
        if (((EObject)iu).eIsProxy()) {
            return InstallableUnitUtils.getVersionedNameFromProxy(iu);
        }
        return new VersionedId(iu.getId(), iu.getVersion());
    }

    public static VersionedId getVersionedNameFromProxy(InstallableUnit iu) {
        return InstallableUnitUtils.getVersionedNameFromProxy((InternalEObject)iu);
    }

    public static VersionedId getVersionedNameFromProxy(InternalEObject iu) {
        URI uri = iu.eProxyURI();
        if (uri == null) {
            return null;
        }
        String frag = uri.fragment();
        if (frag == null) {
            return null;
        }
        Matcher m = proxyFragmentPattern.matcher(frag);
        try {
            return m.matches() ? new VersionedId(URLDecoder.decode(m.group(1), "UTF-8"), m.group(2)) : null;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isOSGiBundle(IInstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.equinox.p2.eclipse.type".equals(rc.getNamespace()) || !IAggregatorConstants.CAPABILITY_TYPE_BUNDLE.equals(rc.getName()) && !"source".equals(rc.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isOSGiFragment(IInstallableUnit iu) {
        for (IProvidedCapability rc : iu.getProvidedCapabilities()) {
            if (!"osgi.fragment".equals(rc.getNamespace())) continue;
            return true;
        }
        return false;
    }
}

