/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.ds.InstanceProcess;
import org.eclipse.equinox.internal.ds.model.ServiceComponentProp;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentInstance;

public class ComponentInstanceImpl
implements ComponentInstance {
    private Object instance;
    private ServiceComponentProp scp;
    private ComponentContext componentContext;
    public Hashtable bindedServices = new Hashtable(11);

    public ComponentInstanceImpl(Object instance, ServiceComponentProp scp) {
        this.instance = instance;
        this.scp = scp;
    }

    public void dispose() {
        if (this.scp == null) {
            return;
        }
        if (Activator.DEBUG) {
            Activator.log.debug("ComponentInstanceImpl.dispose(): disposing instance of component " + this.scp.name, null);
        }
        if (!this.scp.isComponentFactory() && this.scp.serviceComponent.factory != null) {
            this.scp.serviceComponent.componentProps.removeElement(this.scp);
            Vector<ServiceComponentProp> toDispose = new Vector<ServiceComponentProp>(1);
            toDispose.addElement(this.scp);
            InstanceProcess.resolver.disposeComponentConfigs(toDispose, 5);
            if (this.scp != null) {
                this.scp.setState(256);
                this.scp = null;
            }
        } else {
            this.scp.dispose(this, 5);
        }
        this.freeServiceReferences();
        this.componentContext = null;
        this.instance = null;
    }

    public void freeServiceReferences() {
        if (!this.bindedServices.isEmpty()) {
            Enumeration keys = this.bindedServices.keys();
            while (keys.hasMoreElements()) {
                ServiceReference reference = (ServiceReference)keys.nextElement();
                this.bindedServices.remove(reference);
                this.scp.bc.ungetService(reference);
            }
        }
    }

    public Object getInstance() {
        return this.instance;
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public void setComponentContext(ComponentContext componentContext) {
        this.componentContext = componentContext;
    }
}

