/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.DebugHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvisioningContext {
    private IProvisioningAgent agent;
    private Collection<IRequirement> additionalRequirements;
    private URI[] artifactRepositories;
    private final List<IInstallableUnit> extraIUs = Collections.synchronizedList(new ArrayList());
    private URI[] metadataRepositories;
    private final Map<String, String> properties = new HashMap<String, String>();
    private static final String FILE_PROTOCOL = "file";
    private static final Comparator<URI> LOCAL_FIRST_COMPARATOR = new Comparator<URI>(){

        @Override
        public int compare(URI arg0, URI arg1) {
            String protocol0 = arg0.getScheme();
            String protocol1 = arg1.getScheme();
            if (ProvisioningContext.FILE_PROTOCOL.equals(protocol0) && !ProvisioningContext.FILE_PROTOCOL.equals(protocol1)) {
                return -1;
            }
            if (!ProvisioningContext.FILE_PROTOCOL.equals(protocol0) && ProvisioningContext.FILE_PROTOCOL.equals(protocol1)) {
                return 1;
            }
            return 0;
        }
    };
    public static final String FOLLOW_REPOSITORY_REFERENCES = "org.eclipse.equinox.p2.director.followRepositoryReferences";

    public ProvisioningContext(IProvisioningAgent agent) {
        this.agent = agent;
        this.metadataRepositories = null;
        this.artifactRepositories = null;
    }

    public Collection<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }

    public IQueryable<IArtifactKey> getArtifactKeys(IProgressMonitor monitor) {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.getArtifactRepositories();
        ArrayList<IArtifactRepository> repos = new ArrayList<IArtifactRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100));
        try {
            int i = 0;
            while (i < repositories.length) {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                repos.add(repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100)));
                ++i;
            }
        }
        catch (ProvisionException provisionException) {}
        return QueryUtil.compoundQueryable(repos);
    }

    public IQueryable<IArtifactDescriptor> getArtifactDescriptors(IProgressMonitor monitor) {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.getArtifactRepositories();
        ArrayList<IQueryable> descriptorQueryables = new ArrayList<IQueryable>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100));
        try {
            int i = 0;
            while (i < repositories.length) {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IArtifactRepository repo = repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                descriptorQueryables.add(repo.descriptorQueryable());
                ++i;
            }
        }
        catch (ProvisionException provisionException) {}
        return QueryUtil.compoundQueryable(descriptorQueryables);
    }

    public IQueryable<IArtifactRepository> getArtifactRepositories(IProgressMonitor monitor) {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.getArtifactRepositories();
        final ArrayList<IArtifactRepository> repos = new ArrayList<IArtifactRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100));
        try {
            int i = 0;
            while (i < repositories.length) {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                repos.add(repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100)));
                ++i;
            }
        }
        catch (ProvisionException provisionException) {}
        return new IQueryable<IArtifactRepository>(){

            public IQueryResult<IArtifactRepository> query(IQuery<IArtifactRepository> query, IProgressMonitor mon) {
                return query.perform(repos.iterator());
            }
        };
    }

    public IQueryable<IInstallableUnit> getMetadata(IProgressMonitor monitor) {
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.metadataRepositories == null ? repoManager.getKnownRepositories(0) : this.metadataRepositories;
        ArrayList<IMetadataRepository> repos = new ArrayList<IMetadataRepository>();
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 100));
        try {
            int i = 0;
            while (i < repositories.length) {
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
                repos.add(repoManager.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100)));
                ++i;
            }
        }
        catch (ProvisionException provisionException) {}
        return QueryUtil.compoundQueryable(repos);
    }

    public List<IInstallableUnit> getExtraInstallableUnits() {
        return this.extraIUs;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setAdditionalRequirements(Collection<IRequirement> requirements) {
        this.additionalRequirements = requirements;
    }

    public void setArtifactRepositories(URI[] artifactRepositories) {
        this.artifactRepositories = artifactRepositories;
    }

    public void setMetadataRepositories(URI[] metadataRepositories) {
        this.metadataRepositories = metadataRepositories;
    }

    public void setExtraInstallableUnits(List<IInstallableUnit> extraIUs) {
        this.extraIUs.clear();
        if (extraIUs != null) {
            this.extraIUs.addAll(extraIUs);
        }
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(new StringBuffer("{artifactRepos=").append(DebugHelper.formatArray(Arrays.asList(this.artifactRepositories), true, false)).toString());
        buffer.append(new StringBuffer(", metadataRepos=").append(DebugHelper.formatArray(Arrays.asList(this.metadataRepositories), true, false)).toString());
        buffer.append(new StringBuffer(", properties=").append(this.getProperties()).append("}").toString());
        return buffer.toString();
    }

    public URI[] getArtifactRepositories() {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
        URI[] repositories = this.artifactRepositories == null ? repoManager.getKnownRepositories(0) : this.artifactRepositories;
        Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
        return repositories;
    }
}

