/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.TreeMap;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.AggregatorPlugin;
import org.eclipse.b3.aggregator.AvailableVersion;
import org.eclipse.b3.aggregator.AvailableVersionsHeader;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.DescriptionProvider;
import org.eclipse.b3.aggregator.EnabledStatusProvider;
import org.eclipse.b3.aggregator.InfosProvider;
import org.eclipse.b3.aggregator.InstallableUnitRequest;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.VersionMatch;
import org.eclipse.b3.aggregator.p2.InstallableUnit;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.b3.aggregator.p2.P2Factory;
import org.eclipse.b3.aggregator.p2.P2Package;
import org.eclipse.b3.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.b3.aggregator.util.GeneralUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InstallableUnitRequestImpl
extends MinimalEObjectImpl.Container
implements InstallableUnitRequest {
    protected int eFlags = 0;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected static final String DESCRIPTION_EDEFAULT = "";
    protected String description = "";
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final VersionRange VERSION_RANGE_EDEFAULT = (VersionRange)P2Factory.eINSTANCE.createFromString(P2Package.eINSTANCE.getVersionRange(), "0.0.0");
    protected VersionRange versionRange = VERSION_RANGE_EDEFAULT;
    protected AvailableVersionsHeader availableVersionsHeader;
    protected EList<AvailableVersion> availableVersions;

    private static String getString(String key) {
        return AggregatorPlugin.INSTANCE.getString(key);
    }

    protected InstallableUnitRequestImpl() {
        this.setAvailableVersionsHeader(AggregatorFactory.eINSTANCE.createAvailableVersionsHeader());
    }

    public NotificationChain basicSetAvailableVersionsHeader(AvailableVersionsHeader newAvailableVersionsHeader, NotificationChain msgs) {
        AvailableVersionsHeader oldAvailableVersionsHeader = this.availableVersionsHeader;
        this.availableVersionsHeader = newAvailableVersionsHeader;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldAvailableVersionsHeader, (Object)newAvailableVersionsHeader);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == DescriptionProvider.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == DescriptionProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getStatus();
            }
            case 1: {
                return this.getErrors();
            }
            case 2: {
                return this.getWarnings();
            }
            case 3: {
                return this.getInfos();
            }
            case 4: {
                return this.getDescription();
            }
            case 5: {
                return this.getName();
            }
            case 6: {
                return this.getVersionRange();
            }
            case 7: {
                return this.getAvailableVersionsHeader();
            }
            case 8: {
                return this.getAvailableVersions();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                if (this.availableVersionsHeader != null) {
                    msgs = ((InternalEObject)this.availableVersionsHeader).eInverseRemove((InternalEObject)this, -8, null, msgs);
                }
                return this.basicSetAvailableVersionsHeader((AvailableVersionsHeader)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetAvailableVersionsHeader(null, msgs);
            }
            case 8: {
                return ((InternalEList)this.getAvailableVersions()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.getStatus() != null;
            }
            case 1: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 2: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 3: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 4: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 5: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 6: {
                return VERSION_RANGE_EDEFAULT == null ? this.versionRange != null : !VERSION_RANGE_EDEFAULT.equals((Object)this.versionRange);
            }
            case 7: {
                return this.availableVersionsHeader != null;
            }
            case 8: {
                return this.availableVersions != null && !this.availableVersions.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setDescription((String)newValue);
                return;
            }
            case 5: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setVersionRange((VersionRange)newValue);
                return;
            }
            case 7: {
                this.setAvailableVersionsHeader((AvailableVersionsHeader)newValue);
                return;
            }
            case 8: {
                this.getAvailableVersions().clear();
                this.getAvailableVersions().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getErrors().clear();
                return;
            }
            case 2: {
                this.getWarnings().clear();
                return;
            }
            case 3: {
                this.getInfos().clear();
                return;
            }
            case 4: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 5: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setVersionRange(VERSION_RANGE_EDEFAULT);
                return;
            }
            case 7: {
                this.setAvailableVersionsHeader(null);
                return;
            }
            case 8: {
                this.getAvailableVersions().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<AvailableVersion> getAvailableVersions() {
        if (this.availableVersions == null) {
            this.resolveAvailableVersions(false);
        }
        return this.availableVersions;
    }

    @Override
    public AvailableVersionsHeader getAvailableVersionsHeader() {
        return this.availableVersionsHeader;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EList<String> getErrors() {
        this.errors = new BasicEList();
        if (!this.isMappedRepositoryBroken() && this.resolveAsSingleton() == null) {
            this.errors.add((Object)InstallableUnitRequestImpl.getString("_UI_ErrorMessage_NoInstallableUnitIsAvailable"));
        }
        return this.errors;
    }

    @Override
    public EList<String> getInfos() {
        this.infos = new BasicEList();
        return this.infos;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized Status getStatus() {
        if (!this.isBranchDisabledOrMappedRepositoryBroken() && this.resolveAsSingleton() == null) {
            return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, InstallableUnitRequestImpl.getString("_UI_ErrorMessage_NoInstallableUnitIsAvailable"));
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 2);
        }
        return this.warnings;
    }

    @Override
    public boolean isBranchDisabledOrMappedRepositoryBroken() {
        return !this.isBranchEnabled() || this.isMappedRepositoryBroken();
    }

    @Override
    public boolean isBranchEnabled() {
        if (this instanceof EnabledStatusProvider && !((EnabledStatusProvider)((Object)this)).isEnabled()) {
            return false;
        }
        MappedRepository mappedRepository = (MappedRepository)this.eContainer();
        if (mappedRepository == null) {
            return true;
        }
        if (!mappedRepository.isEnabled()) {
            return false;
        }
        Contribution contribution = (Contribution)((EObject)mappedRepository).eContainer();
        return contribution == null || contribution.isEnabled();
    }

    @Override
    public boolean isMappedRepositoryBroken() {
        MappedRepository repo = (MappedRepository)this.eContainer();
        return repo == null || repo.getMetadataRepository(false) == null || ((EObject)repo.getMetadataRepository()).eIsProxy();
    }

    @Override
    public IInstallableUnit resolveAsSingleton() {
        return this.resolveAsSingleton(false);
    }

    @Override
    public IInstallableUnit resolveAsSingleton(boolean forceResolve) {
        String id = this.getName();
        if (id == null) {
            return null;
        }
        IQuery query = QueryUtil.createIUQuery((String)id, (VersionRange)this.versionRange);
        MetadataRepository mdr = ((MappedRepository)this.eContainer()).getMetadataRepository(forceResolve);
        if (mdr == null || ((EObject)mdr).eIsProxy()) {
            return null;
        }
        IQueryResult ius = mdr.query(QueryUtil.createCompoundQuery((IQuery)query, (IQuery)QueryUtil.createLatestIUQuery(), (boolean)true), (IProgressMonitor)new NullProgressMonitor());
        if (ius.isEmpty()) {
            ius = mdr.query(query, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!ius.isEmpty()) {
            InstallableUnit iu = (InstallableUnit)((IInstallableUnit[])ius.toArray(IInstallableUnit.class))[0];
            return iu;
        }
        return null;
    }

    @Override
    public synchronized void resolveAvailableVersions(boolean updateOnly) {
        if (this.availableVersions == null) {
            if (updateOnly) {
                return;
            }
            this.availableVersions = new EObjectContainmentEList(AvailableVersion.class, (InternalEObject)this, 8);
        } else {
            this.availableVersions.clear();
        }
        TreeMap versionMap = new TreeMap(Collections.reverseOrder());
        IQuery query = QueryUtil.createIUQuery((String)this.name);
        while (true) {
            try {
                versionMap.clear();
                for (Resource resource : GeneralUtils.getAggregatorResource((EObject)this).getResourceSet().getResources()) {
                    if (!(resource instanceof MetadataRepositoryResourceImpl)) continue;
                    MetadataRepository mdr = ((MetadataRepositoryResourceImpl)resource).getMetadataRepository();
                    if (StringUtils.trimmedOrNull((String)this.name) == null || mdr == null || ((EObject)mdr).eIsProxy()) continue;
                    IQueryResult ius = mdr.query(query, null);
                    for (IInstallableUnit iu : ius.toSet()) {
                        versionMap.put(iu.getVersion(), iu.getFilter());
                    }
                }
            }
            catch (ConcurrentModificationException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        if (versionMap.size() == 0) {
            AvailableVersion av = AggregatorFactory.eINSTANCE.createAvailableVersion();
            av.setVersionMatch(VersionMatch.MATCHES);
            this.availableVersions.add((Object)av);
        } else {
            for (Version version : versionMap.keySet()) {
                AvailableVersion av = AggregatorFactory.eINSTANCE.createAvailableVersion();
                if (this.versionRange == null || this.versionRange.isIncluded(version)) {
                    av.setVersionMatch(VersionMatch.MATCHES);
                } else {
                    int result = this.versionRange.getMinimum().compareTo((Object)version);
                    if (result >= 0) {
                        av.setVersionMatch(VersionMatch.BELOW);
                    } else {
                        av.setVersionMatch(VersionMatch.ABOVE);
                    }
                }
                av.setVersion(version);
                av.setFilter((IMatchExpression<IInstallableUnit>)((IMatchExpression)versionMap.get(version)));
                this.availableVersions.add((Object)av);
            }
        }
    }

    @Override
    public void setAvailableVersionsHeader(AvailableVersionsHeader newAvailableVersionsHeader) {
        if (newAvailableVersionsHeader != this.availableVersionsHeader) {
            NotificationChain msgs = null;
            if (this.availableVersionsHeader != null) {
                msgs = ((InternalEObject)this.availableVersionsHeader).eInverseRemove((InternalEObject)this, 1, AvailableVersionsHeader.class, msgs);
            }
            if (newAvailableVersionsHeader != null) {
                msgs = ((InternalEObject)newAvailableVersionsHeader).eInverseAdd((InternalEObject)this, 1, AvailableVersionsHeader.class, msgs);
            }
            if ((msgs = this.basicSetAvailableVersionsHeader(newAvailableVersionsHeader, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newAvailableVersionsHeader, (Object)newAvailableVersionsHeader));
        }
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public void setVersionRange(VersionRange newVersionRange) {
        VersionRange oldVersionRange = this.versionRange;
        this.versionRange = newVersionRange;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldVersionRange, (Object)this.versionRange));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", description: ");
        result.append(this.description);
        result.append(", name: ");
        result.append(this.name);
        result.append(", versionRange: ");
        result.append(this.versionRange);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.INSTALLABLE_UNIT_REQUEST;
    }
}

