/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.impl;

import java.util.Collection;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.AggregatorFactory;
import org.eclipse.b3.aggregator.AggregatorPackage;
import org.eclipse.b3.aggregator.AggregatorPlugin;
import org.eclipse.b3.aggregator.InfosProvider;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.Status;
import org.eclipse.b3.aggregator.StatusCode;
import org.eclipse.b3.aggregator.StatusProvider;
import org.eclipse.b3.aggregator.p2.MetadataRepository;
import org.eclipse.b3.aggregator.p2.P2Factory;
import org.eclipse.b3.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.b3.aggregator.util.AggregatorResource;
import org.eclipse.b3.cli.HeadlessActivator;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.equinox.internal.p2.core.helpers.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRepositoryReferenceImpl
extends MinimalEObjectImpl.Container
implements MetadataRepositoryReference {
    protected int eFlags = 0;
    protected static final boolean ENABLED_EDEFAULT = true;
    protected static final int ENABLED_EFLAG = 1;
    protected EList<String> errors;
    protected EList<String> warnings;
    protected EList<String> infos;
    protected MetadataRepository metadataRepository;
    protected static final String LOCATION_EDEFAULT = null;
    protected String location = LOCATION_EDEFAULT;
    protected static final String NATURE_EDEFAULT = "p2";
    protected String nature = "p2";

    private static String getString(String key) {
        return AggregatorPlugin.INSTANCE.getString(key);
    }

    protected MetadataRepositoryReferenceImpl() {
        this.eFlags |= 1;
    }

    public MetadataRepository basicGetMetadataRepository() {
        return this.metadataRepository;
    }

    @Override
    public synchronized void cancelRepositoryLoad() {
        MetadataRepositoryResourceImpl.cancelLoadRepository(this.getNature(), this.getResolvedLocation(), this.getAggregator());
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == StatusProvider.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
                case 3: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == StatusProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == InfosProvider.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.isEnabled();
            }
            case 1: {
                return this.getStatus();
            }
            case 2: {
                return this.getErrors();
            }
            case 3: {
                return this.getWarnings();
            }
            case 4: {
                return this.getInfos();
            }
            case 5: {
                if (resolve) {
                    return this.getMetadataRepository();
                }
                return this.basicGetMetadataRepository();
            }
            case 6: {
                return this.getLocation();
            }
            case 7: {
                return this.getNature();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return (this.eFlags & 1) == 0;
            }
            case 1: {
                return this.getStatus() != null;
            }
            case 2: {
                return this.errors != null && !this.errors.isEmpty();
            }
            case 3: {
                return this.warnings != null && !this.warnings.isEmpty();
            }
            case 4: {
                return this.infos != null && !this.infos.isEmpty();
            }
            case 5: {
                return this.metadataRepository != null;
            }
            case 6: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 7: {
                return NATURE_EDEFAULT == null ? this.nature != null : !NATURE_EDEFAULT.equals(this.nature);
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setEnabled((Boolean)newValue);
                return;
            }
            case 2: {
                this.getErrors().clear();
                this.getErrors().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getWarnings().clear();
                this.getWarnings().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getInfos().clear();
                this.getInfos().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setMetadataRepository((MetadataRepository)newValue);
                return;
            }
            case 6: {
                this.setLocation((String)newValue);
                return;
            }
            case 7: {
                this.setNature((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setEnabled(true);
                return;
            }
            case 2: {
                this.getErrors().clear();
                return;
            }
            case 3: {
                this.getWarnings().clear();
                return;
            }
            case 4: {
                this.getInfos().clear();
                return;
            }
            case 5: {
                this.setMetadataRepository(null);
                return;
            }
            case 6: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 7: {
                this.setNature(NATURE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public Aggregator getAggregator() {
        return (Aggregator)this.eContainer();
    }

    @Override
    public EList<String> getErrors() {
        this.errors = new BasicEList();
        String nature = this.getNature();
        String location = this.getResolvedLocation();
        if (nature == null || location == null) {
            this.errors.add((Object)MetadataRepositoryReferenceImpl.getString("_UI_ErrorMessage_RepositoryIsNotSet"));
            return this.errors;
        }
        MetadataRepositoryResourceImpl res = (MetadataRepositoryResourceImpl)MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, location, this.getAggregator(), false);
        if (res == null) {
            this.errors.add((Object)MetadataRepositoryReferenceImpl.getString("_UI_ErrorMessage_RepositoryIsNotAvailable"));
            return this.errors;
        }
        return this.errors;
    }

    @Override
    public EList<String> getInfos() {
        if (this.infos == null) {
            this.infos = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 4);
        }
        return this.infos;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public MetadataRepository getMetadataRepository() {
        return this.getMetadataRepository(true);
    }

    @Override
    public MetadataRepository getMetadataRepository(boolean forceResolve) {
        if (!this.isBranchEnabled()) {
            return null;
        }
        if (forceResolve) {
            if (this.metadataRepository == null) {
                this.metadataRepository = P2Factory.eINSTANCE.createMetadataRepositoryProxy(this.getNature(), this.getResolvedLocation());
            }
            return this.getMetadataRepositoryGen();
        }
        return this.metadataRepository;
    }

    public MetadataRepository getMetadataRepositoryGen() {
        if (this.metadataRepository != null && ((EObject)this.metadataRepository).eIsProxy()) {
            InternalEObject oldMetadataRepository = (InternalEObject)this.metadataRepository;
            this.metadataRepository = (MetadataRepository)this.eResolveProxy(oldMetadataRepository);
            if (this.metadataRepository != oldMetadataRepository && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldMetadataRepository, (Object)this.metadataRepository));
            }
        }
        return this.metadataRepository;
    }

    @Override
    public String getNature() {
        return this.nature;
    }

    @Override
    public String getResolvedLocation() {
        URI base;
        String location = StringUtils.trimmedOrNull((String)this.getLocation());
        if (location == null) {
            return null;
        }
        if ((location = location.replaceAll("\\s", "%20").replace('\\', '/')).charAt(location.length() - 1) == '/') {
            location = location.substring(0, location.length() - 1);
        }
        if (location.length() > 1 && location.charAt(1) == ':' && Character.isLetter(location.charAt(0))) {
            return "file:/" + location;
        }
        if (location.charAt(0) == '/') {
            return "file:" + location;
        }
        int colonIdx = location.indexOf(58);
        if (colonIdx > 0) {
            int idx = 0;
            char c = location.charAt(0);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                ++idx;
                while (idx < colonIdx) {
                    c = location.charAt(idx);
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '+' || c == '.')) break;
                    ++idx;
                }
            }
            if (idx < colonIdx) {
                colonIdx = -1;
            }
        }
        if (colonIdx <= 0 && (base = ((EObject)this.getAggregator()).eResource().getURI()) != null) {
            location = base.trimSegments(1).appendSegments(StringHelper.getArrayFromString((String)location, (char)'/')).toString();
        }
        return location;
    }

    @Override
    public synchronized Status getStatus() {
        if (this.isBranchEnabled()) {
            MetadataRepositoryResourceImpl res;
            if (this.getMetadataRepository(false) != null && !((EObject)this.getMetadataRepository(false)).eIsProxy()) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
            }
            String nature = this.getNature();
            String location = this.getResolvedLocation();
            if (nature == null || location == null) {
                return AggregatorFactory.eINSTANCE.createStatus(StatusCode.BROKEN, MetadataRepositoryReferenceImpl.getString("_UI_ErrorMessage_RepositoryIsNotSet"));
            }
            try {
                res = (MetadataRepositoryResourceImpl)MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, location, this.getAggregator(), false);
            }
            catch (Exception e) {
                res = null;
            }
            if (res != null) {
                return res.getStatus();
            }
        }
        return AggregatorFactory.eINSTANCE.createStatus(StatusCode.OK);
    }

    @Override
    public EList<String> getWarnings() {
        if (this.warnings == null) {
            this.warnings = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 3);
        }
        return this.warnings;
    }

    @Override
    public boolean isBranchEnabled() {
        return this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        return (this.eFlags & 1) != 0;
    }

    @Override
    public void onRepositoryLoad() {
        if (this instanceof MappedRepository) {
            ((MappedRepository)((Object)this)).updateAvailableVersions();
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, null, null));
            }
        }
        if (!HeadlessActivator.getInstance().isHeadless()) {
            this.getAggregatorResource().analyzeResource();
        }
    }

    @Override
    public void setEnabled(boolean newEnabled) {
        boolean oldEnabled;
        boolean bl = oldEnabled = (this.eFlags & 1) != 0;
        this.eFlags = newEnabled ? (this.eFlags |= 1) : (this.eFlags &= 0xFFFFFFFE);
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, oldEnabled, newEnabled));
        }
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public synchronized void setMetadataRepository(MetadataRepository newMetadataRepository) {
        this.setMetadataRepositoryGen(newMetadataRepository);
    }

    public void setMetadataRepositoryGen(MetadataRepository newMetadataRepository) {
        MetadataRepository oldMetadataRepository = this.metadataRepository;
        this.metadataRepository = newMetadataRepository;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldMetadataRepository, (Object)this.metadataRepository));
        }
    }

    @Override
    public void setNature(String newNature) {
        String oldNature = this.nature;
        this.nature = newNature;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldNature, (Object)this.nature));
        }
    }

    @Override
    public synchronized void startRepositoryLoad(boolean forceReload) {
        Aggregator aggregator;
        String resolvedLocation;
        if (StringUtils.trimmedOrNull((String)this.getLocation()) == null) {
            this.setMetadataRepository(null);
            this.onRepositoryLoad();
            return;
        }
        String nature = this.getNature();
        Resource res = MetadataRepositoryResourceImpl.getResourceForNatureAndLocation(nature, resolvedLocation = this.getResolvedLocation(), aggregator = this.getAggregator());
        if (res == null) {
            this.onRepositoryLoad();
            return;
        }
        ((MetadataRepositoryResourceImpl)res).startAsynchronousLoad(forceReload);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (enabled: ");
        result.append((this.eFlags & 1) != 0);
        result.append(", errors: ");
        result.append(this.errors);
        result.append(", warnings: ");
        result.append(this.warnings);
        result.append(", infos: ");
        result.append(this.infos);
        result.append(", location: ");
        result.append(this.location);
        result.append(", nature: ");
        result.append(this.nature);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return AggregatorPackage.Literals.METADATA_REPOSITORY_REFERENCE;
    }

    private AggregatorResource getAggregatorResource() {
        if (this.eResource() instanceof AggregatorResource) {
            return (AggregatorResource)this.eResource();
        }
        InternalEObject parent = this.eContainer;
        while (parent != null && !(parent instanceof Aggregator)) {
            parent = parent.eContainer();
        }
        if (parent == null) {
            throw new RuntimeException("Cannot find aggregator top node");
        }
        return (AggregatorResource)parent.eResource();
    }
}

