/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.mail.MailMessage;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.Contact;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.MetadataRepositoryReference;
import org.eclipse.b3.aggregator.engine.CategoriesGenerator;
import org.eclipse.b3.aggregator.engine.MirrorGenerator;
import org.eclipse.b3.aggregator.engine.RepositoryVerifier;
import org.eclipse.b3.aggregator.engine.SourceCompositeGenerator;
import org.eclipse.b3.aggregator.engine.VerificationFeatureGenerator;
import org.eclipse.b3.aggregator.p2.util.MetadataRepositoryResourceImpl;
import org.eclipse.b3.aggregator.p2.util.ResourceSetWithAgent;
import org.eclipse.b3.aggregator.transformer.TransformationManager;
import org.eclipse.b3.aggregator.util.ResourceUtils;
import org.eclipse.b3.cli.AbstractCommand;
import org.eclipse.b3.p2.util.P2Utils;
import org.eclipse.b3.util.ExceptionUtils;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
extends AbstractCommand {
    public static final String ALL_CONTRIBUTED_CONTENT_FEATURE = "all.contributed.content.feature.group";
    public static final String PDE_TARGET_PLATFORM_NAMESPACE = "A.PDE.Target.Platform";
    public static final String PDE_TARGET_PLATFORM_NAME = "Cannot be installed into the IDE";
    public static final Version ALL_CONTRIBUTED_CONTENT_VERSION = Version.createOSGi((int)1, (int)0, (int)0);
    public static final String COMPOSITE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.compositeRepository";
    public static final String COMPOSITE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.compositeRepository";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String NAMESPACE_OSGI_BUNDLE = "osgi.bundle";
    public static final String PROFILE_ID = "b3AggregatorProfile";
    public static final String REPO_FOLDER_VERIFICATION = "verification";
    public static final String REPO_FOLDER_FINAL = "final";
    public static final String REPO_FOLDER_INTERIM = "interim";
    public static final String REPO_FOLDER_TEMP = "temp";
    public static final String REPO_FOLDER_AGGREGATE = "aggregate";
    public static final String SIMPLE_ARTIFACTS_TYPE = "org.eclipse.equinox.p2.artifact.repository.simpleRepository";
    public static final String SIMPLE_METADATA_TYPE = "org.eclipse.equinox.p2.metadata.repository.simpleRepository";
    public static final String INTERNAL_METADATA_TYPE = "org.eclipse.b3.aggregator.engine.internalRepository";
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd-HHmm");
    static final String FEATURE_GROUP_SUFFIX = ".feature.group";
    static final IArtifactKey[] NO_ARTIFACT_KEYS = new IArtifactKey[0];
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final Project PROPERTY_REPLACER = new Project();
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HHmm");
    @Option(name="--action", usage="Specifies the type of the execution. Default is BUILD.")
    private ActionType action = ActionType.BUILD;
    @Option(name="--buildModel", required=true, usage="Appoints the aggregation definition that drives the execution")
    private File buildModelLocation;
    @Option(name="--buildId", usage="Assigns a build identifier to the aggregation. The identifier is used to identify the build in notification emails. Defaults to: build-<timestamp> where <timestamp> is formatted according as yyyyMMddHHmm, i.e. build-200911031527", metaVar="<ID>")
    private String buildID;
    @Option(name="--buildRoot", usage="Controls the output. Defaults to the build root defined in the aggregation definition.")
    private File buildRoot;
    @Option(name="--logURL", usage="The URL that will be pasted into the emails. Should normally point to the a public URL for output log for the aggregator so that the receiver can browse the log for details on failures.", metaVar="<url>")
    private String logURL;
    @Option(name="--production", usage="Indicates that the build is running in real production. That means that no mock emails will be sent. Instead, the contacts listed for each contribution will get emails when things go wrong.")
    private boolean production = false;
    @Option(name="--mockEmailCc", usage="Becomes the CC receiver of the mock-emails sent from the aggregator", metaVar="<address>")
    private String mockEmailCC;
    @Option(name="--emailFrom", usage="Becomes the sender of the emails sent from the aggregator. Defaults to the build master defined in the aggregator definition.", metaVar="<address>")
    private String emailFrom;
    @Option(name="--emailFromName", usage="Mock sender's name", metaVar="<name>")
    private String emailFromName;
    @Option(name="--mockEmailTo", usage="Becomes the receiver of the mock-emails sent from the aggregator", metaVar="<address>")
    private String mockEmailTo;
    @Option(name="--smtpHost", usage="The SMTP host to talk to when sending emails. Defaults to \"localhost\".", metaVar="<host>")
    private String smtpHost;
    @Option(name="--smtpPort", usage="The SMTP port number to use when talking to the SMTP host. Default is 25.", metaVar="<port>")
    private int smtpPort;
    @Option(name="--subjectPrefix", usage="The prefix to use for the subject when sending emails. Defaults to the label defined in the aggregation definition. The subject is formatted as: \"[<subjectPrefix>] Failed for build <buildId>\"", metaVar="<subject>")
    private String subjectPrefix;
    @Argument
    private List<String> unparsed = new ArrayList<String>();
    private Aggregator aggregator;
    private String buildLabel;
    private String buildMasterEmail;
    private String buildMasterName;
    private List<IInstallableUnit> categoryIUs;
    private boolean mirrorReferences = false;
    private Pattern referenceIncludePattern;
    private Pattern referenceExcludePattern;
    private ResourceSet resourceSet;
    private boolean sendmail = false;
    private final Set<IInstallableUnit> unitsToAggregate = new HashSet<IInstallableUnit>();
    private Set<MappedRepository> exclusions;
    private CompositeMetadataRepository sourceComposite;
    private IProvisioningAgent provisioningAgent;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$b3$aggregator$engine$Builder$ActionType;

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        PROPERTY_REPLACER.initProperties();
        DATE_FORMAT.setTimeZone(utc);
        TIME_FORMAT.setTimeZone(utc);
        TIMESTAMP_FORMAT.setTimeZone(utc);
    }

    public static final java.net.URI createURI(File repoLocation) throws CoreException {
        IPath path;
        if (repoLocation != null && (path = Path.fromOSString((String)repoLocation.getPath())).isAbsolute()) {
            try {
                String pathStr = path.removeTrailingSeparator().toPortableString();
                if (!pathStr.startsWith("/")) {
                    pathStr = "/" + pathStr;
                }
                return new java.net.URI("file", null, pathStr, null);
            }
            catch (URISyntaxException e) {
                throw ExceptionUtils.wrap((Throwable)e);
            }
        }
        throw ExceptionUtils.fromMessage((String)"File %s is not an absolute path", (Object[])new Object[]{repoLocation});
    }

    public static String getExceptionMessages(Throwable e) {
        StringBuilder bld = new StringBuilder();
        Builder.getExceptionMessages(e, bld);
        return bld.toString();
    }

    public static IInstallableUnit getIU(IMetadataRepository mdr, String id, String version) {
        IQuery query = (version = StringUtils.trimmedOrNull((String)version)) == null ? QueryUtil.createIUQuery((String)id) : QueryUtil.createIUQuery((String)id, (Version)Version.create((String)version));
        IQueryResult result = mdr.query(query, null);
        return !result.isEmpty() ? (IInstallableUnit)result.iterator().next() : null;
    }

    private static void deleteAndCheck(File folder, String fileName) throws CoreException {
        File file = new File(folder, fileName);
        file.delete();
        if (file.exists()) {
            throw ExceptionUtils.fromMessage((String)"Unable to delete file %s\n", (Object[])new Object[]{file.getAbsolutePath()});
        }
    }

    private static void deleteMetadataRepository(IMetadataRepositoryManager mdrMgr, File repoFolder) throws CoreException {
        java.net.URI repoURI = Builder.createURI(repoFolder);
        mdrMgr.removeRepository(repoURI);
        Builder.deleteAndCheck(repoFolder, "compositeContent.jar");
        Builder.deleteAndCheck(repoFolder, "compositeContent.xml");
        Builder.deleteAndCheck(repoFolder, "content.jar");
        Builder.deleteAndCheck(repoFolder, "content.xml");
    }

    private static void getExceptionMessages(Throwable e, StringBuilder bld) {
        bld.append(e.getClass().getName());
        bld.append(": ");
        if (e.getMessage() != null) {
            bld.append(e.getMessage());
        }
        if (e instanceof CoreException) {
            e = ((CoreException)e).getStatus().getException();
        } else {
            Throwable t = e.getCause();
            Throwable throwable = e = t == e ? null : t;
        }
        if (e != null) {
            bld.append("\nCaused by: ");
            Builder.getExceptionMessages(e, bld);
        }
    }

    private static void send(String host, int port, EmailAddress from, List<EmailAddress> toList, EmailAddress cc, String subject, String message) throws IOException {
        MailMessage mailMessage = new MailMessage(host, port);
        mailMessage.from(from.toString());
        for (EmailAddress to : toList) {
            mailMessage.to(to.toString());
        }
        if (cc != null) {
            mailMessage.cc(cc.toString());
        }
        mailMessage.setSubject(subject);
        mailMessage.setHeader("Date", DateUtils.getDateForHeader());
        mailMessage.setHeader("Content-Type", "text/plain; charset=us-ascii");
        PrintStream out = mailMessage.getPrintStream();
        out.print(message);
        mailMessage.sendAndClose();
    }

    public void addMappingExclusion(MappedRepository repository) {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<MappedRepository>();
        }
        this.exclusions.add(repository);
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    public String getBuildID() {
        return this.buildID;
    }

    public File getBuildModelLocation() {
        return this.buildModelLocation;
    }

    public File getBuildRoot() {
        return this.buildRoot;
    }

    public List<IInstallableUnit> getCategoryIUs() {
        return this.categoryIUs;
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.provisioningAgent;
    }

    public String getShortDescription() {
        return "Aggregates source repositories into a resulting repository using aggregator definition";
    }

    public CompositeMetadataRepository getSourceComposite() {
        return this.sourceComposite;
    }

    public java.net.URI getSourceCompositeURI() throws CoreException {
        return Builder.createURI(new File(this.buildRoot, REPO_FOLDER_INTERIM));
    }

    public File getTempRepositoryFolder() {
        return new File(this.buildRoot, REPO_FOLDER_TEMP);
    }

    public Set<IInstallableUnit> getUnitsToAggregate() {
        return this.unitsToAggregate;
    }

    public boolean isCleanBuild() {
        return this.action == ActionType.CLEAN_BUILD;
    }

    public boolean isMapVerbatim(MappedRepository repo) {
        return !repo.isMapExclusive() && !repo.isMirrorArtifacts() && StringUtils.trimmedOrNull((String)repo.getCategoryPrefix()) == null && (this.exclusions == null || !this.exclusions.contains(repo) || !"p2".equals(repo.getNature()));
    }

    public boolean isMatchedReference(String reference) {
        Matcher m;
        if ((reference = StringUtils.trimmedOrNull((String)reference)) == null) {
            return false;
        }
        if (this.referenceIncludePattern != null && !(m = this.referenceIncludePattern.matcher(reference)).matches()) {
            return false;
        }
        return this.referenceExcludePattern == null || !(m = this.referenceExcludePattern.matcher(reference)).matches();
    }

    public boolean isMirrorReferences() {
        return this.mirrorReferences;
    }

    public boolean isProduction() {
        return this.production;
    }

    public boolean isTopLevelCategory(IInstallableUnit iu) {
        return iu != null && "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) && !"true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.group"));
    }

    public boolean isVerifyOnly() {
        return this.action == ActionType.VERIFY;
    }

    /*
     * Exception decompiling
     */
    public int run(boolean fromIDE, IProgressMonitor monitor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void sendEmail(Contribution contrib, List<String> errors) {
        boolean useMock;
        boolean bl = useMock = this.mockEmailTo != null;
        if (!this.production && !useMock || !this.sendmail) {
            return;
        }
        try {
            ArrayList<EmailAddress> recipients;
            EmailAddress buildMaster = new EmailAddress(this.buildMasterEmail, this.buildMasterName);
            EmailAddress emailFromAddr = this.emailFrom != null ? new EmailAddress(this.emailFrom, this.emailFromName) : buildMaster;
            ArrayList<EmailAddress> toList = new ArrayList<EmailAddress>();
            if (contrib == null) {
                toList.add(buildMaster);
            } else {
                for (Contact contact : contrib.getContacts()) {
                    toList.add(new EmailAddress(contact.getEmail(), contact.getName()));
                }
            }
            StringBuilder msgBld = new StringBuilder();
            msgBld.append("The following error");
            if (errors.size() > 1) {
                msgBld.append('s');
            }
            msgBld.append(" occured when building ");
            msgBld.append(this.buildLabel);
            msgBld.append(":\n\n");
            for (String error : errors) {
                msgBld.append(error);
                msgBld.append("\n\n");
            }
            if (this.logURL != null) {
                msgBld.append("Check the log file for more information: ");
                msgBld.append(this.logURL);
                msgBld.append('\n');
            }
            if (useMock) {
                msgBld.append("\nThis is a mock mail. Real recipients would have been:\n");
                for (EmailAddress to : toList) {
                    msgBld.append("  ");
                    msgBld.append(to);
                    msgBld.append('\n');
                }
            }
            String msgContent = msgBld.toString();
            if (this.subjectPrefix == null) {
                this.subjectPrefix = this.buildLabel;
            }
            String subject = String.format("[%s] Failed for build %s", this.subjectPrefix, this.buildID);
            msgBld.setLength(0);
            msgBld.append("Sending email to: ");
            for (EmailAddress to : toList) {
                msgBld.append(to);
                msgBld.append(',');
            }
            msgBld.append(buildMaster);
            if (useMock) {
                msgBld.append(" *** Using mock: ");
                if (this.mockEmailTo != null) {
                    msgBld.append(this.mockEmailTo);
                    if (this.mockEmailCC != null) {
                        msgBld.append(',');
                        msgBld.append(this.mockEmailTo);
                    }
                } else {
                    msgBld.append(this.mockEmailCC);
                }
                msgBld.append(" ***");
            }
            LogUtils.info((String)msgBld.toString(), (Object[])new Object[0]);
            LogUtils.info((String)"From: %s", (Object[])new Object[]{emailFromAddr});
            LogUtils.info((String)"Subject: %s", (Object[])new Object[]{subject});
            LogUtils.info((String)"Message content: %s", (Object[])new Object[]{msgContent});
            EmailAddress ccRecipient = null;
            if (useMock) {
                recipients = this.mockRecipients();
                ccRecipient = this.mockCCRecipient();
            } else {
                recipients = toList;
                if (contrib != null) {
                    ccRecipient = buildMaster;
                }
            }
            Builder.send(this.smtpHost, this.smtpPort, emailFromAddr, recipients, ccRecipient, subject, msgContent);
        }
        catch (IOException e) {
            LogUtils.error((Throwable)e, (String)"Failed to send email: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    public void setAction(ActionType action) {
        this.action = action;
    }

    public void setBuildID(String buildId) {
        this.buildID = buildId;
    }

    public void setBuildModelLocation(File buildModelLocation) {
        this.buildModelLocation = buildModelLocation;
    }

    public void setBuildRoot(File buildRoot) {
        this.buildRoot = buildRoot;
    }

    public void setCategoryIUs(List<IInstallableUnit> categoryIUs) {
        this.categoryIUs = categoryIUs;
    }

    public void setEmailFrom(String emailFrom) {
        this.emailFrom = emailFrom;
    }

    public void setEmailFromName(String emailFromName) {
        this.emailFromName = emailFromName;
    }

    public void setLogLevel(int level) {
        throw new UnsupportedOperationException("Log levels are not supported");
    }

    public void setLogURL(String logURL) {
        this.logURL = logURL;
    }

    public void setMirrorReferences(boolean mirrorReferences) {
        this.mirrorReferences = mirrorReferences;
    }

    public void setMockEmailCC(String mockEmailCc) {
        this.mockEmailCC = mockEmailCc;
    }

    public void setMockEmailTo(String mockEmailTo) {
        this.mockEmailTo = mockEmailTo;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    public void setReferenceExcludePattern(String pattern) {
        this.referenceExcludePattern = (pattern = StringUtils.trimmedOrNull((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setReferenceIncludePattern(String pattern) {
        this.referenceIncludePattern = (pattern = StringUtils.trimmedOrNull((String)pattern)) == null ? null : Pattern.compile(pattern);
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setSourceComposite(CompositeMetadataRepository sourceComposite) {
        this.sourceComposite = sourceComposite;
    }

    public void setSubjectPrefix(String subjectPrefix) {
        this.subjectPrefix = subjectPrefix;
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.unparsed.size() > 0) {
            throw new Exception("Too many arguments");
        }
        return this.run(false, monitor);
    }

    private void cleanAll() throws CoreException {
        if (this.buildRoot.exists()) {
            FileUtils.deleteAll((File)this.buildRoot);
            if (this.buildRoot.exists()) {
                throw ExceptionUtils.fromMessage((String)"Failed to delete folder %s", (Object[])new Object[]{this.buildRoot.getAbsolutePath()});
            }
        }
    }

    private void cleanMetadata(IProvisioningAgent agent) throws CoreException {
        IMetadataRepositoryManager mdrMgr = (IMetadataRepositoryManager)P2Utils.getRepositoryManager((IProvisioningAgent)agent, IMetadataRepositoryManager.class);
        try {
            File finalRepo = new File(this.buildRoot, REPO_FOLDER_FINAL);
            Builder.deleteMetadataRepository(mdrMgr, finalRepo);
            Builder.deleteMetadataRepository(mdrMgr, new File(finalRepo, REPO_FOLDER_AGGREGATE));
            File interimRepo = new File(this.buildRoot, REPO_FOLDER_INTERIM);
            Builder.deleteMetadataRepository(mdrMgr, interimRepo);
            Builder.deleteMetadataRepository(mdrMgr, new File(interimRepo, REPO_FOLDER_VERIFICATION));
        }
        finally {
            P2Utils.ungetRepositoryManager((IProvisioningAgent)this.provisioningAgent, (IRepositoryManager)mdrMgr);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadAllMappedRepositories() throws CoreException {
        block5: {
            repositoriesToLoad = new HashSet<MetadataRepositoryReference>();
            for (MetadataRepositoryReference repo : this.getAggregator().getAllMetadataRepositoryReferences(true)) {
                res = (MetadataRepositoryResourceImpl)MetadataRepositoryResourceImpl.getResourceForNatureAndLocation((String)repo.getNature(), (String)repo.getResolvedLocation(), (Aggregator)repo.getAggregator());
                res.startAsynchronousLoad(false);
                repositoriesToLoad.add(repo);
            }
            try {
                for (MetadataRepositoryReference repo : repositoriesToLoad) {
                    mdr = repo.getMetadataRepository();
                    if (mdr != null && !((EObject)mdr).eIsProxy()) continue;
                    throw ExceptionUtils.fromMessage((String)"Unable to load repository %s:%s", (Object[])new Object[]{repo.getNature(), repo.getLocation()});
                }
                break block5;
            }
            catch (CoreException e) {
                ** for (repo : repositoriesToLoad)
            }
lbl-1000:
            // 1 sources

            {
                repo.cancelRepositoryLoad();
                continue;
            }
lbl18:
            // 1 sources

            throw e;
        }
    }

    private void loadModel() throws CoreException {
        try {
            IContainer container = ContainerFactory.getDefault().createContainer();
            container.getAdapter(IRemoteFileSystemBrowserContainerAdapter.class);
        }
        catch (ContainerCreateException e) {
            throw ExceptionUtils.fromMessage((String)"Unable to initialize file transfer adapter", (Object[])new Object[0]);
        }
        try {
            Diagnostic diag;
            Resource resource;
            this.resourceSet = new ResourceSetWithAgent();
            String modelPath = this.buildModelLocation.getAbsolutePath();
            File modelFile = new File(modelPath);
            if (!modelFile.exists()) {
                throw ExceptionUtils.fromMessage((String)"Specified build model file does not exist", (Object[])new Object[0]);
            }
            if (!modelFile.isFile()) {
                throw ExceptionUtils.fromMessage((String)"Specified build model location does not appoint a file", (Object[])new Object[0]);
            }
            URI fileURI = URI.createFileURI((String)modelPath);
            if (ResourceUtils.isCurrentModel((URI)fileURI)) {
                resource = this.resourceSet.getResource(fileURI, true);
            } else {
                LogUtils.warning((String)"The build model file is obsolete, using the default transformation", (Object[])new Object[0]);
                TransformationManager tm = new TransformationManager(fileURI);
                if (!tm.isSrcNamespaceFound()) {
                    throw ExceptionUtils.fromMessage((String)"No transformation found for specified build model", (Object[])new Object[0]);
                }
                resource = tm.transformResource();
                this.resourceSet.getResources().add((Object)resource);
            }
            EList content = resource.getContents();
            if (content.size() != 1) {
                throw ExceptionUtils.fromMessage((String)"ECore Resource did not contain one resource. It had %d", (Object[])new Object[]{content.size()});
            }
            this.aggregator = (Aggregator)content.get(0);
            this.verifyContributions();
            this.sendmail = this.aggregator.isSendmail();
            this.buildLabel = this.aggregator.getLabel();
            Contact buildMaster = this.aggregator.getBuildmaster();
            if (buildMaster != null) {
                this.buildMasterName = buildMaster.getName();
                this.buildMasterEmail = buildMaster.getEmail();
            }
            if ((diag = Diagnostician.INSTANCE.validate((EObject)this.aggregator)).getSeverity() == 4) {
                for (Diagnostic childDiag : diag.getChildren()) {
                    LogUtils.error((String)childDiag.getMessage(), (Object[])new Object[0]);
                }
                throw ExceptionUtils.fromMessage((String)"Build model validation failed: %s", (Object[])new Object[]{diag.getMessage()});
            }
            if (this.buildRoot == null) {
                this.setBuildRoot(new File(PROPERTY_REPLACER.replaceProperties(this.aggregator.getBuildRoot())));
                if (!this.buildRoot.isAbsolute()) {
                    this.setBuildRoot(new File(this.buildModelLocation.getParent(), this.buildRoot.getPath()).getAbsoluteFile());
                }
            } else if (!this.buildRoot.isAbsolute()) {
                this.setBuildRoot(this.buildRoot.getAbsoluteFile());
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.wrap((Throwable)e);
        }
    }

    private EmailAddress mockCCRecipient() throws UnsupportedEncodingException {
        EmailAddress mock = null;
        if (this.mockEmailCC != null) {
            mock = new EmailAddress(this.mockEmailCC, null);
        }
        return mock;
    }

    private List<EmailAddress> mockRecipients() throws UnsupportedEncodingException {
        if (this.mockEmailTo != null) {
            return Collections.singletonList(new EmailAddress(this.mockEmailTo, null));
        }
        return Collections.emptyList();
    }

    private void runCategoriesRepoGenerator(IProgressMonitor monitor) throws CoreException {
        CategoriesGenerator generator = new CategoriesGenerator(this);
        generator.run(monitor);
    }

    private void runCompositeGenerator(IProgressMonitor monitor) throws CoreException {
        SourceCompositeGenerator generator = new SourceCompositeGenerator(this);
        generator.run(monitor);
    }

    private void runMirroring(IProgressMonitor monitor) throws CoreException {
        MirrorGenerator generator = new MirrorGenerator(this);
        generator.run(monitor);
    }

    private void runRepositoryVerifier(IProgressMonitor monitor) throws CoreException {
        RepositoryVerifier ipt = new RepositoryVerifier(this);
        ipt.run(monitor);
    }

    private void runVerificationFeatureGenerator(IProgressMonitor monitor) throws CoreException {
        VerificationFeatureGenerator generator = new VerificationFeatureGenerator(this);
        generator.run(monitor);
    }

    private void verifyContributions() throws CoreException {
        ArrayList<String> errors = new ArrayList<String>();
        for (Contribution contribution : this.aggregator.getContributions()) {
            Resource res = ((EObject)contribution).eResource();
            for (Resource.Diagnostic diag : res.getErrors()) {
                String msg = res.getURI() + ": " + diag.toString();
                LogUtils.error((String)msg, (Object[])new Object[0]);
                errors.add(msg);
            }
        }
        if (errors.size() > 0) {
            this.sendEmail(null, errors);
            throw ExceptionUtils.fromMessage((String)"Not all contributions could be parsed", (Object[])new Object[0]);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$b3$aggregator$engine$Builder$ActionType() {
        if ($SWITCH_TABLE$org$eclipse$b3$aggregator$engine$Builder$ActionType != null) {
            return $SWITCH_TABLE$org$eclipse$b3$aggregator$engine$Builder$ActionType;
        }
        int[] nArray = new int[ActionType.values().length];
        try {
            nArray[ActionType.BUILD.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActionType.CLEAN.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActionType.CLEAN_BUILD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ActionType.VERIFY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$b3$aggregator$engine$Builder$ActionType = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ActionType {
        CLEAN,
        VERIFY,
        BUILD,
        CLEAN_BUILD;

    }

    private static class EmailAddress {
        private final String address;
        private final String personal;

        EmailAddress(String address, String personal) {
            this.address = address;
            this.personal = personal;
        }

        public String toString() {
            if (this.personal == null) {
                return this.address;
            }
            return String.valueOf(this.personal) + " <" + this.address + ">";
        }
    }
}

