/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.aggregator.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.b3.aggregator.Aggregator;
import org.eclipse.b3.aggregator.Category;
import org.eclipse.b3.aggregator.Contribution;
import org.eclipse.b3.aggregator.CustomCategory;
import org.eclipse.b3.aggregator.ExclusionRule;
import org.eclipse.b3.aggregator.Feature;
import org.eclipse.b3.aggregator.MapRule;
import org.eclipse.b3.aggregator.MappedRepository;
import org.eclipse.b3.aggregator.engine.Builder;
import org.eclipse.b3.aggregator.engine.BuilderPhase;
import org.eclipse.b3.aggregator.engine.VersionSuffixGenerator;
import org.eclipse.b3.aggregator.util.TimeUtils;
import org.eclipse.b3.p2.InstallableUnit;
import org.eclipse.b3.p2.MetadataRepository;
import org.eclipse.b3.p2.P2Factory;
import org.eclipse.b3.p2.impl.InstallableUnitImpl;
import org.eclipse.b3.p2.impl.ProvidedCapabilityImpl;
import org.eclipse.b3.p2.util.P2Bridge;
import org.eclipse.b3.util.LogUtils;
import org.eclipse.b3.util.MonitorUtils;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.VersionedId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoriesGenerator
extends BuilderPhase {
    private static void assignCategoryVersion(InstallableUnitImpl category) {
        ArrayList<VersionedId> includedBundles = new ArrayList<VersionedId>();
        ArrayList<VersionedId> includedFeatures = new ArrayList<VersionedId>();
        for (IRequirement req : category.getRequirements()) {
            if (!(req instanceof IRequiredCapability)) continue;
            IRequiredCapability cap = (IRequiredCapability)req;
            VersionRange range = cap.getRange();
            Version version = range == null ? Version.emptyVersion : range.getMinimum();
            VersionedId vn = new VersionedId(cap.getName(), version);
            if (cap.getName().endsWith(".feature.group")) {
                includedFeatures.add(vn);
                continue;
            }
            includedBundles.add(vn);
        }
        VersionSuffixGenerator suffixGen = new VersionSuffixGenerator();
        Version catVersion = Version.createOSGi((int)0, (int)0, (int)0, (String)suffixGen.generateSuffix(includedFeatures, includedBundles));
        category.setVersion(catVersion);
        EList providedCaps = category.getProvidedCapabilities();
        providedCaps.clear();
        ProvidedCapabilityImpl providedCap = (ProvidedCapabilityImpl)P2Factory.eINSTANCE.createProvidedCapability();
        providedCap.setName(category.getId());
        providedCap.setNamespace("org.eclipse.equinox.p2.iu");
        providedCap.setVersion(catVersion);
        providedCaps.add(providedCap);
    }

    public CategoriesGenerator(Builder builder) {
        super(builder);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        long start = TimeUtils.getNow();
        MonitorUtils.begin((IProgressMonitor)monitor, (int)10);
        String info = "Starting generation of categories";
        MonitorUtils.subTask((IProgressMonitor)monitor, (String)info);
        LogUtils.info((String)info, (Object[])new Object[0]);
        try {
            List<IInstallableUnit> results = new ArrayList<IInstallableUnit>();
            Aggregator aggregator = this.getBuilder().getAggregator();
            for (CustomCategory category : aggregator.getCustomCategories()) {
                results.add((IInstallableUnit)this.createCategoryIU(category));
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)5);
            for (Contribution contrib : aggregator.getContributions(true)) {
                for (MappedRepository repo : contrib.getRepositories(true)) {
                    results.addAll(this.getRepositoryCategories(repo));
                }
            }
            results = this.normalizeCategories(results);
            this.getBuilder().setCategoryIUs(results);
        }
        finally {
            MonitorUtils.done((IProgressMonitor)monitor);
        }
        LogUtils.info((String)"Done. Took %s", (Object[])new Object[]{TimeUtils.getFormattedDuration((long)start)});
    }

    private InstallableUnit createCategoryIU(CustomCategory category) {
        P2Factory factory = P2Factory.eINSTANCE;
        InstallableUnitImpl cat = (InstallableUnitImpl)factory.createInstallableUnit();
        cat.setSingleton(true);
        String categoryId = category.getIdentifier();
        cat.setId(categoryId);
        Map props = cat.getPropertyMap().map();
        props.put("org.eclipse.equinox.p2.name", category.getLabel());
        props.put("org.eclipse.equinox.p2.description", category.getDescription());
        props.put("org.eclipse.equinox.p2.type.category", "true");
        EList features = category.getFeatures();
        EList rcs = cat.getRequirements();
        ArrayList<VersionedId> includedBundles = new ArrayList<VersionedId>();
        ArrayList<VersionedId> includedFeatures = new ArrayList<VersionedId>();
        for (Feature feature : features) {
            if (!feature.isBranchEnabled()) continue;
            rcs.add(P2Bridge.importToModel((IRequirement)feature.getRequirement()));
            VersionedId vn = new VersionedId(feature.getName(), feature.getVersionRange().getMinimum());
            if (vn.getId().endsWith(".feature.group")) {
                includedFeatures.add(vn);
                continue;
            }
            includedBundles.add(vn);
        }
        ProvidedCapabilityImpl pc = (ProvidedCapabilityImpl)factory.createProvidedCapability();
        pc.setName(categoryId);
        pc.setNamespace("org.eclipse.equinox.p2.iu");
        VersionSuffixGenerator suffixGen = new VersionSuffixGenerator();
        Version catVersion = Version.createOSGi((int)0, (int)0, (int)0, (String)suffixGen.generateSuffix(includedFeatures, includedBundles));
        pc.setVersion(catVersion);
        cat.setVersion(catVersion);
        cat.getProvidedCapabilities().add((Object)pc);
        return cat;
    }

    private List<IInstallableUnit> getRepositoryCategories(MappedRepository repo) {
        Builder builder = this.getBuilder();
        ArrayList<IInstallableUnit> categoryIUs = new ArrayList<IInstallableUnit>();
        if (repo.isMapExclusive()) {
            for (Category category : repo.getCategories()) {
                Iterator iu;
                if (!category.isEnabled() || !builder.isTopLevelCategory((IInstallableUnit)(iu = category.resolveAsSingleton()))) continue;
                categoryIUs.add((IInstallableUnit)iu);
            }
        } else {
            EList mapRules = repo.getMapRules();
            block1: for (IInstallableUnit iu : repo.getMetadataRepository().getInstallableUnits()) {
                if (!builder.isTopLevelCategory(iu)) continue;
                for (MapRule mapRule : mapRules) {
                    if (mapRule instanceof ExclusionRule && iu.getId().equals(mapRule.getName()) && mapRule.getVersionRange().isIncluded(iu.getVersion())) continue block1;
                }
                categoryIUs.add(iu);
            }
        }
        String categoryPrefix = StringUtils.trimmedOrNull((String)repo.getCategoryPrefix());
        if (categoryPrefix != null) {
            String idSuffix = this.makeValidIUSuffix(categoryPrefix);
            StringBuilder prefixConcat = new StringBuilder();
            prefixConcat.append(categoryPrefix);
            prefixConcat.append(' ');
            int prefixLen = prefixConcat.length();
            int idx = categoryIUs.size();
            while (--idx >= 0) {
                IInstallableUnit iu = categoryIUs.get(idx);
                InstallableUnitImpl renamedIU = (InstallableUnitImpl)P2Bridge.importToModel((IInstallableUnit)iu);
                prefixConcat.setLength(prefixLen);
                prefixConcat.append(iu.getProperty("org.eclipse.equinox.p2.name"));
                renamedIU.getPropertyMap().map().put("org.eclipse.equinox.p2.name", prefixConcat.toString());
                renamedIU.setId(String.valueOf(iu.getId()) + idSuffix);
                CategoriesGenerator.assignCategoryVersion(renamedIU);
                categoryIUs.set(idx, (IInstallableUnit)renamedIU);
            }
        }
        return categoryIUs;
    }

    private String makeValidIUSuffix(String categoryPrefix) {
        int top = categoryPrefix.length();
        StringBuilder bld = new StringBuilder(top);
        int idx = 0;
        while (idx < top) {
            char c = categoryPrefix.charAt(idx);
            if (c >= 'A' && c <= 'Z') {
                bld.append(c + 32);
            } else if (c == '-' || c == '.' || c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z') {
                bld.append(c);
            } else if (c == ' ') {
                bld.append('_');
            }
            ++idx;
        }
        return bld.toString();
    }

    private List<IInstallableUnit> normalizeCategories(List<IInstallableUnit> categoryIUs) {
        HashMap map = new HashMap();
        HashMap<String, IInstallableUnit> catMap = new HashMap<String, IInstallableUnit>();
        for (IInstallableUnit category : categoryIUs) {
            String name = category.getProperty("org.eclipse.equinox.p2.name");
            ArrayList caps = (ArrayList)map.get(name);
            if (caps == null) {
                caps = new ArrayList();
                map.put(name, caps);
            }
            caps.addAll(category.getRequirements());
            IInstallableUnit oldCat = catMap.put(name, category);
            if (oldCat == null) continue;
            String oldDesc = oldCat.getProperty("org.eclipse.equinox.p2.description");
            if (oldDesc == null) {
                this.tossCategory(oldCat);
                continue;
            }
            String newDesc = category.getProperty("org.eclipse.equinox.p2.description");
            if (newDesc == null || newDesc.length() < oldDesc.length()) {
                this.tossCategory(category);
                catMap.put(name, oldCat);
                continue;
            }
            if (category.getVersion().compareTo((Object)oldCat.getVersion()) <= 0) continue;
            this.tossCategory(oldCat);
        }
        ArrayList<IInstallableUnit> normalized = new ArrayList<IInstallableUnit>();
        for (IInstallableUnit category : catMap.values()) {
            String name = category.getProperty("org.eclipse.equinox.p2.name");
            List newCaps = (List)map.get(name);
            Collection origCaps = category.getRequirements();
            if (origCaps.size() == newCaps.size() && origCaps.containsAll(newCaps)) {
                normalized.add(category);
                continue;
            }
            InstallableUnitImpl newCategory = (InstallableUnitImpl)P2Factory.eINSTANCE.createInstallableUnit();
            newCategory.setId(category.getId());
            for (Map.Entry entry : category.getProperties().entrySet()) {
                newCategory.getPropertyMap().put((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
            newCategory.getRequirements().addAll((Collection)newCaps);
            CategoriesGenerator.assignCategoryVersion(newCategory);
            this.tossCategory(category);
            normalized.add((IInstallableUnit)newCategory);
        }
        return normalized;
    }

    private void tossCategory(IInstallableUnit category) {
        MetadataRepository parent = (MetadataRepository)((EObject)category).eContainer();
        Builder builder = this.getBuilder();
        for (Contribution contrib : builder.getAggregator().getContributions(true)) {
            for (MappedRepository mappedRepo : contrib.getRepositories(true)) {
                if (mappedRepo.getMetadataRepository() != parent || !builder.isMapVerbatim(mappedRepo)) continue;
                LogUtils.debug((String)"Excluding %s from verbatim mapping since category %s has been normalized", (Object[])new Object[]{mappedRepo.getLocation(), category.getProperty("org.eclipse.equinox.p2.name")});
                builder.addMappingExclusion(mappedRepo);
            }
        }
    }
}

