/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.Profile;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.UnzipAction;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupzipAction
extends ProvisioningAction {
    private static final String UNZIPPED = "unzipped";
    public static final String ACTION_CLEANUPZIP = "cleanupzip";

    public IStatus execute(Map<String, Object> parameters) {
        return CleanupzipAction.cleanupzip(parameters, true);
    }

    public IStatus undo(Map<String, Object> parameters) {
        return UnzipAction.unzip(parameters, false);
    }

    public static IStatus cleanupzip(Map<String, Object> parameters, boolean restoreable) {
        String iuPropertyKey;
        String source = (String)parameters.get("source");
        if (source == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"source", (Object)ACTION_CLEANUPZIP));
        }
        String target = (String)parameters.get("target");
        if (target == null) {
            return Util.createError(NLS.bind((String)Messages.param_not_set, (Object)"target", (Object)ACTION_CLEANUPZIP));
        }
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        Profile profile = (Profile)parameters.get("profile");
        String unzipped = profile.getInstallableUnitProperty(iu, iuPropertyKey = new StringBuffer("unzipped|").append(source).append("|").append(target).toString());
        if (unzipped == null) {
            Map iuProperties = profile.getInstallableUnitProperties(iu);
            String sourcePrefix = new StringBuffer("unzipped|").append(source).append("|").toString();
            for (String key : iuProperties.keySet()) {
                if (!key.startsWith(sourcePrefix)) continue;
                if (unzipped == null) {
                    iuPropertyKey = key;
                    String storedTarget = key.substring(sourcePrefix.length());
                    unzipped = CleanupzipAction.substituteTarget(storedTarget, target, (String)iuProperties.get(key));
                    continue;
                }
                return Status.OK_STATUS;
            }
            if (unzipped == null) {
                return Status.OK_STATUS;
            }
        }
        IBackupStore store = restoreable ? (IBackupStore)parameters.get("backup") : null;
        StringTokenizer tokenizer = new StringTokenizer(unzipped, "|");
        ArrayList<File> directories = new ArrayList<File>();
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken();
            File file = new File(fileName);
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                directories.add(file);
                continue;
            }
            if (store != null) {
                try {
                    store.backup(file);
                    continue;
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.backup_file_failed, (Object)file.getPath()), (Throwable)e);
                }
            }
            file.delete();
        }
        for (File directory : directories) {
            if (store != null) {
                File[] children = directory.listFiles();
                if (children != null && children.length != 0) continue;
                try {
                    store.backupDirectory(directory);
                    continue;
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", 0, NLS.bind((String)Messages.backup_file_failed, (Object)directory.getPath()), (Throwable)e);
                }
            }
            directory.delete();
        }
        profile.removeInstallableUnitProperty(iu, iuPropertyKey);
        return Status.OK_STATUS;
    }

    private static String substituteTarget(String oldTarget, String newTarget, String value) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(value, "|");
        while (tokenizer.hasMoreTokens()) {
            String fileName = tokenizer.nextToken().trim();
            if (fileName.length() == 0) continue;
            if (fileName.startsWith(oldTarget)) {
                fileName = new StringBuffer(String.valueOf(newTarget)).append(fileName.substring(oldTarget.length())).toString();
            }
            buffer.append(fileName).append("|");
        }
        return buffer.toString();
    }
}

