/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.Messages;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.IExpressionParser;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataActivator
implements BundleActivator {
    public static final String PI_METADATA = "org.eclipse.equinox.p2.metadata";
    public static final String SERVICE_PRIORITY = "service.priority";
    public static MetadataActivator instance;
    private BundleContext context;
    private IExpressionFactory expressionFactory;
    private ServiceReference expressionFactoryReference;
    private IExpressionParser expressionParser;
    private ServiceReference expressionParserReference;

    public static BundleContext getContext() {
        MetadataActivator activator = instance;
        return activator == null ? null : activator.context;
    }

    public static IExpressionFactory getExpressionFactory() {
        MetadataActivator activator = instance;
        return activator == null ? null : activator._getExpressionFactory();
    }

    public static IExpressionParser getExpressionParser() {
        MetadataActivator activator = instance;
        return activator == null ? null : activator._getExpressionParser();
    }

    public void start(BundleContext aContext) throws Exception {
        this.context = aContext;
        instance = this;
    }

    public void stop(BundleContext aContext) throws Exception {
        instance = null;
        if (this.expressionFactoryReference != null) {
            aContext.ungetService(this.expressionFactoryReference);
            this.expressionFactoryReference = null;
            this.expressionFactory = null;
        }
        if (this.expressionParserReference != null) {
            aContext.ungetService(this.expressionParserReference);
            this.expressionParserReference = null;
            this.expressionParser = null;
        }
    }

    private ServiceReference getBestReference(Class<?> serviceInterface) {
        ServiceReference[] refs;
        String serviceName = serviceInterface.getName();
        try {
            refs = this.context.getAllServiceReferences(serviceName, null);
        }
        catch (InvalidSyntaxException e) {
            LogHelper.log((IStatus)new Status(4, this.context.getBundle().getSymbolicName(), new StringBuffer("Unable to obtain service references for service ").append(serviceName).toString(), (Throwable)e));
            return null;
        }
        if (refs == null) {
            return null;
        }
        ServiceReference best = null;
        int idx = refs.length;
        while (--idx >= 0) {
            ServiceReference ref = refs[idx];
            if (best == null) {
                best = ref;
                continue;
            }
            Integer refPrio = (Integer)ref.getProperty(SERVICE_PRIORITY);
            Integer bestPrio = (Integer)best.getProperty(SERVICE_PRIORITY);
            if (refPrio == null || bestPrio != null && bestPrio >= refPrio) continue;
            best = ref;
        }
        return best;
    }

    private synchronized IExpressionFactory _getExpressionFactory() {
        if (this.expressionFactory == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.p2.metadata.expression.IExpressionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.expressionFactoryReference = this.getBestReference(clazz);
            if (this.expressionFactoryReference == null) {
                throw new IllegalStateException(Messages.no_expression_factory);
            }
            this.expressionFactory = (IExpressionFactory)this.context.getService(this.expressionFactoryReference);
        }
        return this.expressionFactory;
    }

    private synchronized IExpressionParser _getExpressionParser() {
        if (this.expressionParser == null) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.p2.metadata.expression.IExpressionParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            this.expressionParserReference = this.getBestReference(clazz);
            if (this.expressionParserReference == null) {
                throw new IllegalStateException(Messages.no_expression_parser);
            }
            this.expressionParser = (IExpressionParser)this.context.getService(this.expressionParserReference);
        }
        return this.expressionParser;
    }
}

