/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.util;

import org.eclipse.b3.util.B3Util;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class LogUtils {
    public static final int DEBUG = 0;
    public static final int ERROR = 4;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    private static final int MAGIC = B3Util.getPluginID().hashCode();

    public static void debug(String msg, Object ... args) {
        LogUtils.log(0, msg, args);
    }

    public static void debug(Throwable t, String msg, Object ... args) {
        LogUtils.log(0, t, msg, args);
    }

    public static void error(String msg, Object ... args) {
        LogUtils.log(4, msg, args);
    }

    public static void error(Throwable t, String msg, Object ... args) {
        LogUtils.log(4, t, msg, args);
    }

    public static ILog getLog() {
        return Platform.getLog((Bundle)B3Util.getPlugin().getBundle());
    }

    public static void info(String msg, Object ... args) {
        LogUtils.log(1, msg, args);
    }

    public static void info(Throwable t, String msg, Object ... args) {
        LogUtils.log(1, t, msg, args);
    }

    public static void log(int level, String msg, Object ... args) {
        LogUtils.log(level, null, msg, args);
    }

    public static void log(int level, Throwable t, String msg, Object ... args) {
        LogUtils.getLog().log((IStatus)new Status(level, B3Util.getPluginID(), MAGIC, args == null || args.length == 0 ? msg : String.format(msg, args), t));
    }

    public static void warning(String msg, Object ... args) {
        LogUtils.log(2, msg, args);
    }

    public static void warning(Throwable t, String msg, Object ... args) {
        LogUtils.log(2, t, msg, args);
    }
}

