/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.b3.cli.builtin;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.b3.cli.AbstractCommand;
import org.eclipse.b3.cli.Headless;
import org.eclipse.b3.cli.helpers.ScriptLineParser;
import org.eclipse.b3.util.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class RunScript
extends AbstractCommand {
    private static final String SCRIPT_FILE_META_VAR = "<script file>";
    @Option(name="-c", aliases={"--continueonerror"}, usage="If this flag is set, script execution will continue after a command fails.")
    private boolean continueOnError;
    @Argument(required=true, multiValued=false, metaVar="<script file>")
    private List<String> args = new ArrayList<String>();

    public InputStream getHelpStream() {
        return new ByteArrayInputStream("Commands defined in the script file are launched sequentially. Following rules apply:\n- command is defined on a single line- parameters may be enclosed in quotes or double quotes- parameters may contain variables ${var}, $var or $env:var, ${env.var}- variables are expanded only if parameters are double quoted- parameters may contain escaped characters- \\t, \\r and \\n are replaced with tab, return or new line- empty lines and lines beginning with '#' are comments".getBytes());
    }

    public String getShortDescription() {
        return "Runs a set of commands from a script file";
    }

    public String getUsageTitle() {
        return String.valueOf(super.getUsageTitle()) + " " + SCRIPT_FILE_META_VAR;
    }

    protected int run(IProgressMonitor monitor) throws Exception {
        if (this.args.size() > 1) {
            throw new Exception("Only one script file may be specified");
        }
        InputStream is = null;
        String urlOrFile = this.args.get(0);
        try {
            URL scriptURL = new URL(urlOrFile);
            is = scriptURL.openStream();
        }
        catch (MalformedURLException e) {
            try {
                is = new FileInputStream(urlOrFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (is == null) {
            throw new Exception(String.valueOf(urlOrFile) + " is neither a valid accessible URL nor an existing accessible file");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ArrayList<String[]> parsedLines = new ArrayList<String[]>();
        try {
            String commandLine;
            while ((commandLine = reader.readLine()) != null) {
                if ((commandLine = StringUtils.trimmedOrNull((String)commandLine)) == null || commandLine.charAt(0) == '#') continue;
                ScriptLineParser parser = new ScriptLineParser(commandLine);
                ArrayList<String> commandArgs = new ArrayList<String>();
                while (parser.hasNext()) {
                    commandArgs.add(parser.next());
                }
                parsedLines.add(commandArgs.toArray(new String[commandArgs.size()]));
            }
        }
        finally {
            reader.close();
        }
        int result = AbstractCommand.EXIT_OK;
        try {
            monitor.beginTask("Executing script file...", parsedLines.size());
            for (String[] commandArgs : parsedLines) {
                monitor.subTask("Command '" + commandArgs[0] + "'");
                try {
                    if (Headless.run(commandArgs, false) == AbstractCommand.EXIT_OK) continue;
                    result = AbstractCommand.EXIT_ERROR;
                    if (this.continueOnError) continue;
                    break;
                }
                finally {
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }
}

