/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql.expression;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.osgi.framework.Filter;

final class Matches
extends org.eclipse.equinox.internal.p2.metadata.expression.Matches {
    private static boolean equals(String a, String b, int startPos, int endPos) {
        if (endPos - startPos != b.length()) {
            return false;
        }
        int bidx = 0;
        while (startPos < endPos) {
            if (a.charAt(startPos++) == b.charAt(bidx++)) continue;
            return false;
        }
        return true;
    }

    private static boolean matchLocaleVariants(Locale rval, String lval) {
        int uscore = lval.indexOf(95);
        if (uscore < 0) {
            return lval.equals(rval.getLanguage());
        }
        if (!Matches.equals(lval, rval.getLanguage(), 0, uscore)) {
            return false;
        }
        int countryStart = uscore + 1;
        return (uscore = lval.indexOf(95, countryStart)) < 0 ? Matches.equals(lval, rval.getCountry(), countryStart, lval.length()) : Matches.equals(lval, rval.getCountry(), countryStart, uscore) && Matches.equals(lval, rval.getVariant(), uscore + 1, lval.length());
    }

    Matches(Expression lhs, Expression rhs) {
        super(lhs, rhs);
    }

    protected boolean match(Object lval, Object rval) {
        if (rval instanceof IRequirement) {
            IRequirement requirement = (IRequirement)rval;
            if (lval instanceof IInstallableUnit) {
                return ((IInstallableUnit)lval).satisfies(requirement);
            }
        } else if (rval instanceof VersionRange) {
            if (lval instanceof Version) {
                return ((VersionRange)rval).isIncluded((Version)lval);
            }
        } else if (rval instanceof IUpdateDescriptor) {
            if (lval instanceof IInstallableUnit) {
                return ((IUpdateDescriptor)rval).isUpdateOf((IInstallableUnit)lval);
            }
        } else if (rval instanceof Filter) {
            if (lval instanceof IInstallableUnit) {
                return ((Filter)rval).match(new Hashtable(((IInstallableUnit)lval).getProperties()));
            }
            if (lval instanceof Dictionary) {
                return ((Filter)rval).match((Dictionary)lval);
            }
            if (lval instanceof Map) {
                return ((Filter)rval).match(new Hashtable((Map)lval));
            }
        } else if (rval instanceof Locale && lval instanceof String) {
            return Matches.matchLocaleVariants((Locale)rval, (String)lval);
        }
        return super.match(lval, rval);
    }
}

