/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.BundlePoolFilteredListener;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationMetadataRepositoryFactory;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryChangeListener;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.DirectoryWatcher;
import org.eclipse.equinox.internal.provisional.p2.directorywatcher.RepositoryListener;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.osgi.service.resolver.BundleDescription;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteListener
extends DirectoryChangeListener {
    public static final String SITE_POLICY = "org.eclipse.update.site.policy";
    public static final String SITE_LIST = "org.eclipse.update.site.list";
    private static final String FEATURES = "features";
    private static final String PLUGINS = "plugins";
    private static final String FEATURE_MANIFEST = "feature.xml";
    public static final Object UNINITIALIZED = "uninitialized";
    public static final Object INITIALIZING = "initializing";
    public static final Object INITIALIZED = "initialized";
    private String policy;
    private String[] list;
    private String siteLocation;
    private DirectoryChangeListener delegate;
    private String[] managedFiles;
    private String[] toBeRemoved;

    private static boolean contains(String[] plugins, File file) {
        String filename = file.getAbsolutePath();
        int i = 0;
        while (i < plugins.length) {
            if (filename.endsWith(new File(plugins[i]).toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static synchronized void synchronizeRepositories(ExtensionLocationMetadataRepository metadataRepository, ExtensionLocationArtifactRepository artifactRepository, File base) {
        try {
            Object factory;
            if (metadataRepository == null) {
                artifactRepository.reload();
                factory = new ExtensionLocationMetadataRepositoryFactory();
                factory.setAgent(artifactRepository.getProvisioningAgent());
                metadataRepository = (ExtensionLocationMetadataRepository)((ExtensionLocationMetadataRepositoryFactory)((Object)factory)).load(artifactRepository.getLocation(), 0, null);
            } else if (artifactRepository == null) {
                metadataRepository.reload();
                factory = new ExtensionLocationArtifactRepositoryFactory();
                factory.setAgent(metadataRepository.getProvisioningAgent());
                artifactRepository = (ExtensionLocationArtifactRepository)((ExtensionLocationArtifactRepositoryFactory)((Object)factory)).load(metadataRepository.getLocation(), 0, null);
            }
        }
        catch (ProvisionException e) {
            e.printStackTrace();
            return;
        }
        artifactRepository.state(INITIALIZING);
        metadataRepository.state(INITIALIZING);
        File plugins = new File(base, PLUGINS);
        File features = new File(base, FEATURES);
        DirectoryWatcher watcher = new DirectoryWatcher(new File[]{plugins, features});
        Object listener = new RepositoryListener(metadataRepository.metadataRepository, (IArtifactRepository)artifactRepository.artifactRepository);
        if (metadataRepository.getProperties().get(SITE_POLICY) != null) {
            listener = new SiteListener(metadataRepository.getProperties(), metadataRepository.getLocation().toString(), new BundlePoolFilteredListener((DirectoryChangeListener)listener));
        }
        watcher.addListener((DirectoryChangeListener)listener);
        watcher.poll();
        artifactRepository.state(INITIALIZED);
        metadataRepository.state(INITIALIZED);
    }

    public SiteListener(Map<String, String> properties, String url, DirectoryChangeListener delegate) {
        this.siteLocation = url;
        this.delegate = delegate;
        this.policy = properties.get(SITE_POLICY);
        HashSet<String> listCollection = new HashSet<String>();
        String listString = properties.get(SITE_LIST);
        if (listString != null) {
            StringTokenizer tokenizer = new StringTokenizer(listString, ",");
            while (tokenizer.hasMoreTokens()) {
                listCollection.add(tokenizer.nextToken());
            }
        }
        this.list = listCollection.toArray(new String[listCollection.size()]);
    }

    public boolean isInterested(File file) {
        if (!this.delegate.isInterested(file)) {
            return false;
        }
        if ("MANAGED-ONLY".equals(this.policy)) {
            return SiteListener.contains(this.getManagedFiles(), file);
        }
        if ("USER-EXCLUDE".equals(this.policy)) {
            if (SiteListener.contains(this.list, file)) {
                return false;
            }
        } else if ("USER-INCLUDE".equals(this.policy)) {
            if (!SiteListener.contains(this.list, file)) {
                return false;
            }
        } else {
            return false;
        }
        return !this.isToBeRemoved(file);
    }

    private boolean isToBeRemoved(File file) {
        String[] removed = this.getToBeRemoved();
        if (removed.length == 0) {
            return false;
        }
        Feature feature = this.getFeature(file);
        if (feature == null) {
            return false;
        }
        int i = 0;
        while (i < removed.length) {
            String line = removed[i];
            if (line.equals(new StringBuffer(String.valueOf(feature.getId())).append('_').append(feature.getVersion()).toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Feature getFeature(File location) {
        if (location.isFile()) {
            return null;
        }
        File manifest = new File(location, FEATURE_MANIFEST);
        if (!manifest.exists()) {
            return null;
        }
        FeatureParser parser = new FeatureParser();
        return parser.parse(location);
    }

    private String[] getToBeRemoved() {
        String urlString;
        Properties properties;
        block22: {
            if (this.toBeRemoved != null) {
                return this.toBeRemoved;
            }
            File configurationLocation = Activator.getConfigurationLocation();
            if (configurationLocation == null) {
                LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", "Unable to compute the configuration location."));
                this.toBeRemoved = new String[0];
                return this.toBeRemoved;
            }
            File toBeUninstalledFile = new File(configurationLocation, "org.eclipse.update/toBeUninstalled");
            if (!toBeUninstalledFile.exists()) {
                this.toBeRemoved = new String[0];
                return this.toBeRemoved;
            }
            this.toBeRemoved = new String[0];
            properties = new Properties();
            InputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(toBeUninstalledFile));
                    properties.load(input);
                }
                catch (IOException iOException) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException2) {}
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        if ((urlString = this.siteLocation).endsWith(".eclipseextension")) {
            urlString = urlString.substring(0, urlString.length() - ".eclipseextension".length());
        }
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<Object> e = properties.elements();
        while (e.hasMoreElements()) {
            StringTokenizer tokenizer;
            block23: {
                String line = (String)e.nextElement();
                tokenizer = new StringTokenizer(line, ";");
                String targetSite = tokenizer.nextToken();
                try {
                    if (!urlString.equals(URIUtil.fromString((String)targetSite).toString())) {
                    }
                    break block23;
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            result.add(tokenizer.nextToken());
        }
        this.toBeRemoved = result.toArray(new String[result.size()]);
        return this.toBeRemoved;
    }

    private String[] getManagedFiles() {
        File siteFile;
        if (this.managedFiles != null) {
            return this.managedFiles;
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            siteFile = URIUtil.toFile((URI)new URI(this.siteLocation));
        }
        catch (URISyntaxException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", new StringBuffer("Unable to create a URL from site location: ").append(this.siteLocation).toString(), (Throwable)e));
            return new String[0];
        }
        Map<String, File> pluginCache = this.getPlugins(siteFile);
        Map<File, Feature> featureCache = this.getFeatures(siteFile);
        for (File featureFile : featureCache.keySet()) {
            result.add(featureFile.toString());
            Feature feature = featureCache.get(featureFile);
            FeatureEntry[] entries = feature.getEntries();
            int inner = 0;
            while (inner < entries.length) {
                FeatureEntry entry = entries[inner];
                String key = new StringBuffer(String.valueOf(entry.getId())).append('/').append(entry.getVersion()).toString();
                File pluginLocation = pluginCache.get(key);
                if (pluginLocation != null) {
                    result.add(pluginLocation.toString());
                }
                ++inner;
            }
        }
        this.managedFiles = result.toArray(new String[result.size()]);
        return this.managedFiles;
    }

    private Map<File, Feature> getFeatures(File location) {
        HashMap<File, Feature> result = new HashMap<File, Feature>();
        File featureDir = new File(location, FEATURES);
        File[] children = featureDir.listFiles();
        int i = 0;
        while (i < children.length) {
            FeatureParser parser;
            Feature entry;
            File featureLocation = children[i];
            if (featureLocation.isDirectory() && featureLocation.getParentFile() != null && featureLocation.getParentFile().getName().equals(FEATURES) && new File(featureLocation, FEATURE_MANIFEST).exists() && (entry = (parser = new FeatureParser()).parse(featureLocation)) != null) {
                result.put(featureLocation, entry);
            }
            ++i;
        }
        return result;
    }

    private Map<String, File> getPlugins(File location) {
        File[] plugins = new File(location, PLUGINS).listFiles();
        HashMap<String, File> result = new HashMap<String, File>();
        int i = 0;
        while (plugins != null && i < plugins.length) {
            BundleDescription description;
            File bundleLocation = plugins[i];
            if ((bundleLocation.isDirectory() || bundleLocation.getName().endsWith(".jar")) && (description = BundlesAction.createBundleDescription((File)bundleLocation)) != null) {
                String id = description.getSymbolicName();
                String version = description.getVersion().toString();
                result.put(new StringBuffer(String.valueOf(id)).append('/').append(version).toString(), bundleLocation);
            }
            ++i;
        }
        return result;
    }

    public boolean added(File file) {
        return this.delegate.added(file);
    }

    public boolean changed(File file) {
        return this.delegate.changed(file);
    }

    public Long getSeenFile(File file) {
        return this.delegate.getSeenFile(file);
    }

    public boolean removed(File file) {
        return this.delegate.removed(file);
    }

    public void startPoll() {
        this.delegate.startPoll();
    }

    public void stopPoll() {
        this.delegate.stopPoll();
    }
}

