/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryIO;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.internal.p2.repository.RepositoryTransport;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactRepositoryFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeArtifactRepositoryFactory
extends ArtifactRepositoryFactory {
    private IArtifactRepositoryManager getManager() {
        if (this.getAgent() != null) {
            return (IArtifactRepositoryManager)this.getAgent().getService(IArtifactRepositoryManager.SERVICE_NAME);
        }
        return null;
    }

    public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        long time = 0L;
        if (Tracing.DEBUG_METADATA_PARSING) {
            Tracing.debug((String)new StringBuffer("Restoring artifact repository ").append(location).toString());
            time = -System.currentTimeMillis();
        }
        File localFile = null;
        boolean local = false;
        try {
            CompositeArtifactRepository compositeArtifactRepository;
            block29: {
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
                OutputStream artifacts = null;
                boolean compress = true;
                if ("file".equals(location.getScheme())) {
                    local = true;
                    localFile = URIUtil.toFile((URI)CompositeArtifactRepository.getActualLocation(location, true));
                    if (!localFile.exists()) {
                        localFile = URIUtil.toFile((URI)CompositeArtifactRepository.getActualLocation(location, false));
                        compress = false;
                    }
                } else {
                    if ((flags & 1) > 0) {
                        return null;
                    }
                    localFile = File.createTempFile("compositeArtifacts", ".xml");
                    try {
                        artifacts = new BufferedOutputStream(new FileOutputStream(localFile));
                        IStatus status = this.getTransport().download(CompositeArtifactRepository.getActualLocation(location, compress), artifacts, (IProgressMonitor)sub.newChild(100));
                        if (!status.isOK()) {
                            compress = false;
                            status = this.getTransport().download(CompositeArtifactRepository.getActualLocation(location, compress), artifacts, (IProgressMonitor)sub.newChild(100));
                            if (!status.isOK()) {
                                throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1000, status.getMessage(), null));
                            }
                        }
                    }
                    finally {
                        if (artifacts != null) {
                            artifacts.close();
                        }
                    }
                }
                FilterInputStream descriptorStream = null;
                try {
                    CompositeRepositoryIO io;
                    CompositeRepositoryState resultState;
                    descriptorStream = new BufferedInputStream(new FileInputStream(localFile));
                    if (compress) {
                        URI actualLocation = CompositeArtifactRepository.getActualLocation(location, false);
                        JarInputStream jInStream = new JarInputStream(descriptorStream);
                        JarEntry jarEntry = jInStream.getNextJarEntry();
                        String filename = URIUtil.lastSegment((URI)actualLocation);
                        while (jarEntry != null && filename != null && !filename.equals(jarEntry.getName())) {
                            jarEntry = jInStream.getNextJarEntry();
                        }
                        if (jarEntry == null) {
                            throw new IOException(NLS.bind((String)Messages.io_invalidLocation, (Object)actualLocation.getPath()));
                        }
                        descriptorStream = jInStream;
                    }
                    if ((resultState = (io = new CompositeRepositoryIO()).read(localFile.toURL(), (InputStream)descriptorStream, "compositeArtifactRepository", (IProgressMonitor)sub.newChild(100))).getLocation() == null) {
                        resultState.setLocation(location);
                    }
                    CompositeArtifactRepository result = new CompositeArtifactRepository(this.getManager(), resultState);
                    if (Tracing.DEBUG_METADATA_PARSING) {
                        Tracing.debug((String)new StringBuffer("Restoring artifact repository time (ms): ").append(time += System.currentTimeMillis()).toString());
                    }
                    compositeArtifactRepository = result;
                    if (descriptorStream == null) break block29;
                }
                catch (Throwable throwable) {
                    String msg;
                    try {
                        if (descriptorStream != null) {
                            ((InputStream)descriptorStream).close();
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1000, msg, (Throwable)e));
                    }
                    catch (IOException e) {
                        msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1002, msg, (Throwable)e));
                    }
                }
                ((InputStream)descriptorStream).close();
            }
            return compositeArtifactRepository;
        }
        finally {
            if (!local && localFile != null && !localFile.delete()) {
                localFile.deleteOnExit();
            }
        }
    }

    public IArtifactRepository create(URI location, String name, String type, Map<String, String> properties) {
        return new CompositeArtifactRepository(this.getManager(), location, name, properties);
    }

    private Transport getTransport() {
        return RepositoryTransport.getInstance();
    }
}

