/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.expression;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.metadata.expression.CollectionFilter;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.ExpressionFactory;
import org.eclipse.equinox.internal.p2.metadata.expression.IRepeatableIterator;
import org.eclipse.equinox.internal.p2.metadata.expression.Literal;
import org.eclipse.equinox.internal.p2.metadata.expression.MatchIteratorFilter;
import org.eclipse.equinox.internal.p2.metadata.expression.RepeatableIterator;
import org.eclipse.equinox.internal.p2.metadata.expression.WrappedIQuery;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionVisitor;
import org.eclipse.equinox.p2.metadata.index.IIndexProvider;
import org.eclipse.equinox.p2.query.IMatchQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Everything<T>
extends MatchIteratorFilter<T>
implements IRepeatableIterator<T> {
    private boolean atStart = true;
    private final Class<? extends T> elementClass;

    public Everything(Class<? extends T> elementClass, Collection<T> collection) {
        super(RepeatableIterator.create(collection == null ? CollectionUtils.emptyList() : collection));
        this.elementClass = elementClass;
    }

    public Everything(Class<? extends T> elementClass, Iterator<? extends T> iterator, Expression expression) {
        this(elementClass, iterator, Everything.needsRepeadedAccessToEverything(expression));
    }

    public Everything(Class<? extends T> elementClass, IIndexProvider<? extends T> indexProvider) {
        super(RepeatableIterator.create(indexProvider));
        this.elementClass = elementClass;
    }

    Everything(Class<? extends T> elementClass, Iterator<? extends T> iterator, boolean needsRepeat) {
        super(needsRepeat ? RepeatableIterator.create(iterator) : iterator);
        this.elementClass = elementClass;
    }

    @Override
    public IRepeatableIterator<T> getCopy() {
        Iterator iterator = this.getInnerIterator();
        if (iterator instanceof IRepeatableIterator) {
            return new Everything<T>(this.elementClass, ((IRepeatableIterator)iterator).getCopy(), false);
        }
        if (this.atStart) {
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T next() {
        this.atStart = false;
        return super.next();
    }

    public Class<? extends T> getElementClass() {
        return this.elementClass;
    }

    @Override
    public Object getIteratorProvider() {
        Iterator iterator = this.getInnerIterator();
        if (iterator instanceof IRepeatableIterator) {
            return ((IRepeatableIterator)iterator).getIteratorProvider();
        }
        return this;
    }

    @Override
    protected boolean isMatch(T val) {
        return this.elementClass.isInstance(val);
    }

    private static boolean needsRepeadedAccessToEverything(Expression expression) {
        final int[] accessCount = new int[1];
        expression.accept(new IExpressionVisitor(){
            int accessMultiplier = 1;

            public boolean visit(IExpression expr) {
                Expression queryArg;
                if (expr instanceof CollectionFilter) {
                    CollectionFilter cf = (CollectionFilter)expr;
                    if (cf.operand.accept(this)) {
                        ++this.accessMultiplier;
                        cf.lambda.accept(this);
                        --this.accessMultiplier;
                    }
                    return false;
                }
                if (expr == ExpressionFactory.EVERYTHING) {
                    accessCount[0] = accessCount[0] + this.accessMultiplier;
                    return false;
                }
                if (!(!(expr instanceof WrappedIQuery) || (queryArg = ((WrappedIQuery)expr).operands[0]) instanceof Literal && ((Literal)queryArg).value instanceof IMatchQuery)) {
                    accessCount[0] = accessCount[0] + this.accessMultiplier;
                }
                return true;
            }
        });
        return accessCount[0] > 1;
    }
}

