/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSUncoreDecorator
extends SolverDecorator<ISolver>
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int nborigvars;
    private int nbexpectedclauses;
    private int nbnewvar;
    private final IVecInt lits = new VecInt();
    private final IVecInt negLits = new VecInt();
    private int counter;

    public MSUncoreDecorator(ISolver iSolver) {
        super(iSolver);
    }

    @Override
    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
        super.setExpectedNumberOfClauses(n);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
        this.lits.ensure(n);
    }

    public int getExpectedNumberOfClauses() {
        return this.nbexpectedclauses;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = this.nborigvars + ++this.nbnewvar;
        this.lits.push(n);
        iVecInt.push(n);
        return super.addClause(iVecInt);
    }

    @Override
    public void reset() {
        this.nbnewvar = 0;
        this.lits.clear();
        super.reset();
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Override
    public Number calculateObjective() {
        return new Integer(this.counter);
    }

    @Override
    public Number getObjectiveValue() {
        return new Integer(this.counter);
    }

    @Override
    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    @Override
    public void discardCurrentSolution() throws ContradictionException {
        IVecInt iVecInt = this.unsatExplanation();
        VecInt vecInt = new VecInt(iVecInt.size());
        for (int i = 0; i < iVecInt.size(); ++i) {
            int n = iVecInt.get(i);
            vecInt.push(-n);
            this.negLits.remove(n);
        }
        this.addAtMost(vecInt, 1);
        ++this.counter;
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        if (this.negLits.isEmpty()) {
            for (int i = 0; i < this.lits.size(); ++i) {
                this.negLits.push(-this.lits.get(i));
            }
        }
        return this.admitABetterSolution(this.negLits);
    }

    @Override
    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        return !this.isSatisfiable(iVecInt, true);
    }
}

